/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.Extension;
import com.vmware.vim25.ExtensionClientInfo;
import com.vmware.vim25.ExtensionManagerIpAllocationUsage;
import com.vmware.vim25.ExtensionServerInfo;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NoClientCertificate;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.util.MorUtil;
import java.rmi.RemoteException;

public class ExtensionManager
extends ManagedObject {
    public ExtensionManager(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public Extension[] getExtensionList() {
        return (Extension[])this.getCurrentProperty("extensionList");
    }

    public ExtensionManagerIpAllocationUsage[] queryExtensionIpAllocationUsage(String[] extensionKeys) throws RuntimeFault, RemoteException {
        return this.getVimService().queryExtensionIpAllocationUsage(this.getMOR(), extensionKeys);
    }

    public void setExtensionCertificate(String extensionKey, String certificatePem) throws NotFound, NoClientCertificate, RuntimeFault, RemoteException {
        this.getVimService().setExtensionCertificate(this.getMOR(), extensionKey, certificatePem);
    }

    public ManagedEntity[] queryManagedBy(String extensionKey) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().queryManagedBy(this.getMOR(), extensionKey);
        return MorUtil.createManagedEntities(this.getServerConnection(), mors);
    }

    public void setPublicKey(String extensionKey, String publicKey) throws RuntimeFault, RemoteException {
        this.getVimService().setPublicKey(this.getMOR(), extensionKey, publicKey);
    }

    public void unregisterExtension(String keyStr) throws NotFound, RuntimeFault, RemoteException {
        if (keyStr == null) {
            throw new NullPointerException();
        }
        this.getVimService().unregisterExtension(this.getMOR(), keyStr);
    }

    public void updateExtension(Extension extension) throws NotFound, RuntimeFault, RemoteException {
        if (extension == null) {
            throw new NullPointerException();
        }
        this.encodeUrl(extension);
        this.getVimService().updateExtension(this.getMOR(), extension);
    }

    public void registerExtension(Extension extension) throws RuntimeFault, RemoteException {
        if (extension == null) {
            throw new NullPointerException();
        }
        this.encodeUrl(extension);
        this.getVimService().registerExtension(this.getMOR(), extension);
    }

    public Extension findExtension(String keyStr) throws RuntimeFault, RemoteException {
        if (keyStr == null) {
            throw new NullPointerException();
        }
        return this.getVimService().findExtension(this.getMOR(), keyStr);
    }

    private void encodeUrl(Extension extension) {
        int i2;
        for (i2 = 0; extension.client != null && i2 < extension.client.length; ++i2) {
            ExtensionClientInfo eci = extension.client[i2];
            if (eci.url.indexOf("&") == -1) continue;
            eci.url = eci.url.replaceAll("&", "&amp;");
        }
        for (i2 = 0; extension.server != null && i2 < extension.server.length; ++i2) {
            ExtensionServerInfo esi = extension.server[i2];
            if (esi.url.indexOf("&") == -1) continue;
            esi.url = esi.url.replaceAll("&", "&amp;");
        }
    }

    public void printAllExtensions() {
        Extension[] exts = this.getExtensionList();
        System.out.println("There are totally " + exts.length + " plugin(s) registered.");
        for (int i2 = 0; exts != null && i2 < exts.length; ++i2) {
            System.out.println("\n ---- Plugin # " + (i2 + 1) + " ---- ");
            System.out.println("Key: " + exts[i2].getKey());
            System.out.println("Version: " + exts[i2].getVersion());
            System.out.println("Registration Time: " + exts[i2].getLastHeartbeatTime().getTime());
            System.out.println("Configuration URL: " + exts[i2].getServer()[0].getUrl());
        }
    }
}

