/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ws.SoapConsts;
import com.vmware.vim25.ws.SoapFaultException;
import com.vmware.vim25.ws.XmlGen;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.doublecloud.ws.util.ReflectUtil;
import org.doublecloud.ws.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XmlGenDom
extends XmlGen {
    XmlGenDom() {
    }

    @Override
    public Object fromXML(String returnType, InputStream is) throws RemoteException {
        Element root = null;
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(is);
            root = doc.getRootElement();
        }
        catch (Exception e1) {
            throw new RemoteException("VI SDK invoke exception:" + e1);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        Element body = (Element)root.elements().get(0);
        Element resp = (Element)body.elements().get(0);
        if (resp.getName().indexOf("Fault") != -1) {
            SoapFaultException sfe = null;
            try {
                sfe = this.parseSoapFault(resp);
            }
            catch (Exception e2) {
                throw new RemoteException("Exception in WSClient.invoke:", e2);
            }
            if (sfe != null && sfe.detail != null) {
                throw (RemoteException)sfe.detail;
            }
            throw sfe;
        }
        if (returnType != null) {
            try {
                return this.fromXML(returnType, resp);
            }
            catch (Exception e3) {
                throw new RemoteException("Exception in WSClient.invoke:", e3);
            }
        }
        return null;
    }

    private SoapFaultException parseSoapFault(Element root) throws Exception {
        Element faultE;
        String faultTypeName;
        List subElems;
        SoapFaultException sfe = new SoapFaultException();
        sfe.setFaultCode(root.elementText("faultcode"));
        sfe.setFaultString(root.elementText("faultstring"));
        sfe.setFaultActor(root.elementText("faultactor"));
        Element detailE = root.element("detail");
        if (detailE != null && (subElems = detailE.elements()).size() != 0 && (faultTypeName = (faultE = (Element)subElems.get(0)).attributeValue(SoapConsts.XSI_TYPE)) != null) {
            sfe.detail = (Throwable)this.fromXml(TypeUtil.getVimClass(faultTypeName), faultE);
        }
        return sfe;
    }

    private Object fromXML(String type, Element root) throws Exception {
        List subNodes = root.elements();
        if (subNodes.size() == 0) {
            return null;
        }
        if (type.startsWith("ManagedObjectReference")) {
            if (!type.endsWith("[]")) {
                Element e2 = (Element)subNodes.get(0);
                return XmlGenDom.createMOR(e2.attributeValue("type"), e2.getText());
            }
            ManagedObjectReference[] mos = new ManagedObjectReference[subNodes.size()];
            for (int i2 = 0; i2 < subNodes.size(); ++i2) {
                Element elem = (Element)subNodes.get(i2);
                mos[i2] = XmlGenDom.createMOR(elem.attributeValue("type"), elem.getText());
            }
            return mos;
        }
        if (TypeUtil.isBasicType(type)) {
            ArrayList<String> vals = new ArrayList<String>();
            for (int i3 = 0; i3 < subNodes.size(); ++i3) {
                vals.add(((Element)subNodes.get(i3)).getText());
            }
            return ReflectUtil.parseToObject(type, vals);
        }
        if (type.endsWith("[]")) {
            String arrayItemTypeName = type.substring(0, type.length() - 2);
            Class<?> clazz = TypeUtil.getVimClass(arrayItemTypeName);
            Object ao = Array.newInstance(clazz, subNodes.size());
            for (int i4 = 0; i4 < subNodes.size(); ++i4) {
                Element e3 = (Element)subNodes.get(i4);
                String xsiType = e3.attributeValue(SoapConsts.XSI_TYPE);
                Object o2 = this.fromXml(TypeUtil.getVimClass(xsiType == null ? arrayItemTypeName : xsiType), (Element)subNodes.get(i4));
                Array.set(ao, i4, o2);
            }
            return ao;
        }
        return this.fromXml(TypeUtil.getVimClass(type), (Element)subNodes.get(0));
    }

    private Object fromXml(Class<?> clazz, Element node) throws Exception {
        Object obj = clazz.newInstance();
        List subNodes = node.elements();
        int sizeOfSubNodes = subNodes.size();
        for (int i2 = 0; i2 < sizeOfSubNodes; ++i2) {
            Object ao;
            Element e2 = (Element)subNodes.get(i2);
            String tagName = e2.getName();
            Field field = null;
            field = TypeUtil.isPrimitiveType(tagName) ? clazz.getField("_" + tagName) : clazz.getField(tagName);
            Class<?> fType = field.getType();
            boolean isFieldArray = fType.isArray();
            if (isFieldArray) {
                fType = fType.getComponentType();
            }
            Class<?> fRealType = fType;
            String xsiType = e2.attributeValue(SoapConsts.XSI_TYPE);
            if (xsiType != null && !xsiType.startsWith("xsd:")) {
                fRealType = TypeUtil.getVimClass(xsiType);
            }
            if (fRealType == ManagedObjectReference.class) {
                if (isFieldArray) {
                    int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i2, tagName);
                    ManagedObjectReference[] mos = new ManagedObjectReference[sizeOfFieldArray];
                    for (int j2 = 0; j2 < sizeOfFieldArray; ++j2) {
                        Element elem = (Element)subNodes.get(j2 + i2);
                        mos[j2] = XmlGenDom.createMOR(elem.attributeValue("type"), elem.getText());
                    }
                    field.set(obj, mos);
                    i2 = i2 + sizeOfFieldArray - 1;
                    continue;
                }
                field.set(obj, XmlGenDom.createMOR(e2.attributeValue("type"), e2.getText()));
                continue;
            }
            if (fRealType.isEnum()) {
                if (!isFieldArray) {
                    Object fo = Enum.valueOf(fRealType, e2.getText());
                    field.set(obj, fo);
                    continue;
                }
                int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i2, tagName);
                ao = Array.newInstance(fRealType, sizeOfFieldArray);
                for (int j3 = 0; j3 < sizeOfFieldArray; ++j3) {
                    String enumStr = ((Element)subNodes.get(j3 + i2)).getText();
                    Array.set(ao, j3, Enum.valueOf(fRealType, enumStr));
                }
                field.set(obj, ao);
                i2 = i2 + sizeOfFieldArray - 1;
                continue;
            }
            if (TypeUtil.isBasicType(fRealType)) {
                if (isFieldArray) {
                    int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i2, tagName);
                    ArrayList<String> values = new ArrayList<String>();
                    for (int j4 = 0; j4 < sizeOfFieldArray; ++j4) {
                        values.add(((Element)subNodes.get(j4 + i2)).getText());
                    }
                    String fTrueType = null;
                    if (xsiType != null) {
                        fTrueType = xsiType.substring("xsd:".length()) + "[]";
                    } else {
                        fTrueType = fRealType.getSimpleName();
                        if (!fTrueType.endsWith("[]")) {
                            fTrueType = fTrueType + "[]";
                        }
                    }
                    ReflectUtil.setObjectArrayField(obj, field, fTrueType, values);
                    i2 = i2 + sizeOfFieldArray - 1;
                    continue;
                }
                if (xsiType != null) {
                    xsiType = xsiType.substring("xsd:".length());
                    ReflectUtil.setObjectField(obj, field, xsiType, e2.getText());
                    continue;
                }
                ReflectUtil.setObjectField(obj, field, fRealType.getSimpleName(), e2.getText());
                continue;
            }
            if (isFieldArray) {
                int sizeOfFieldArray = XmlGenDom.getNumberOfSameTags(subNodes, sizeOfSubNodes, i2, tagName);
                ao = Array.newInstance(fType, sizeOfFieldArray);
                String fGenericType = fType.getSimpleName();
                for (int j5 = 0; j5 < sizeOfFieldArray; ++j5) {
                    Element elem = (Element)subNodes.get(j5 + i2);
                    String elemXsiType = elem.attributeValue(SoapConsts.XSI_TYPE);
                    String elemType = elemXsiType != null ? elemXsiType : fGenericType;
                    Object o2 = this.fromXml(TypeUtil.getVimClass(elemType), elem);
                    Array.set(ao, j5, o2);
                }
                field.set(obj, ao);
                i2 = i2 + sizeOfFieldArray - 1;
                continue;
            }
            Object o3 = this.fromXml(fRealType, e2);
            field.set(obj, o3);
        }
        return obj;
    }

    private static final int getNumberOfSameTags(List<Element> subNodes, int sizeOfSubNodes, int from, String tagName) {
        int numOfTags = 1;
        for (int j2 = from + 1; j2 < sizeOfSubNodes && subNodes.get(j2).getName().equals(tagName); ++j2) {
            ++numOfTags;
        }
        return numOfTags;
    }
}

