/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSet2ByteFixed
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverter2ByteFixed";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static final short CHARLENGTH = 2;
    static Class m_charConvSuperclass;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Aug_28_17:37:28_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    CharacterSet2ByteFixed(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        super(n2, jdbcCharacterConverters);
    }

    static CharacterSet2ByteFixed getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        if (jdbcCharacterConverters.getGroupId() == 6) {
            return new CharacterSet2ByteFixed(n2, jdbcCharacterConverters);
        }
        return null;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (characterWalker.bytes.length > characterWalker.next) {
            n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
            ++characterWalker.next;
        } else {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 182);
        }
        return n2;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        CharacterSet2ByteFixed.need(characterBuffer, 2);
        characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> 8 & 0xFF);
        characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 & 0xFF);
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

