/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xml.serialize.XML11Serializer;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMWriter;
import org.w3c.dom.ls.DOMWriterFilter;

public class DOMWriterImpl
implements DOMWriter,
DOMConfiguration {
    private String fEncoding;
    private XMLSerializer serializer = new XMLSerializer();
    private XML11Serializer xml11Serializer;

    public DOMWriterImpl() {
        this.initSerializer(this.serializer);
    }

    public DOMConfiguration getConfig() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setParameter(String string, Object object) throws DOMException {
        if (this.serializer.fFeatures.containsKey(string)) {
            if (!(object instanceof Boolean)) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string2);
            }
            if (!this.canSetParameter(string, object)) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string3);
            }
            this.serializer.fFeatures.put(string, object);
            if (string.equals("xml-declaration")) {
                this.serializer._format.setOmitXMLDeclaration((Boolean)object == false);
                return;
            }
            if (!string.equals("namespaces")) return;
            this.serializer.fNamespaces = object == Boolean.TRUE;
            return;
        }
        if (string.equals("error-handler")) {
            if (object instanceof DOMErrorHandler) {
                this.serializer.fDOMErrorHandler = (DOMErrorHandler)object;
                return;
            }
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string4);
        }
        if (!(string.equals("entity-resolver") || string.equals("schema-location") || string.equals("schema-type"))) {
            String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
            throw new DOMException(8, string5);
        }
        String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
        throw new DOMException(9, string6);
    }

    public boolean canSetParameter(String string, Object object) {
        if (string.equals("normalize-characters") && object == Boolean.TRUE) {
            return false;
        }
        if (string.equals("validate") && object == Boolean.TRUE) {
            return false;
        }
        if (string.equals("whitespace-in-element-content") && object == Boolean.FALSE) {
            return false;
        }
        if (string.equals("canonical-form") && object == Boolean.TRUE) {
            return false;
        }
        if (string.equals("format-pretty-print") && object == Boolean.TRUE) {
            return false;
        }
        return this.serializer.fFeatures.get(string) != null || string.equals("error-handler");
    }

    public Object getParameter(String string) throws DOMException {
        Object v2 = this.serializer.fFeatures.get(string);
        if (v2 == null) {
            if (string.equals("error-handler")) {
                return this.serializer.fDOMErrorHandler;
            }
            if (string.equals("entity-resolver") || string.equals("schema-location") || string.equals("schema-type")) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string2);
            }
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{string});
            throw new DOMException(8, string3);
        }
        return (Boolean)v2;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String string) {
        this.serializer._format.setEncoding(string);
        this.fEncoding = this.serializer._format.getEncoding();
    }

    public DOMErrorHandler getErrorHandler() {
        return this.serializer.fDOMErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        this.serializer.fDOMErrorHandler = dOMErrorHandler;
    }

    public boolean writeNode(OutputStream outputStream, Node node) {
        block12: {
            Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
            Method method = null;
            XMLSerializer xMLSerializer = null;
            String string = null;
            try {
                method = document.getClass().getMethod("getVersion", new Class[0]);
                if (method != null) {
                    string = (String)method.invoke((Object)document, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && string.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                xMLSerializer = this.xml11Serializer;
            } else {
                xMLSerializer = this.serializer;
            }
            this.checkAllFeatures(xMLSerializer);
            try {
                this.reset(xMLSerializer);
                xMLSerializer.setOutputByteStream(outputStream);
                if (node == null) {
                    return false;
                }
                if (node.getNodeType() == 9) {
                    xMLSerializer.serialize((Document)node);
                    break block12;
                }
                if (node.getNodeType() == 11) {
                    xMLSerializer.serialize((DocumentFragment)node);
                    break block12;
                }
                if (node.getNodeType() == 1) {
                    xMLSerializer.serialize((Element)node);
                    break block12;
                }
                return false;
            }
            catch (Exception exception) {
                if (xMLSerializer.fDOMErrorHandler == null) break block12;
                DOMErrorImpl dOMErrorImpl = new DOMErrorImpl();
                dOMErrorImpl.fException = exception;
                dOMErrorImpl.fMessage = exception.getMessage();
                dOMErrorImpl.fSeverity = 1;
                xMLSerializer.fDOMErrorHandler.handleError(dOMErrorImpl);
            }
        }
        return true;
    }

    public String writeToString(Node node) throws DOMException {
        StringWriter stringWriter;
        block12: {
            Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
            Method method = null;
            XMLSerializer xMLSerializer = null;
            String string = null;
            try {
                method = document.getClass().getMethod("getVersion", new Class[0]);
                if (method != null) {
                    string = (String)method.invoke((Object)document, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && string.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                xMLSerializer = this.xml11Serializer;
            } else {
                xMLSerializer = this.serializer;
            }
            this.checkAllFeatures(xMLSerializer);
            stringWriter = new StringWriter();
            try {
                this.reset(xMLSerializer);
                xMLSerializer.setOutputCharStream(stringWriter);
                if (node == null) {
                    return null;
                }
                if (node.getNodeType() == 9) {
                    xMLSerializer.serialize((Document)node);
                    break block12;
                }
                if (node.getNodeType() == 11) {
                    xMLSerializer.serialize((DocumentFragment)node);
                    break block12;
                }
                if (node.getNodeType() == 1) {
                    xMLSerializer.serialize((Element)node);
                    break block12;
                }
                return null;
            }
            catch (IOException iOException) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "STRING_TOO_LONG", new Object[]{iOException.getMessage()});
                throw new DOMException(2, string2);
            }
        }
        return stringWriter.toString();
    }

    public void setNewLine(String string) {
        this.serializer._format.setLineSeparator(string);
    }

    public String getNewLine() {
        return this.serializer._format.getLineSeparator();
    }

    public DOMWriterFilter getFilter() {
        return null;
    }

    public void setFilter(DOMWriterFilter dOMWriterFilter) {
        this.serializer.fDOMFilter = dOMWriterFilter;
    }

    private void reset(XMLSerializer xMLSerializer) {
        xMLSerializer.reset();
        xMLSerializer.fNSBinder.reset();
        xMLSerializer.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        xMLSerializer.fNamespaceCounter = 1;
    }

    private void checkAllFeatures(XMLSerializer xMLSerializer) {
        if (this.getParameter("whitespace-in-element-content") == Boolean.TRUE) {
            xMLSerializer._format.setPreserveSpace(true);
        } else {
            xMLSerializer._format.setPreserveSpace(false);
        }
    }

    private void initSerializer(XMLSerializer xMLSerializer) {
        xMLSerializer.fNamespaces = true;
        xMLSerializer.fNSBinder = new NamespaceSupport();
        xMLSerializer.fLocalNSBinder = new NamespaceSupport();
        xMLSerializer.fSymbolTable = new SymbolTable();
        xMLSerializer.fFeatures = new Hashtable();
        xMLSerializer.fFeatures.put("namespaces", Boolean.TRUE);
        xMLSerializer.fFeatures.put("normalize-characters", Boolean.FALSE);
        xMLSerializer.fFeatures.put("split-cdata-sections", Boolean.TRUE);
        xMLSerializer.fFeatures.put("validate", Boolean.FALSE);
        xMLSerializer.fFeatures.put("entities", Boolean.FALSE);
        xMLSerializer.fFeatures.put("whitespace-in-element-content", Boolean.TRUE);
        xMLSerializer.fFeatures.put("discard-default-content", Boolean.TRUE);
        xMLSerializer.fFeatures.put("canonical-form", Boolean.FALSE);
        xMLSerializer.fFeatures.put("format-pretty-print", Boolean.FALSE);
        xMLSerializer.fFeatures.put("xml-declaration", Boolean.TRUE);
        xMLSerializer.fFeatures.put("unknown-characters", Boolean.TRUE);
    }

    private void copySettings(XMLSerializer xMLSerializer, XMLSerializer xMLSerializer2) {
        xMLSerializer2._format.setOmitXMLDeclaration(xMLSerializer._format.getOmitXMLDeclaration());
        xMLSerializer2.fNamespaces = xMLSerializer.fNamespaces;
        xMLSerializer2.fDOMErrorHandler = xMLSerializer.fDOMErrorHandler;
        xMLSerializer2._format.setEncoding(xMLSerializer._format.getEncoding());
        xMLSerializer2._format.setLineSeparator(xMLSerializer._format.getLineSeparator());
        xMLSerializer2.fDOMFilter = xMLSerializer.fDOMFilter;
        Enumeration enumeration = xMLSerializer.fFeatures.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            Object v2 = xMLSerializer.fFeatures.get(k2);
            xMLSerializer2.fFeatures.put(k2, v2);
        }
    }
}

