/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import sun.swing.UIAction;

public class ToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    Timer enterTimer = new Timer(750, new insideTimerAction());
    Timer exitTimer;
    Timer insideTimer;
    String toolTipText;
    Point preferredLocation;
    JComponent insideComponent;
    MouseEvent mouseEvent;
    boolean showImmediately;
    private static final Object TOOL_TIP_MANAGER_KEY = new Object();
    transient Popup tipWindow;
    private Window window;
    JToolTip tip;
    private Rectangle popupRect = null;
    private Rectangle popupFrameRect = null;
    boolean enabled = true;
    private boolean tipShowing = false;
    private KeyStroke postTip;
    private KeyStroke hideTip;
    private Action postTipAction;
    private Action hideTipAction;
    private FocusListener focusChangeListener = null;
    private MouseMotionListener moveBeforeEnterListener = null;
    protected boolean lightWeightPopupEnabled = true;
    protected boolean heavyWeightPopupEnabled = false;

    ToolTipManager() {
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.postTip = KeyStroke.getKeyStroke(112, 2);
        this.postTipAction = new Actions(Actions.SHOW);
        this.hideTip = KeyStroke.getKeyStroke(27, 0);
        this.hideTipAction = new Actions(Actions.HIDE);
        this.moveBeforeEnterListener = new MoveBeforeEnterListener();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.hideTipWindow();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setInitialDelay(int n) {
        this.enterTimer.setInitialDelay(n);
    }

    public int getInitialDelay() {
        return this.enterTimer.getInitialDelay();
    }

    public void setDismissDelay(int n) {
        this.insideTimer.setInitialDelay(n);
    }

    public int getDismissDelay() {
        return this.insideTimer.getInitialDelay();
    }

    public void setReshowDelay(int n) {
        this.exitTimer.setInitialDelay(n);
    }

    public int getReshowDelay() {
        return this.exitTimer.getInitialDelay();
    }

    void showTipWindow() {
        Object object;
        if (this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        String string = UIManager.getString("ToolTipManager.enableToolTipMode");
        if ("activeApplication".equals(string) && ((KeyboardFocusManager)(object = KeyboardFocusManager.getCurrentKeyboardFocusManager())).getFocusedWindow() == null) {
            return;
        }
        if (this.enabled) {
            Point point = this.insideComponent.getLocationOnScreen();
            Point point2 = new Point();
            GraphicsConfiguration graphicsConfiguration = this.insideComponent.getGraphicsConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            boolean bl = SwingUtilities.isLeftToRight(this.insideComponent);
            this.hideTipWindow();
            this.tip = this.insideComponent.createToolTip();
            this.tip.setTipText(this.toolTipText);
            object = this.tip.getPreferredSize();
            if (this.preferredLocation != null) {
                point2.x = point.x + this.preferredLocation.x;
                point2.y = point.y + this.preferredLocation.y;
                if (!bl) {
                    point2.x -= ((Dimension)object).width;
                }
            } else {
                point2.x = point.x + this.mouseEvent.getX();
                point2.y = point.y + this.mouseEvent.getY() + 20;
                if (!bl && point2.x - ((Dimension)object).width >= 0) {
                    point2.x -= ((Dimension)object).width;
                }
            }
            if (this.popupRect == null) {
                this.popupRect = new Rectangle();
            }
            this.popupRect.setBounds(point2.x, point2.y, ((Dimension)object).width, ((Dimension)object).height);
            if (point2.x < rectangle.x) {
                point2.x = rectangle.x;
            } else if (point2.x - rectangle.x + ((Dimension)object).width > rectangle.width) {
                point2.x = rectangle.x + Math.max(0, rectangle.width - ((Dimension)object).width);
            }
            if (point2.y < rectangle.y) {
                point2.y = rectangle.y;
            } else if (point2.y - rectangle.y + ((Dimension)object).height > rectangle.height) {
                point2.y = rectangle.y + Math.max(0, rectangle.height - ((Dimension)object).height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            if (this.lightWeightPopupEnabled) {
                int n = this.getPopupFitHeight(this.popupRect, this.insideComponent);
                int n2 = this.getPopupFitWidth(this.popupRect, this.insideComponent);
                if (n2 > 0 || n > 0) {
                    popupFactory.setPopupType(1);
                } else {
                    popupFactory.setPopupType(0);
                }
            } else {
                popupFactory.setPopupType(1);
            }
            this.tipWindow = popupFactory.getPopup(this.insideComponent, this.tip, point2.x, point2.y);
            popupFactory.setPopupType(0);
            this.tipWindow.show();
            Window window = SwingUtilities.windowForComponent(this.insideComponent);
            this.window = SwingUtilities.windowForComponent(this.tip);
            if (this.window != null && this.window != window) {
                this.window.addMouseListener(this);
            } else {
                this.window = null;
            }
            this.insideTimer.start();
            this.tipShowing = true;
        }
    }

    void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.window != null) {
                this.window.removeMouseListener(this);
                this.window = null;
            }
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip = null;
            this.insideTimer.stop();
        }
    }

    public static ToolTipManager sharedInstance() {
        Object object = SwingUtilities.appContextGet(TOOL_TIP_MANAGER_KEY);
        if (object instanceof ToolTipManager) {
            return (ToolTipManager)object;
        }
        ToolTipManager toolTipManager = new ToolTipManager();
        SwingUtilities.appContextPut(TOOL_TIP_MANAGER_KEY, toolTipManager);
        return toolTipManager;
    }

    public void registerComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.addMouseListener(this);
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        jComponent.addMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(jComponent)) {
            InputMap inputMap = jComponent.getInputMap(0);
            ActionMap actionMap = jComponent.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.put(this.postTip, "postTip");
                inputMap.put(this.hideTip, "hideTip");
                actionMap.put("postTip", this.postTipAction);
                actionMap.put("hideTip", this.hideTipAction);
            }
        }
    }

    public void unregisterComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(jComponent)) {
            InputMap inputMap = jComponent.getInputMap(0);
            ActionMap actionMap = jComponent.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.remove(this.postTip);
                inputMap.remove(this.hideTip);
                actionMap.remove("postTip");
                actionMap.remove("hideTip");
            }
        }
    }

    private boolean shouldRegisterBindings(JComponent jComponent) {
        InputMap inputMap;
        for (inputMap = jComponent.getInputMap(0, false); inputMap != null && inputMap.size() == 0; inputMap = inputMap.getParent()) {
        }
        return inputMap != null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.initiateToolTip(mouseEvent);
    }

    private void initiateToolTip(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.window) {
            return;
        }
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        this.exitTimer.stop();
        Point point = mouseEvent.getPoint();
        if (point.x < 0 || point.x >= jComponent.getWidth() || point.y < 0 || point.y >= jComponent.getHeight()) {
            return;
        }
        if (this.insideComponent != null) {
            this.enterTimer.stop();
        }
        jComponent.removeMouseMotionListener(this);
        jComponent.addMouseMotionListener(this);
        boolean bl = this.insideComponent == jComponent;
        this.insideComponent = jComponent;
        if (this.tipWindow != null) {
            this.mouseEvent = mouseEvent;
            if (this.showImmediately) {
                boolean bl2;
                String string = jComponent.getToolTipText(mouseEvent);
                Point point2 = jComponent.getToolTipLocation(mouseEvent);
                boolean bl3 = this.preferredLocation != null ? this.preferredLocation.equals(point2) : (bl2 = point2 == null);
                if (!(bl && this.toolTipText.equals(string) && bl2)) {
                    this.toolTipText = string;
                    this.preferredLocation = point2;
                    this.showTipWindow();
                }
            } else {
                this.enterTimer.start();
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Window window;
        boolean bl = true;
        if (this.insideComponent == null) {
            // empty if block
        }
        if (this.window != null && mouseEvent.getSource() == this.window) {
            Container container = this.insideComponent.getTopLevelAncestor();
            if (container != null) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, this.window);
                point.x -= container.getX();
                point.y -= container.getY();
                point = SwingUtilities.convertPoint(null, point, this.insideComponent);
                bl = point.x < 0 || point.x >= this.insideComponent.getWidth() || point.y < 0 || point.y >= this.insideComponent.getHeight();
            }
        } else if (mouseEvent.getSource() == this.insideComponent && this.tipWindow != null && (window = SwingUtilities.getWindowAncestor(this.insideComponent)) != null) {
            Point point = SwingUtilities.convertPoint(this.insideComponent, mouseEvent.getPoint(), window);
            Rectangle rectangle = this.insideComponent.getTopLevelAncestor().getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            Point point2 = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point2, this.tip);
            rectangle.x = point2.x;
            rectangle.y = point2.y;
            rectangle.width = this.tip.getWidth();
            rectangle.height = this.tip.getHeight();
            bl = point.x < rectangle.x || point.x >= rectangle.x + rectangle.width || point.y < rectangle.y || point.y >= rectangle.y + rectangle.height;
        }
        if (bl) {
            this.enterTimer.stop();
            if (this.insideComponent != null) {
                this.insideComponent.removeMouseMotionListener(this);
            }
            this.insideComponent = null;
            this.toolTipText = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.exitTimer.restart();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
        this.insideComponent = null;
        this.mouseEvent = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.tipShowing) {
            this.checkForTipChange(mouseEvent);
        } else if (this.showImmediately) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            this.toolTipText = jComponent.getToolTipText(mouseEvent);
            if (this.toolTipText != null) {
                this.preferredLocation = jComponent.getToolTipLocation(mouseEvent);
                this.mouseEvent = mouseEvent;
                this.insideComponent = jComponent;
                this.exitTimer.stop();
                this.showTipWindow();
            }
        } else {
            this.insideComponent = (JComponent)mouseEvent.getSource();
            this.mouseEvent = mouseEvent;
            this.toolTipText = null;
            this.enterTimer.restart();
        }
    }

    private void checkForTipChange(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        String string = jComponent.getToolTipText(mouseEvent);
        Point point = jComponent.getToolTipLocation(mouseEvent);
        if (string != null || point != null) {
            this.mouseEvent = mouseEvent;
            if ((string != null && string.equals(this.toolTipText) || string == null) && (point != null && point.equals(this.preferredLocation) || point == null)) {
                if (this.tipWindow != null) {
                    this.insideTimer.restart();
                } else {
                    this.enterTimer.restart();
                }
            } else {
                this.toolTipText = string;
                this.preferredLocation = point;
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                    this.exitTimer.stop();
                } else {
                    this.enterTimer.restart();
                }
            }
        } else {
            this.toolTipText = null;
            this.preferredLocation = null;
            this.mouseEvent = null;
            this.insideComponent = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.restart();
        }
    }

    static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    private FocusListener createFocusChangeListener() {
        return new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ToolTipManager.this.hideTipWindow();
                ToolTipManager.this.insideComponent = null;
                JComponent jComponent = (JComponent)focusEvent.getSource();
                jComponent.removeFocusListener(ToolTipManager.this.focusChangeListener);
            }
        };
    }

    private int getPopupFitWidth(Rectangle rectangle, Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getWidthAdjust(container.getBounds(), rectangle);
                }
                if (!(container instanceof JApplet) && !(container instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point point = container.getLocationOnScreen();
                this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                return this.getWidthAdjust(this.popupFrameRect, rectangle);
            }
        }
        return 0;
    }

    private int getPopupFitHeight(Rectangle rectangle, Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getHeightAdjust(container.getBounds(), rectangle);
                }
                if (!(container instanceof JApplet) && !(container instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point point = container.getLocationOnScreen();
                this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                return this.getHeightAdjust(this.popupFrameRect, rectangle);
            }
        }
        return 0;
    }

    private int getHeightAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
            return 0;
        }
        return rectangle2.y + rectangle2.height - (rectangle.y + rectangle.height) + 5;
    }

    private int getWidthAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) {
            return 0;
        }
        return rectangle2.x + rectangle2.width - (rectangle.x + rectangle.width) + 5;
    }

    private void show(JComponent jComponent) {
        if (this.tipWindow != null) {
            this.hideTipWindow();
            this.insideComponent = null;
        } else {
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.stop();
            this.insideTimer.stop();
            this.insideComponent = jComponent;
            if (this.insideComponent != null) {
                this.toolTipText = this.insideComponent.getToolTipText();
                this.preferredLocation = new Point(10, this.insideComponent.getHeight() + 10);
                this.showTipWindow();
                if (this.focusChangeListener == null) {
                    this.focusChangeListener = this.createFocusChangeListener();
                }
                this.insideComponent.addFocusListener(this.focusChangeListener);
            }
        }
    }

    private void hide(JComponent jComponent) {
        this.hideTipWindow();
        jComponent.removeFocusListener(this.focusChangeListener);
        this.preferredLocation = null;
        this.insideComponent = null;
    }

    private static class Actions
    extends UIAction {
        private static String SHOW = "SHOW";
        private static String HIDE = "HIDE";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            JComponent jComponent = (JComponent)actionEvent.getSource();
            if (string == SHOW) {
                ToolTipManager.sharedInstance().show(jComponent);
            } else if (string == HIDE) {
                ToolTipManager.sharedInstance().hide(jComponent);
            }
        }

        public boolean isEnabled(Object object) {
            if (this.getName() == SHOW) {
                return true;
            }
            return ToolTipManager.sharedInstance().tipShowing;
        }
    }

    private class MoveBeforeEnterListener
    extends MouseMotionAdapter {
        private MoveBeforeEnterListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ToolTipManager.this.initiateToolTip(mouseEvent);
        }
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ToolTipManager.this.insideComponent != null && ToolTipManager.this.insideComponent.isShowing()) {
                if (ToolTipManager.this.toolTipText == null && ToolTipManager.this.mouseEvent != null) {
                    ToolTipManager.this.toolTipText = ToolTipManager.this.insideComponent.getToolTipText(ToolTipManager.this.mouseEvent);
                    ToolTipManager.this.preferredLocation = ToolTipManager.this.insideComponent.getToolTipLocation(ToolTipManager.this.mouseEvent);
                }
                if (ToolTipManager.this.toolTipText != null) {
                    ToolTipManager.this.showImmediately = true;
                    ToolTipManager.this.showTipWindow();
                } else {
                    ToolTipManager.this.insideComponent = null;
                    ToolTipManager.this.toolTipText = null;
                    ToolTipManager.this.preferredLocation = null;
                    ToolTipManager.this.mouseEvent = null;
                    ToolTipManager.this.hideTipWindow();
                }
            }
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.showImmediately = false;
        }
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.hideTipWindow();
            ToolTipManager.this.enterTimer.stop();
            ToolTipManager.this.showImmediately = false;
            ToolTipManager.this.insideComponent = null;
            ToolTipManager.this.mouseEvent = null;
        }
    }
}

