///
///	[FILENAME]	PnpCap.js
///
///	Pre-installation completion utility "PnPCapabilities Settings Tool" V1.00L10M00
///
///	Windows Scripting Host: JScript
///

// LAN Driver variables
var strLANContReg = "HKLM\\SYSTEM\\CurrentControlSet\\Control\\Class";
var strLANDriverReg = "{4D36E972-E325-11CE-BFC1-08002BE10318}";
var strPnPcap = "PnPCapabilities";
var PnPvalue = 272;
var strEnPME = "EnablePME"
var EnPEMvalue = "1"
var strWOL = "WakeOnLink"
var WOLvalue = "2"
var strLANHwID = "pci\\ven_8086&dev_1502";
var bFindLANReg = true;

Main();
function Main()
{
	var WSHShell;
	var strReg;
	var strKey;
	var strMer;

	/// Create Shell Object.
	WSHShell = WScript.CreateObject("WScript.Shell");
	var fs = WScript.CreateObject("Scripting.FileSystemObject");
	var strParentfolder = fs.GetFile( WScript.ScriptFullName ).ParentFolder;

	// Get LAN Regisrry
	retFindreg = WSHShell.Run( strParentfolder + "\\findreg.exe " + strLANDriverReg + " " +  strLANHwID, 0, true);

	if(retFindreg < 0)
	{
		bFindLANReg = false;
	}
	else
	{
	}

	strLANFindreg = MyformatNum(4, retFindreg);
	strFindLANReg = strLANContReg + "\\" + strLANDriverReg + "\\" + strLANFindreg + "\\";

	if(bFindLANReg)
	{
		// set Wake on LAN to Enable
		try
		{
			WSHShell.RegWrite( strFindLANReg + strPnPcap , PnPvalue, "REG_DWORD");
			WSHShell.RegWrite( strFindLANReg + strEnPME , EnPEMvalue, "REG_SZ");
			WSHShell.RegWrite( strFindLANReg + strWOL , WOLvalue, "REG_SZ");
		}
		catch (err)
		{
		}
	}


	WScript.Quit(0);

}

///===========================================
/// MyformatNum function
///===========================================
function MyformatNum(keta, num)
 {
	//Initialize
	var strnum = new String(num);
	var cnt = keta - strnum.length;
	var str = "";

	// If number of strnum is  longer than keta, return string
	if (cnt <= 0)
	{
		 return strnum;
	}

	// Add character "0" to str
	while (cnt-- > 0)
	{
		str += "0";
	}

	// return  string add 0 character
	return (str + strnum);

}

