///
/// [FILENAME]  wlan11a_off.js
///
/// Pre-installation completion utility "Wlan setting tool" V1.00L10M00
/// (C)2012 Panasonic Corporation
///
/// Windows Scripting Host: JScript
///
/// Common library version: Ver.1.15_2011-06-29_41200


///===========================================
/// Global variables
///===========================================

// -----------------------
// --- common settings ---
// -----------------------
var gDisableLog = false;

/// ===== Error Code =======
var Err_DriverInstall		= 1;
var Err_DriverUninstall		= 1<<2;
var Err_DeleteDriver		= 1<<3;
var Err_DeleteDir			= 1<<4;
var Err_MoveDir				= 1<<5;
var Err_HideDir				= 1<<6;
var Err_Hide_Tool			= 1<<8;
var Err_ExecCmd				= 1<<9;
var Err_Setting				= 1<<10;

/// ===== Create object  ======
var WSHShell = WScript.CreateObject("WScript.Shell");
var gFsObj = WScript.CreateObject("Scripting.FileSystemObject");

var gScriptName = WScript.ScriptFullName;
var gParentfolder = gFsObj.GetFile(gScriptName).ParentFolder;
var gWParentfolder = gFsObj.GetFile(gScriptName).ParentFolder.ParentFolder;

var gStdRegProv=null;


// --------------------------------
// --- device specific settings ---
// --------------------------------
var gDetectDeviceCmd = ""	// for xxxxx

// --- script specific Error code ---
var Err_WlanInstall	= 1<<16;

var gCmds = {
	JacksonPeak: {
		type:			"driver",
		reg_set:		Ctr_Cls_Reg,
		ctr_class_reg:	{
							reg_class:		"{4D36E972-E325-11CE-BFC1-08002BE10318}",
							searchTarget:	"MatchingDeviceId",
							searchPattern:	[/ven_8086/i, /dev_088e/i],
							settings:		[ ["WirelessMode", "32", "REG_SZ"] ]
						},
		dummy:			"terminator"
	},
	TaylorPeak: {
		type:			"driver",
		reg_set:		Ctr_Cls_Reg,
		ctr_class_reg:	{
							reg_class:		"{4D36E972-E325-11CE-BFC1-08002BE10318}",
							searchTarget:	"MatchingDeviceId",
							searchPattern:	[/ven_8086/i, /dev_0082/i],
							settings:		[ ["WirelessMode", "32", "REG_SZ"] ]
						},
		dummy:			"terminator"
	},
	RainbowPeak: {
		type:			"driver",
		reg_set:		Ctr_Cls_Reg,
		ctr_class_reg:	{
							reg_class:		"{4D36E972-E325-11CE-BFC1-08002BE10318}",
							searchTarget:	"MatchingDeviceId",
							searchPattern:	[/ven_8086/i, /dev_0091/i],
							settings:		[ ["WirelessMode", "32", "REG_SZ"] ]
						},
		dummy:			"terminator"
	},
	Dummy: {
		dummy:	"terminator"
	}
};


// Start Script
Main();


///===========================================
/// Main function
///===========================================
function Main()
{
	var errlevel = 0;

	Log("[Start Script]");


	// Intel
	errlevel |= gCmds.JacksonPeak.reg_set();
	errlevel |= gCmds.TaylorPeak.reg_set();
	errlevel |= gCmds.RainbowPeak.reg_set();


	Log("[End Script]");
	WScript.Quit(errlevel);
}


function Ctr_Cls_Reg()
{
	var errlevel = 0;


	errlevel |= CurrentControlSet_Control_Class_RegSet(
								this.ctr_class_reg.reg_class, this.ctr_class_reg.searchTarget,
								this.ctr_class_reg.searchPattern, this.ctr_class_reg.settings);

	return errlevel;
}


///===========================================
/// Log function
///===========================================
function Log(strFreeText)
{
	// Initialize
	var OpenText, objDate;
	var strDate = "";
	var ForAppending = 8;
	var strLogFileName = "";

	if(!gDisableLog) {
		// Get Log File Name
		strLogFileName = gScriptName.replace(/js$/,"log");

		// Get Date
		objDate = new Date();
		strDate += (objDate.getMonth() + 1) + "/";
		strDate += objDate.getDate() + "/"; 
		strDate += objDate.getYear() + "/";
		strDate += objDate.getHours()+ ":";
		strDate += objDate.getMinutes()+ ":"; 
		strDate += objDate.getSeconds();

		// Create Log File  
		if (gFsObj.FileExists(strLogFileName)) {
			// nothing to do
		} else {
			gFsObj.CreateTextFile(strLogFileName, true);
		}

		// Write Log File
		OpenText = gFsObj.OpenTextFile(strLogFileName, ForAppending, false);
		OpenText.WriteLine(strDate + " ::: " + strFreeText);
		OpenText.Close();
	}

	return 0;
}


function CurrentControlSet_Control_Class_RegSet(targetClass, matchingVal, matchingRe, settings)
{
	var errlevel = 0;
	var hit = false;

	var targetRootKey = 0x80000002;
	var targetKey = "SYSTEM\\CurrentControlSet\\Control\\Class\\" + targetClass;

	if(gStdRegProv==null) {
		Reg_Init();
	}

	Log("Start CurrentControlSet_Control_Class_RegSet()");

	var keys = Reg_EnumKey(gStdRegProv, targetRootKey, targetKey);
	if(keys!=null) {
		var desc = ""
		for(i=0; i<keys.length; i++) {
			desc = Reg_GetStringValue(gStdRegProv, targetRootKey, targetKey+"\\"+keys[i], matchingVal);
			if(desc != null) {
				var matchResult = true
				for(var ii=0; ii<matchingRe.length; ii++) {
					if(desc.match(matchingRe[ii])!=null) {
						matchResult &= true;
					} else {
						matchResult &= false;
					}
				}
				if(matchResult) {
					for(var ii=0; ii<settings.length; ii++) {
						try {
							WSHShell.RegWrite("HKLM\\"+targetKey+"\\"+keys[i]+"\\"+settings[ii][0], settings[ii][1], settings[ii][2]);
							Log("Wirte registory success.");
							hit = true;
						} catch(err) {
							Log("Wirte registory Error.");
						}
					}
				}
			}
		}
		if(!hit) {
			errlevel |= Err_Setting;
			Log("Target registory can't found.");
		}
	} else {
		Log("Target key does not exist.");
		errlevel |= Err_Setting;
	}

	Log("End CurrentControlSet_Control_Class_RegSet()");
	return errlevel;
}


function Reg_Init()
{
	var oLoc = new ActiveXObject("WbemScripting.SWbemLocator");
	var oSvc = oLoc.ConnectServer(null, "root\\default");

	gStdRegProv = oSvc.Get("StdRegProv");
}


// EnumKey
function Reg_EnumKey(regProv, hDefKey, path)
{
	var method = regProv.Methods_.Item ("EnumKey");
	var inParameter = method.InParameters.SpawnInstance_ ();
	inParameter.hDefKey = hDefKey;
	inParameter.sSubKeyName = path;
	var outParameter = regProv.ExecMethod_ (method.Name, inParameter);
	if (outParameter.sNames != null) {
		return outParameter.sNames.toArray();
	} else {
		return null;
	}
}


// GetStringValue
function Reg_GetStringValue(regProv, hDefKey, sSubKeyName, sValueName)
{
    var method = regProv.Methods_.Item ("GetStringValue");
    var inParameter = method.InParameters.SpawnInstance_ ();
    inParameter.hDefKey = hDefKey;
    inParameter.sSubKeyName = sSubKeyName;
    inParameter.sValueName = sValueName;
    var outParameter = regProv.ExecMethod_(method.Name, inParameter);
    return outParameter.sValue;
}


