summary     	: hp SNMP agent Package
name        	: hp-snmp-agents 
Version		: 8.1.0
Release		: 1
group       	: System Environment
source		: hp-snmp-agents.tar.gz	
license   	: 2008 Hewlett-Packard Development Company, L.P.
packager    	: Hewlett-Packard Company
vendor		: Hewlett-Packard Company
url         	: http://www.hp.com/go/proliantlinux
buildroot   	: /var/tmp/%{name}
icon		: hprpm.xpm
autoreqprov	: yes 
requires        : net-snmp, hp-health
conflicts	: cpqasm, cmasvr, cmafdtn, hpasm, cmanic, cmastor, cpqhealth, hprsm

%description
This package contains the SNMP server, storage, and nic agents for all 
hp Proliant systems with ASM, ILO, & ILO2 embedded management asics.  

%prep
########################################################################
%setup -n hp-snmp-agents
########################################################################

%build
########################################################################

%install
########################################################################
if [ $RPM_BUILD_ROOT != "/" ]; then
        rm -rf $RPM_BUILD_ROOT
fi

#export some variables
export RPM_BUILD_ROOT
export RPM_MAKE_ROOT=.
export RPM_NAME=%{name}

mkdir -p $RPM_BUILD_ROOT/hp-snmp-agents

#Everything over
cp -a * $RPM_BUILD_ROOT/.


########################################################################


%pre
########################################################################

#Upgrade - stop everything
if [ "$1" = "2" ]; then
   echo "Upgrade"
   if [ -f /etc/init.d/hp-snmp-agents ]; then
      /etc/init.d/hp-snmp-agents stop
   fi
   exit 0
fi

symbol_present()
{
   SYMBOL=$1
   shift
   BINLIST=$*

   for i in $BINLIST; do
      if [ -f $i ]; then
         if [ "x" != "x`grep $SYMBOL $i`" ]; then
            return 1
         fi
      fi
   done
   return 0
}

BINSTOCHECK="/usr/lib/libucdmibs.so* /usr/lib/libnetsnmpmibs.so* /usr/lib64/libucdmibs.so* /usr/lib64/libnetsnmpmibs.so*"

#Check whether we can link this cmaX stuff dynamically
symbol_present deinit_dlmod $BINSTOCHECK
RETVAL=$?

if [ $RETVAL -eq 0 ]; then
   echo "=============================================================================="
   echo "NOTE: It has been determined that your existing SNMP software stack"
   echo "will not work correctly with the management agents in this package."
   echo "Install a SNMP stack with the standard dlmod extension built in."
   echo "=============================================================================="
   exit 1
fi
exit 0

%post
########################################################################
sync

# copy csginkgo to where it will be used by hp-smh-templates
if [ -f /opt/hp/hpsmh/data/webapp-data/webagent/csginkgo ]; then
   cp /opt/hp/hp-snmp-agents/webagent/csginkgo /opt/hp/hpsmh/data/webapp-data/webagent/
fi

#install the init scripts
if [ -x /sbin/insserv ]; then
   /sbin/insserv -f hp-snmp-agents &>/dev/null
   /sbin/insserv -f snmpd &>/dev/null
elif [ -x /sbin/chkconfig ]; then
   /sbin/chkconfig --add hp-snmp-agents
   /sbin/chkconfig hp-snmp-agents on
   /sbin/chkconfig snmpd on
fi

# work around RHEL security
if [ -x /usr/sbin/selinuxenabled ]; then
   setsebool -P allow_ypbind=1
   chcon -t textrel_shlib_t /usr/lib/libcpqipmb.so 2> /dev/null
fi

# install any required SELinux files for proper operation
selinux_policy_module=/opt/hp/hp-snmp-agents/nic/etc/HPcmanic.pp
selinux_policy_cmd=/usr/sbin/semodule
if [ -f $selinux_policy_module ] && [ -f $selinux_policy_cmd ]
then
  echo "Installing $selinux_policy_module SELinux policy module"
  $selinux_policy_cmd -i $selinux_policy_module
fi

#This gives us a chance to override EVs etc.
if [ -f /etc/hp-snmp-agents.conf.rpmorig ]; then
	source /etc/hp-snmp-agents.conf.rpmorig
elif [ -f /etc/hp-snmp-agents.conf ]; then
	source /etc/hp-snmp-agents.conf
fi
  
STARTUP=""
CMASILENT=$(echo $CMASILENT | tr '[:lower:]' '[:upper:]')
CMAFDTNSILENT=$(echo $CMAFDTNSILENT | tr '[:lower:]' '[:upper:]')
if [ "$CMASILENT" = "YES" -o "$CMAFDTNSILENT" = "YES" ]; then
	STARTUP=`uname -r | egrep "$CMAKERNELVERSION"`
fi

RC=0
if [ ! -z "$STARTUP" ]; then
	/sbin/hpsnmpconfig
	RC=$?
        if [ $RC -eq 0 ]; then
           /etc/init.d/hp-snmp-agents start
        else
 	   echo "The hp SNMP Agents RPM installation failed!"
	   echo "See /var/spool/compaq/cma.log for Agent details."
        fi
else
	echo "=============================================================================="
	echo "NOTE: In order to activate the software contained in this package, you must"
	echo "      type '/sbin/hpsnmpconfig' as 'root' user." 
        echo "      Once configuration is completed start the agents by typing"
        echo "      /etc/init.d/hp-snmp-agents start"
	echo "=============================================================================="
fi
exit 0
########################################################################

%preun
########################################################################
sync
#
# We might be upgrading which in that case, we really do
# not want to do this.
#
if [ $1 -ne 0 -a $1 != "remove" ]; then
   exit 0
fi

#disable
sh /etc/init.d/hp-snmp-agents stop

#remove the init scripts
if [ -x /sbin/insserv ]; then
   /sbin/insserv -f -r hp-snmp-agents &>/dev/null
elif [ -x /sbin/chkconfig ]; then
   /sbin/chkconfig --del hp-snmp-agents
fi

# un-install any SELinux files we installed
selinux_policy_module=/opt/hp/hp-snmp-agents/nic/etc/HPcmanic.pp
selinux_policy_cmd=/usr/sbin/semodule
if [ -f $selinux_policy_module ] && [ -f $selinux_policy_cmd ]
then
  policy_module_name=`basename $selinux_policy_module .pp`
  echo "Un-installing $policy_module_name SELinux policy module"
  $selinux_policy_cmd -r $policy_module_name
fi

#undo the hp snmp config
/sbin/hpsnmpconfig undo

#remove distro.txt (deprecated, but might still be around from old install)
rm /opt/hp/hp-snmp-agents/distro.txt

#return snmpd.conf to original state if possible.
exit 0
########################################################################

%postun
########################################################################
exit 0
########################################################################

%clean
########################################################################
if [ $RPM_BUILD_ROOT != "/" ]; then
   rm -rf $RPM_BUILD_ROOT
fi
########################################################################

%files 
