#!/bin/sh
#

# Put the location of your version of the x source here:
XC="/development/work/xc"
# Current header version is: 4.3.0.dfsg.1-4 (Debian testing version)

if [ -d usr ]; then
  rm -r usr
fi

DEST="usr/X11R6/lib/Server/include"
mkdir -p ./${DEST}


FILES="scrnintstr.h
globals.h
pixmapstr.h
xf86_ansic.h
dixstruct.h
regionstr.h
XIstubs.h
bstorestr.h
misc.h
miscstruct.h
colormap.h
exevents.h
colormapst.h
input.h
xf86_libc.h
property.h
inputstr.h
os.h
cursor.h
resource.h
xf86Version.h
screenint.h
xf86Module.h
pixmap.h
gc.h
validate.h
dix.h
bstore.h
propertyst.h
region.h
window.h
opaque.h
xf86Opt.h"
for i in ${FILES}; do
  FROM="${XC}/programs/Xserver/include/${i}"
  TO="./${DEST}/${i}"
  cp ${FROM} ${TO}
  if [ $? -gt 0 ]; then
    echo "Can't find ${FROM}!"
    exit 1
  fi
done

FILES="xf86_OSproc.h"
for i in ${FILES}; do
  FROM="${XC}/programs/Xserver/hw/xfree86/os-support/${i}"
  TO="./${DEST}/${i}"
  cp ${FROM} ${TO}
  if [ $? -gt 0 ]; then
    echo "Can't find ${FROM}!"
    exit 1
  fi
done

FILES="mipointer.h"
for i in ${FILES}; do
  FROM="${XC}/programs/Xserver/mi/${i}"
  TO="./${DEST}/${i}"
  cp ${FROM} ${TO}
  if [ $? -gt 0 ]; then
    echo "Can't find ${FROM}!"
    exit 1
  fi
done

FILES="xf86str.h
xisb.h
xf86.h
xf86Xinput.h
xf86Pci.h"
for i in ${FILES}; do
  FROM="${XC}/programs/Xserver/hw/xfree86/common/${i}"
  TO="./${DEST}/${i}"
  cp ${FROM} ${TO}
  if [ $? -gt 0 ]; then
    echo "Can't find ${FROM}!"
    exit 1
  fi
done


# New relative destination
DEST="usr/X11R6/include/X11"
mkdir -p ./${DEST}

FILES="Xfuncproto.h
Xarch.h
Xalloca.h
Xdefs.h
Xfuncs.h"
for i in ${FILES}; do
  FROM="${XC}/include/${i}"
  TO="./${DEST}/${i}"
  cp ${FROM} ${TO}
  if [ $? -gt 0 ]; then
    echo "Can't find ${FROM}!"
    exit 1
  fi
done

# New relative destination
DEST="usr/X11R6/include/X11/extensions"
mkdir -p ./${DEST}
FILES="XI.h
XIproto.h"
for i in ${FILES}; do
  FROM="${XC}/include/extensions/${i}"
  TO="./${DEST}/${i}"
  cp ${FROM} ${TO}
  if [ $? -gt 0 ]; then
    echo "Can't find ${FROM}!"
    exit 1
  fi
done

# End
