<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html lang="<!.StringMappings=LANG_CODE>">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<!.StringMappings=LANG_CHARSET>"/>
<!.IfNotDefined=NDEBUG>
<!-- BEGIN_MULTIPLE_CSS_INCLUDE -->
<link rel="stylesheet" type="text/css" href="guido.css"/>
<link rel="stylesheet" type="text/css" href="default.css"/>
<link rel="stylesheet" type="text/css" href="blue_theme.css"/>
<link rel="stylesheet" type="text/css" href="diagnose.css"/>
<link rel="stylesheet" type="text/css" href="widgets.css"/>
<link rel="stylesheet" type="text/css" href="wizards.css"/>
<link rel="stylesheet" type="text/css" href="tree.css"/>
<link rel="stylesheet" type="text/css" href="moreinfo.css"/>
<link rel="stylesheet" type="text/css" href="mgmtinfo.css"/>
<link rel="stylesheet" type="text/css" href="dropdown.css"/>
<link rel="stylesheet" type="text/css" href="help.css"/>
<!-- END_MULTIPLE_CSS_INCLUDE -->
<!.Else>
<!-- BEGIN_SINGLE_CSS_INCLUDE -->
<link rel="stylesheet" type="text/css" href="main.css"/>
<!-- END_SINGLE_CSS_INCLUDE -->
<!.EndIf>

<script type="text/javascript">
<!.StringMappings=LOAD_HELP_STRING_MAPPINGS>
var STR_MORE_INFO = "STR_MORE_INFO";
s_t[STR_MORE_INFO] = "<!.StringMappings=STR_MORE_INFO>";
var STR_VIEW_STATUS_MESSAGES = "STR_VIEW_STATUS_MESSAGES";
s_t[STR_VIEW_STATUS_MESSAGES] = "<!.StringMappings=STR_STATUS_ALERTS>";
var STR_ACU = "STR_ACU";
s_t[STR_ACU] = "<!.StringMappings=STR_ACU>";
var STR_ARRAYS = "STR_ARRAYS";
s_t[STR_ARRAYS] = "<!.StringMappings=STR_ARRAYS>";
var STR_DRIVE_ERASE = "STR_DRIVE_ERASE";
s_t[STR_DRIVE_ERASE] = "<!.StringMappings=STR_DRIVE_ERASE>";
var STR_LOGICAL_DRIVE = "STR_LOGICAL_DRIVE";
s_t[STR_LOGICAL_DRIVE] = "<!.StringMappings=STR_LOGICAL_DRIVE>";
var STR_LOGICAL_DRIVES = "STR_LOGICAL_DRIVES";
s_t[STR_LOGICAL_DRIVES] = "<!.StringMappings=STR_LOGICAL_DRIVES>";
var STR_PHYSICAL_DRIVES = "STR_PHYSICAL_DRIVES";
s_t[STR_PHYSICAL_DRIVES] = "<!.StringMappings=STR_PHYSICAL_DRIVES>";
var STR_DUAL_DOMAIN = "STR_DUAL_DOMAIN";
s_t[STR_DUAL_DOMAIN] = "<!.StringMappings=STR_DUAL_DOMAIN>";
var GUI_NAME_FULL_STRIPE_SIZE = "GUI_NAME_FULL_STRIPE_SIZE";
s_t[GUI_NAME_FULL_STRIPE_SIZE] = "<!.StringMappings=GUI_NAME_FULL_STRIPE_SIZE>";
var STR_DISABLED = "STR_DISABLED";
s_t[STR_DISABLED] = "<!.StringMappings=STR_DISABLED>";
</script>
<!.IfNotDefined=NDEBUG>
<!-- START_MULTIPLE_JS_INCLUDE -->
<script src="buttonManager.js"></script>
<script src="storage_pres.js"></script>
<script src="str_maps.js"></script>
<script src="common.js"></script>
<script src="help.js"></script>
<!-- END_MULTIPLE_JS_INCLUDE -->
<!.Else>
<!-- START_SINGLE_JS_INCLUDE -->
<SCRIPT SRC="popup.js"></SCRIPT>
<!-- END_SINGLE_JS_INCLUDE -->
<!.EndIf>

<script type="text/javascript">
// Contains inline links to help content.
g_inlineLinks = new Array();
// Language code.
g_languageCode = "<!.StringMappings=LANG_CODE>";
// Global variable for history
var g_history = new Array();
var g_history_curPos = 0;
var g_history_sLinkName;

var g_currentPage;

function autoPrint()
{
   window.print();
   //window.close();
}
function printContents()
{
   // Get and Populate PRINTABLE_CONTAINER
   var sContent = "";
   sContent += g_currentPage.drawPrintableContent();
   document.getElementById("PRINTABLE_CONTAINER").innerHTML = sContent;

   // Printable page toggle
   document.getElementById("POPUP_CONTAINER").style.display="none";
   document.getElementById("PRINTABLE_CONTAINER").style.display="inline";
   window.print();
   setTimeout("document.getElementById('POPUP_CONTAINER').style.display='inline'",100);
   setTimeout("document.getElementById('PRINTABLE_CONTAINER').style.display='none'",100);

}

function HandleOnBeforePrint()
{
   document.getElementById("POPUP_CONTAINER").style.overflow="visible";
}
function HandleOnAfterPrint()
{
   document.getElementById("POPUP_CONTAINER").style.overflow="auto";
}

// Translates strings without creating CHintPresenter, which is why CStoragePresenter is not used.
// CHintPresenter requires strings that aren't used in the help system.
// Kept syntax for loading strings the same as what CStoragePresenter requires.
function CStringLoader()
{
   //public: return translated string
   this.LoadString = function(id)
   {
      var str = id;
      if (s_t[id] != null)
      {
         str = s_t[id];
      }
      return str;
   }
   
   //public: LoadString alias
   this.LS = this.LoadString;
}

var g_sp = new CStringLoader();
var g_isMoz = false;
if(window.navigator != null && window.navigator.userAgent.indexOf("ecko") != -1)
{
   g_isMoz = true;
}

// Creates an image with proper HTML tags
//
// Input:
//    sImgLocaation - File location of the image.
//    imgWidth - Image width.
//    imgHeight - Image height.
//    sOverlayImgLocation - File location of the bottom right overlay image.
//    sOverlayTLImgLocation - File location of the top left overlay image.
function drawImg(sImgLocation, imgWidth, imgHeight, sOverlayImgLocation, sOverlayTLImgLocation)
{
   var m_sImgHTML = '';
   m_sImgHTML += filterIcon(sImgLocation, imgWidth, imgHeight);
   if(sOverlayImgLocation)
   {
      m_sImgHTML += filterIcon(sOverlayImgLocation, '12px', '12px', 'overlay'); //"<img class='overlay' src='" + sOverlayImgLocation + "' />";
   }
   if(sOverlayTLImgLocation)
   {
      m_sImgHTML += filterIcon(sOverlayTLImgLocation, '12px', '12px', 'overlayTL');
   }
   return m_sImgHTML;
}

// Desc A simple table. Having this construct more easily allows us to separate 
//      internationalization from presentation. Since this table is read-only, 
//      it is not currently derived from CWidget. 
function CTable(sTableHeader, sVAlign)
{
   //var m_sHeader     = sTableHeader ? "<DIV STYLE=font-weight:bold;color:black;>" + g_sp.LS(sTableHeader) + "</DIV><BR/>" : "";
   var m_sHeader = sTableHeader;
   var m_rows        = new Array(); // indexed array of arrays
   var m_colwidths = new Array();   // indexed array
   var m_colaligns = new Array();   // indexed array - column text aligns
   var m_tablewidth = 0;
   var m_cols = 0;                  // number of columns
   var m_vAlign = sVAlign ? sVAlign : "top";

   this.getHeader = function()
   {
      return m_sHeader ? "<tr><td colspan='" + m_cols + "' style='font-weight:bold;color:black;text-align:center;border:1px solid #ccc;background-color:#ccc;margin-left:0px;padding:3px 5px;'>" + g_sp.LS(m_sHeader) + "</td></tr>" : "";
   }

   // Takes any number of arguments representing the width for each column. This function is optional - default is 'auto'
   this.ColumnWidths = function()
   {
      for(var i=0; i<arguments.length; i++){
         m_colwidths[m_colwidths.length] = arguments[i];
         m_tablewidth += arguments[i];
      }
   }

   this.ColumnAligns = function()
   {
      for (var i = 0; i < arguments.length; i++)
      {
         m_colaligns[m_colaligns.length] = arguments[i];
      }
   }

   // Takes any number of arguments representing column values. First row is automatically set as <th>, subsequent are <td>.
   this.Row = function()
   {
      var temp = new Array();
      for (var i = 0; i < arguments.length; i++)
         temp[temp.length] = g_sp.LS(arguments[i]);
      m_rows[m_rows.length] = temp;
      if (arguments.length > m_cols)
      {
         m_cols = arguments.length;
      }
   }

   // Returns the HTML representation of the table.
   this.draw = function()
   {
      //var content = m_sHeader;
      var content = "<table cellpadding='0' cellspacing='0' border='1' style='padding:2px; margin-bottom:10px; width:" + m_tablewidth + "px; line-height:1.2em; border-collapse:collapse; border:1px solid #ccc; font-size:100%;'>" + this.getHeader();

      // Row - first row is <th> and subsequent rows are <td>
      for (var i = 0; i < m_rows.length; ++i)
      {
         content += "<tr align='left'>";
         var cellType = i ? "td" : "th";
         for (var j = 0; j < m_rows[i].length; ++j)
         {
            var w = m_colwidths[j] ? m_colwidths[j] : "auto";
            var calign = m_colaligns[j] ? m_colaligns[j] : "left";
            content += "<" + cellType + " align='" + calign + "' style = 'border:1px solid #ccc;margin-left:0px;padding:3px 5px;vertical-align:" + m_vAlign + ";' valign='" + m_vAlign + "' width=" + w + ">" + m_rows[i][j] + "</" + cellType + ">";
         }
         content += "</tr>";
      }

      content += "</table>";
      return content;
   }
}

// -----------------------
// HOW TO ADD HELP CONTENT
// -----------------------
//
// 1. Create help page object (CHelpPage) in the array named 'help', which contains all the help pages indexed by the name of the help page.
//    Example:
//       help[HELP_PAGE_NAME] = new CHelpPage(HELP_PAGE_LINK_NAME, HELP_PAGE_HEADER);
//
// 2. Add content to help page by using CHelpPage's methods.
//    Example:
//       help[HELP_PAGE_NAME].p(HELP_PAGE_INSTRUCTIONS);
//
// 3. Add help page to a folder in the help tree.
//    Example:
//       help[HELP_FOLDER_NAME] = new CHelpFolder(HELP_FOLDER_LINK_NAME);
//       help[HELP_FOLDER_NAME].children(
//          HELP_PAGE_NAME,
//          HELP_PAGE_NAME_2,
//          HELP_PAGE_NAME_3);
//
// ------------------------------------------
// HOW TO MAKE HELP CONTENT CONTEXT SENSITIVE
// ------------------------------------------
//
// If the name of the help page is the name of an operation (e.g. OPERATION_WRITE_START_FLASH_DIRECTOR), and the page is added to the folder with the name
// of the tab that the operation exists under (e.g. STR_MAINTAIN), then when a user clicks on the Help icon link while the operation dialog is showing, context 
// sensitive help for that operation will be displayed in the help popup page.
//
// ---------------------------------
// HOW TO ADD DEFINITION TO GLOSSARY
// ---------------------------------
//
// Create help page object (CHelpPage) in the array named 'glossary', with the 3rd parameter to the CHelpPage constructor set to true.
// Add content to the help page and add the help page to the glossary folder (HELP_GLOSSARY) in the 'help' array.
//

var help = new Array();
var glossary = new Array();

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ADD HELP PAGE STEP 1: 
// Create CHelpPage object and add exceptions to strings matching for creating
// inline links here.
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
help[STR_WELCOME_TO_ACU] = new CHelpPage(STR_WELCOME_TO_ACU, STR_WELCOME_TO_ACU, false, true);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW] = new CHelpPage(STR_GETTING_STARTED_WITH_ACU_OVERVIEW, STR_GETTING_STARTED_WITH_ACU_OVERVIEW, false, true);
help[STR_KEYBOARD_CONTROLS] = new CHelpPage(STR_KEYBOARD_CONTROLS, STR_KEYBOARD_CONTROLS, false, true);
help[STR_KEYBOARD_SHORTCUTS] = new CHelpPage(STR_KEYBOARD_SHORTCUTS, STR_KEYBOARD_SHORTCUTS, false, true);
help[STR_MORE_INFO] = new CHelpPage(STR_MORE_INFO, STR_MORE_INFO, false, true, true);
help[STR_VIEW_STATUS_MESSAGES] = new CHelpPage(STR_VIEW_STATUS_MESSAGES, STR_VIEW_STATUS_MESSAGES, false, true);
help[STR_IMAGE_LEGEND] = new CHelpPage(STR_IMAGE_LEGEND, STR_IMAGE_LEGEND, false, true);
help[STR_CONFIGURATION_OVERVIEW] = new CHelpPage(STR_CONFIGURATION_OVERVIEW, STR_CONFIGURATION_OVERVIEW, false, true);
help[OPERATION_WRITE_CLEAR_CONFIGURATION] = new CHelpPage(OPERATION_WRITE_CLEAR_CONFIGURATION, OPERATION_WRITE_CLEAR_CONFIGURATION, false, true);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS] = new CHelpPage(OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS, OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS, false, true);
help[OPERATION_WRITE_MANAGE_ARRAY_ACCELERATOR] = new CHelpPage(OPERATION_WRITE_MANAGE_ARRAY_ACCELERATOR, OPERATION_WRITE_MANAGE_ARRAY_ACCELERATOR, false, true);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS] = new CHelpPage(OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS, OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS, false, true);
help[OPERATION_WRITE_SET_DRIVE_WRITE_CACHE] = new CHelpPage(OPERATION_WRITE_SET_DRIVE_WRITE_CACHE, OPERATION_WRITE_SET_DRIVE_WRITE_CACHE, false, true);
help[GUI_OP_WRITE_MANAGE_LICENSE_KEYS] = new CHelpPage(GUI_OP_WRITE_MANAGE_LICENSE_KEYS, GUI_OP_WRITE_MANAGE_LICENSE_KEYS, false, true);
help[OPERATION_WRITE_CREATE_ARRAY] = new CHelpPage(OPERATION_WRITE_CREATE_ARRAY, OPERATION_WRITE_CREATE_ARRAY, false, true);
// Duplicate Create Array to include it under multiple folders
var OPERATION_WRITE_CREATE_ARRAY_2 = "OPERATION_WRITE_CREATE_ARRAY_2";
s_t[OPERATION_WRITE_CREATE_ARRAY_2] = g_sp.LS(OPERATION_WRITE_CREATE_ARRAY);
help[OPERATION_WRITE_CREATE_ARRAY_2] = new CHelpPage(OPERATION_WRITE_CREATE_ARRAY_2, OPERATION_WRITE_CREATE_ARRAY_2, false, true);
help[OPERATION_WRITE_DISABLE_OTHER_CONTROLLER] = new CHelpPage(OPERATION_WRITE_DISABLE_OTHER_CONTROLLER, OPERATION_WRITE_DISABLE_OTHER_CONTROLLER, false, true);
help[GUI_OPERATION_REDUNDANCY_SETTINGS] = new CHelpPage(GUI_OPERATION_REDUNDANCY_SETTINGS, GUI_OPERATION_REDUNDANCY_SETTINGS, false, true);
help[OPERATION_WRITE_SET_BOOT_CONTROLLER] = new CHelpPage(OPERATION_WRITE_SET_BOOT_CONTROLLER, OPERATION_WRITE_SET_BOOT_CONTROLLER, false, true);
help[GUI_OP_WRITE_SET_BOOT_VOLUME] = new CHelpPage(GUI_OP_WRITE_SET_BOOT_VOLUME, GUI_OP_WRITE_SET_BOOT_VOLUME, false, true);
help[OPERATION_WRITE_DELETE_ARRAY] = new CHelpPage(OPERATION_WRITE_DELETE_ARRAY, OPERATION_WRITE_DELETE_ARRAY, false, true, true, [OPERATION_WRITE_DELETE_ARRAY]);
help[OPERATION_WRITE_MOVE_ARRAY] = new CHelpPage(OPERATION_WRITE_MOVE_ARRAY, OPERATION_WRITE_MOVE_ARRAY, false, true);
help[OPERATION_WRITE_SHRINK_ARRAY] = new CHelpPage(OPERATION_WRITE_SHRINK_ARRAY, OPERATION_WRITE_SHRINK_ARRAY, false, true);
help[OPERATION_WRITE_SPLIT_ARRAY] = new CHelpPage(OPERATION_WRITE_SPLIT_ARRAY, OPERATION_WRITE_SPLIT_ARRAY, false, true);
help[OPERATION_WRITE_JOIN_ARRAY] = new CHelpPage(OPERATION_WRITE_JOIN_ARRAY, OPERATION_WRITE_JOIN_ARRAY, false, true);
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE] = new CHelpPage(OPERATION_WRITE_CREATE_LOGICAL_DRIVE, OPERATION_WRITE_CREATE_LOGICAL_DRIVE, false, true);
// Duplicate Create Logical Drive to include it under multiple folders
var OPERATION_WRITE_CREATE_LOGICAL_DRIVE_2 = "OPERATION_WRITE_CREATE_LOGICAL_DRIVE_2";
s_t[OPERATION_WRITE_CREATE_LOGICAL_DRIVE_2] = g_sp.LS(OPERATION_WRITE_CREATE_LOGICAL_DRIVE);
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE_2] = new CHelpPage(OPERATION_WRITE_CREATE_LOGICAL_DRIVE_2, OPERATION_WRITE_CREATE_LOGICAL_DRIVE_2, false, true);
help[OPERATION_WRITE_EXPAND_ARRAY] = new CHelpPage(OPERATION_WRITE_EXPAND_ARRAY, OPERATION_WRITE_EXPAND_ARRAY, false, true);
help[OPERATION_WRITE_MANAGE_SPARE_DRIVE] = new CHelpPage(OPERATION_WRITE_MANAGE_SPARE_DRIVE, OPERATION_WRITE_MANAGE_SPARE_DRIVE, false, true);
help[OPERATION_WRITE_ERASE_DRIVE] = new CHelpPage(OPERATION_WRITE_ERASE_DRIVE, OPERATION_WRITE_ERASE_DRIVE, false, true);
help[OPERATION_WRITE_DELETE_LOGICAL_DRIVE] = new CHelpPage(OPERATION_WRITE_DELETE_LOGICAL_DRIVE, OPERATION_WRITE_DELETE_LOGICAL_DRIVE, false, true, true, [OPERATION_WRITE_DELETE_LOGICAL_DRIVE]);
help[OPERATION_WRITE_EXTEND_LOGICAL_DRIVE] = new CHelpPage(OPERATION_WRITE_EXTEND_LOGICAL_DRIVE, OPERATION_WRITE_EXTEND_LOGICAL_DRIVE, false, true);
help[OPERATION_WRITE_MIGRATE_LOGICAL_DRIVE] = new CHelpPage(OPERATION_WRITE_MIGRATE_LOGICAL_DRIVE, OPERATION_WRITE_MIGRATE_LOGICAL_DRIVE, false, true);
help[OPERATION_WRITE_REENABLE_LOGICAL_DRIVE] = new CHelpPage(OPERATION_WRITE_REENABLE_LOGICAL_DRIVE, OPERATION_WRITE_REENABLE_LOGICAL_DRIVE, false, true);
help[STR_SSP_OVERVIEW] = new CHelpPage(STR_SSP_OVERVIEW, STR_SSP_OVERVIEW, false, true);
help[STR_DIAGNOSTICS_OVERVIEW] = new CHelpPage(STR_DIAGNOSTICS_OVERVIEW, STR_DIAGNOSTICS_OVERVIEW, false, true);
help[STR_WIZARDS_OVERVIEW] = new CHelpPage(STR_WIZARDS_OVERVIEW, STR_WIZARDS_OVERVIEW, false, true);
glossary[HELP_GLOSSARY_ACTIVE_SPARE] = new CHelpPage(HELP_GLOSSARY_ACTIVE_SPARE, HELP_GLOSSARY_ACTIVE_SPARE, true, true);
glossary[STR_ACU] = new CHelpPage(STR_ACU, STR_ACU, true, true);
glossary[HELP_GLOSSARY_ADAPTER_ID] = new CHelpPage(HELP_GLOSSARY_ADAPTER_ID, HELP_GLOSSARY_ADAPTER_ID, true, true, true);
glossary[HELP_GLOSSARY_ADVANCED_CAPACITY_EXPANSION] = new CHelpPage(HELP_GLOSSARY_ADVANCED_CAPACITY_EXPANSION, HELP_GLOSSARY_ADVANCED_CAPACITY_EXPANSION, true, true);
glossary[HELP_GLOSSARY_ADVANCED_CONTROLLER_SETTINGS] = new CHelpPage(HELP_GLOSSARY_ADVANCED_CONTROLLER_SETTINGS, HELP_GLOSSARY_ADVANCED_CONTROLLER_SETTINGS, true, true);
glossary[STR_ARRAY] = new CHelpPage(STR_ARRAY, STR_ARRAY, true, true, false, [STR_ARRAY_CONTROLLER, HELP_GLOSSARY_ARRAY_CONFIGURATION_UTILITY, HELP_LINK_EXCEPTION_ARRAY_OF_INEXPENSIVE_DISKS]);
glossary[HELP_GLOSSARY_ARRAY_CONFIGURATION_UTILITY] = new CHelpPage(HELP_GLOSSARY_ARRAY_CONFIGURATION_UTILITY, HELP_GLOSSARY_ARRAY_CONFIGURATION_UTILITY, true, true);
glossary[ATTR_NAME_ARRAY_ACCELERATOR] = new CHelpPage(ATTR_NAME_ARRAY_ACCELERATOR, ATTR_NAME_ARRAY_ACCELERATOR, true, true);
glossary[ATTR_NAME_IS_BOOT_CONTROLLER] = new CHelpPage(ATTR_NAME_IS_BOOT_CONTROLLER, ATTR_NAME_IS_BOOT_CONTROLLER, true, true);
glossary[STR_BOOTABLE_VOLUME] = new CHelpPage(STR_BOOTABLE_VOLUME, STR_BOOTABLE_VOLUME, true, true);
glossary[HELP_GLOSSARY_CAPACITY_EXPANSION] = new CHelpPage(HELP_GLOSSARY_CAPACITY_EXPANSION, HELP_GLOSSARY_CAPACITY_EXPANSION, true, true);
glossary[ATTR_NAME_CONNECTION_NAME] = new CHelpPage(ATTR_NAME_CONNECTION_NAME, ATTR_NAME_CONNECTION_NAME, true, true);
glossary[HELP_GLOSSARY_CONTROLLER_DUPLEXING] = new CHelpPage(HELP_GLOSSARY_CONTROLLER_DUPLEXING, HELP_GLOSSARY_CONTROLLER_DUPLEXING, true, true);
glossary[STR_DUAL_DOMAIN] = new CHelpPage(STR_DUAL_DOMAIN, STR_DUAL_DOMAIN, true, true);
glossary[ATTR_NAME_EXPAND_PRIORITY] = new CHelpPage(ATTR_NAME_EXPAND_PRIORITY, ATTR_NAME_EXPAND_PRIORITY, true, true);
glossary[ATTR_NAME_RAID] = new CHelpPage(ATTR_NAME_RAID, ATTR_NAME_RAID, true, true);
glossary[ATTR_NAME_HOST_MODE] = new CHelpPage(ATTR_NAME_HOST_MODE, ATTR_NAME_HOST_MODE, true, true);
glossary[STR_DRIVE_ERASE] = new CHelpPage(STR_DRIVE_ERASE, STR_DRIVE_ERASE, true, true);
glossary[HELP_GLOSSARY_LOGICAL_DRIVE_EXTENSION] = new CHelpPage(HELP_GLOSSARY_LOGICAL_DRIVE_EXTENSION, HELP_GLOSSARY_LOGICAL_DRIVE_EXTENSION, true, true);
glossary[STR_LOGICAL_DRIVE] = new CHelpPage(STR_LOGICAL_DRIVE, STR_LOGICAL_DRIVE, true, true);
glossary[HELP_GLOSSARY_MAXIMUM_BOOT_SIZE] = new CHelpPage(HELP_GLOSSARY_MAXIMUM_BOOT_SIZE, HELP_GLOSSARY_MAXIMUM_BOOT_SIZE, true, true);
glossary[ATTR_NAME_QUEUE_DEPTH] = new CHelpPage(ATTR_NAME_QUEUE_DEPTH, ATTR_NAME_QUEUE_DEPTH, true, true);
glossary[HELP_GLOSSARY_MIGRATION] = new CHelpPage(HELP_GLOSSARY_MIGRATION, HELP_GLOSSARY_MIGRATION, true, true);
glossary[ATTR_NAME_MNP_DELAY] = new CHelpPage(ATTR_NAME_MNP_DELAY, ATTR_NAME_MNP_DELAY, true, true);
glossary[OPERATION_WRITE_MOVE_ARRAY] = new CHelpPage(OPERATION_WRITE_MOVE_ARRAY, OPERATION_WRITE_MOVE_ARRAY, true, true);
glossary[HELP_GLOSSARY_NPG] = new CHelpPage(HELP_GLOSSARY_NPG, HELP_GLOSSARY_NPG, true, true);
glossary[HELP_GLOSSARY_ONLINE_RECOVERY_SERVER] = new CHelpPage(HELP_GLOSSARY_ONLINE_RECOVERY_SERVER, HELP_GLOSSARY_ONLINE_RECOVERY_SERVER, true, true);
glossary[HELP_GLOSSARY_ONLINE_SPARE] = new CHelpPage(HELP_GLOSSARY_ONLINE_SPARE, HELP_GLOSSARY_ONLINE_SPARE, true, true);
glossary[HELP_GLOSSARY_PARITY_GROUP] = new CHelpPage(HELP_GLOSSARY_PARITY_GROUP, HELP_GLOSSARY_PARITY_GROUP, true, true);
glossary[STR_PHYSICAL_DRIVE] = new CHelpPage(STR_PHYSICAL_DRIVE, STR_PHYSICAL_DRIVE, true, true);
glossary[ATTR_NAME_ELEVATOR_SORT] = new CHelpPage(ATTR_NAME_ELEVATOR_SORT, ATTR_NAME_ELEVATOR_SORT, true, true);
glossary[ATTR_NAME_PORT] = new CHelpPage(ATTR_NAME_PORT, ATTR_NAME_PORT, true, true, true);
glossary[ATTR_NAME_BOOT_VOLUME_PRIMARY] = new CHelpPage(ATTR_NAME_BOOT_VOLUME_PRIMARY, ATTR_NAME_BOOT_VOLUME_PRIMARY, true, true, false);
glossary[ATTR_NAME_BOOT_VOLUME_SECONDARY] = new CHelpPage(ATTR_NAME_BOOT_VOLUME_SECONDARY, ATTR_NAME_BOOT_VOLUME_SECONDARY, true, true, false);
glossary[HELP_GLOSSARY_RAID] = new CHelpPage(HELP_GLOSSARY_RAID, HELP_GLOSSARY_RAID, true, true);
glossary[ATTR_VALUE_RAID_0] = new CHelpPage(ATTR_VALUE_RAID_0, ATTR_VALUE_RAID_0, true, true);
glossary[ATTR_VALUE_RAID_1] = new CHelpPage(ATTR_VALUE_RAID_1, ATTR_VALUE_RAID_1, true, true, false, [ATTR_VALUE_RAID_10]);
glossary[ATTR_VALUE_RAID_10] = new CHelpPage(ATTR_VALUE_RAID_10, ATTR_VALUE_RAID_10, true, true);
glossary[ATTR_VALUE_RAID_4] = new CHelpPage(ATTR_VALUE_RAID_4, ATTR_VALUE_RAID_4, true, true);
glossary[ATTR_VALUE_RAID_5] = new CHelpPage(ATTR_VALUE_RAID_5, ATTR_VALUE_RAID_5, true, true, false, [ATTR_VALUE_RAID_50]);
glossary[ATTR_VALUE_RAID_50] = new CHelpPage(ATTR_VALUE_RAID_50, ATTR_VALUE_RAID_50, true, true);
glossary[ATTR_VALUE_RAID_6] = new CHelpPage(ATTR_VALUE_RAID_6, ATTR_VALUE_RAID_6, true, true, false, [ATTR_VALUE_RAID_60]);
glossary[ATTR_VALUE_RAID_60] = new CHelpPage(ATTR_VALUE_RAID_60, ATTR_VALUE_RAID_60, true, true);
glossary[ATTR_NAME_DEGRADED_PERFORMANCE_OPTIMIZATION] = new CHelpPage(ATTR_NAME_DEGRADED_PERFORMANCE_OPTIMIZATION, ATTR_NAME_DEGRADED_PERFORMANCE_OPTIMIZATION, true, true);
glossary[ATTR_NAME_INCONSISTENCY_REPAIR_POLICY] = new CHelpPage(ATTR_NAME_INCONSISTENCY_REPAIR_POLICY, ATTR_NAME_INCONSISTENCY_REPAIR_POLICY, true, true);
glossary[HELP_GLOSSARY_RAID_OVERHEAD] = new CHelpPage(HELP_GLOSSARY_RAID_OVERHEAD, HELP_GLOSSARY_RAID_OVERHEAD, true, true);
glossary[ATTR_NAME_REBUILD_PRIORITY] = new CHelpPage(ATTR_NAME_REBUILD_PRIORITY, ATTR_NAME_REBUILD_PRIORITY, true, true);
glossary[HELP_GLOSSARY_REDUNDANT_CONTROLLERS] = new CHelpPage(HELP_GLOSSARY_REDUNDANT_CONTROLLERS, HELP_GLOSSARY_REDUNDANT_CONTROLLERS, true, true);
glossary[ATTR_VALUE_BUS_TYPE_SCSI] = new CHelpPage(ATTR_VALUE_BUS_TYPE_SCSI, ATTR_VALUE_BUS_TYPE_SCSI, true, true);
glossary[HELP_GLOSSARY_SCSI_ID] = new CHelpPage(HELP_GLOSSARY_SCSI_ID, HELP_GLOSSARY_SCSI_ID, true, true);
glossary[GUI_OPERATION_WRITE_SSP] = new CHelpPage(GUI_OPERATION_WRITE_SSP, GUI_OPERATION_WRITE_SSP, true, true);
glossary[OPERATION_WRITE_SHRINK_ARRAY] = new CHelpPage(OPERATION_WRITE_SHRINK_ARRAY, OPERATION_WRITE_SHRINK_ARRAY, true, true);
glossary[ATTR_NAME_STRIPE_SIZE] = new CHelpPage(ATTR_NAME_STRIPE_SIZE, ATTR_NAME_STRIPE_SIZE, true, true);
glossary[GUI_NAME_FULL_STRIPE_SIZE] = new CHelpPage(GUI_NAME_FULL_STRIPE_SIZE, GUI_NAME_FULL_STRIPE_SIZE, true, true);
glossary[HELP_GLOSSARY_SURFACE_SCAN_ANALYSIS] = new CHelpPage(HELP_GLOSSARY_SURFACE_SCAN_ANALYSIS, HELP_GLOSSARY_SURFACE_SCAN_ANALYSIS, true, true);
glossary[HELP_GLOSSARY_TRANSIENT_DRIVE] = new CHelpPage(HELP_GLOSSARY_TRANSIENT_DRIVE, HELP_GLOSSARY_TRANSIENT_DRIVE, true, true);
glossary[HELP_GLOSSARY_USABLE_CAPACITY] = new CHelpPage(HELP_GLOSSARY_USABLE_CAPACITY, HELP_GLOSSARY_USABLE_CAPACITY, true, true);

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ADD HELP PAGE STEP 2: Add content to help pages.
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
help[STR_WELCOME_TO_ACU].h(STR_OVERVIEW);
help[STR_WELCOME_TO_ACU].p(HELP_OVERVIEW_ACU_WELCOME, HELP_OVERVIEW_ACU_PURPOSE);

// -------------------------

// -- BEGIN GETTING STARTED WITH ACU PAGES

// Getting Started with ACU Overview
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].h(STR_OVERVIEW);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_OVERVIEW);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_OVERVIEW_2);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].ul(
   STR_KEYBOARD_CONTROLS,
   STR_KEYBOARD_SHORTCUTS,
   "<!.StringMappings=STR_MORE_INFO>",
   "<!.StringMappings=STR_STATUS_ALERTS>",
   STR_IMAGE_LEGEND);

help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].h(STR_TABS);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_TABS);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].ul(
   "<!.StringMappings=STR_CONFIGURATION>",
   "<!.StringMappings=STR_DIAGNOSTICS>",
   "<!.StringMappings=STR_WIZARDS>");
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_TABS_2);

help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].h(STR_CONTROLLER_DEVICE_DROPDOWN);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_DROPDOWN);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_DROPDOWN_2);

help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].h("<!.StringMappings=STR_SYSTEM_STATUS>");
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_SYSTEM_STATUS);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_SYSTEM_STATUS_2);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_SYSTEM_STATUS_3);

help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].h(STR_SYSTEMS_AND_DEVICES_TREE);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_TREE);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_TREE_2);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_TREE_3);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].ul(
   HELP_GETTING_STARTED_WITH_ACU_TREE_FEATURES_1,
   HELP_GETTING_STARTED_WITH_ACU_TREE_FEATURES_2,
   HELP_GETTING_STARTED_WITH_ACU_TREE_FEATURES_3,
   HELP_GETTING_STARTED_WITH_ACU_TREE_FEATURES_4);

help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].h("<!.StringMappings=STR_AVAILABLE_TASKS>");
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_AVAILABLE_TASKS);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_AVAILABLE_TASKS_2);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].ul(
   HELP_GETTING_STARTED_WITH_ACU_AVAILABLE_TASKS_ARRAY_EXISTS);

help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].h(STR_CONTEXT_SENSITIVE_HELP);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_CONTEXT_HELP);

help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].h(STR_COLLAPSIBLE_HEADER_SECTIONS);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_COLLAPSIBLE_HEADER);

help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].h(STR_VARIOUS_ITEMS);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_VARIOUS_ITEMS);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].ul(
   STR_KEYBOARD_CONTROLS,
   STR_KEYBOARD_SHORTCUTS);
help[STR_GETTING_STARTED_WITH_ACU_OVERVIEW].p(HELP_GETTING_STARTED_WITH_ACU_VARIOUS_ITEMS_2);

// Keyboard Controls
help[STR_KEYBOARD_CONTROLS].h(STR_OVERVIEW);
help[STR_KEYBOARD_CONTROLS].p(HELP_OVERVIEW_KEYBOARD_CONTROLS);
//help[STR_KEYBOARD_CONTROLS].note(HELP_NOTE_KEYBOARD_CONTROLS_WIZARDS);
help[STR_KEYBOARD_CONTROLS].h(HELP_KEYBOARD_CONTROLS_ITEM_HIGHLIGHT);
help[STR_KEYBOARD_CONTROLS].p(HELP_KEYBOARD_CONTROLS_ITEM_HIGHLIGHT_DETAILS);
help[STR_KEYBOARD_CONTROLS].h(HELP_KEYBOARD_CONTROLS_KEYS);
help[STR_KEYBOARD_CONTROLS].task(HELP_KEYBOARD_CONTROLS_KEYS_TAB, HELP_KEYBOARD_CONTROLS_KEYS_TAB_DESC);
help[STR_KEYBOARD_CONTROLS].task(HELP_KEYBOARD_CONTROLS_KEYS_SHIFT_TAB, HELP_KEYBOARD_CONTROLS_KEYS_SHIFT_TAB_DESC);
help[STR_KEYBOARD_CONTROLS].task(HELP_KEYBOARD_CONTROLS_KEYS_ARROW_KEYS, HELP_KEYBOARD_CONTROLS_KEYS_ARROW_KEYS_DESC);
help[STR_KEYBOARD_CONTROLS].task(HELP_KEYBOARD_CONTROLS_KEYS_ENTER, HELP_KEYBOARD_CONTROLS_KEYS_ENTER_DESC);
help[STR_KEYBOARD_CONTROLS].task(HELP_KEYBOARD_CONTROLS_KEYS_ESCAPE, HELP_KEYBOARD_CONTROLS_KEYS_ESCAPE_DESC);
help[STR_KEYBOARD_CONTROLS].note(HELP_NOTE_KEYBOARD_CONTROLS_WHILE_ENTERING);
//help[STR_KEYBOARD_CONTROLS].p(HELP_KEYBOARD_CONTROLS_ARROW_KEYS);

// Keyboard Shortcuts
help[STR_KEYBOARD_SHORTCUTS].h(STR_OVERVIEW);
help[STR_KEYBOARD_SHORTCUTS].p(HELP_KEYBOARD_SHORTCUTS_OVERVIEW);
help[STR_KEYBOARD_SHORTCUTS].p(HELP_KEYBOARD_SHORTCUTS_GLOBAL);

var tblKeysGlobal = new CTable('');
tblKeysGlobal.ColumnWidths(45, 350);
tblKeysGlobal.ColumnAligns("center", "left");
tblKeysGlobal.Row(HELP_HOTKEYS_COL_KEY, HELP_HOTKEYS_COL_DESC);
tblKeysGlobal.Row("H", "<!.StringMappings=STR_ACU_HELP>");
tblKeysGlobal.Row("X", STR_HOTKEY_X);
tblKeysGlobal.Row("F5", STR_HOTKEY_F5);

var tblKeysLocal = new CTable('');
tblKeysLocal.ColumnWidths(45, 350);
tblKeysLocal.ColumnAligns("center", "left");
tblKeysLocal.Row(HELP_HOTKEYS_COL_KEY, HELP_HOTKEYS_COL_DESC);
tblKeysLocal.Row(STR_INSERT, STR_HOTKEY_INSERT);
tblKeysLocal.Row(STR_DELETE, STR_HOTKEY_DELETE);
tblKeysLocal.Row("I", "<!.StringMappings=STR_MORE_INFO>");
tblKeysLocal.Row("R", STR_HOTKEY_R);
tblKeysLocal.Row("F", STR_HOTKEY_F);
tblKeysLocal.Row("M", "<!.StringMappings=STR_STATUS_MESSAGES>");
//tblKeysLocal.Row("S", "<!.StringMappings=STR_SAVE>");
tblKeysLocal.Row("V", STR_HOTKEY_V);
tblKeysLocal.Row("C", "<!.StringMappings=STR_LABEL_CONTROLLER_SETTINGS>");
tblKeysLocal.Row("T", OPERATION_WRITE_MANAGE_ARRAY_ACCELERATOR);
tblKeysLocal.Row("A", OPERATION_WRITE_CREATE_ARRAY);
tblKeysLocal.Row("E", OPERATION_WRITE_EXPAND_ARRAY);
tblKeysLocal.Row("J", STR_HOTKEY_J);
tblKeysLocal.Row("L", OPERATION_WRITE_CREATE_LOGICAL_DRIVE);
tblKeysLocal.Row("B", OPERATION_WRITE_MIGRATE_LOGICAL_DRIVE);
tblKeysLocal.Row("N", OPERATION_WRITE_EXTEND_LOGICAL_DRIVE);
tblKeysLocal.Row("D", STR_HOTKEY_D);
//tblKeysLocal.Row("P", GUI_OP_WRITE_MANAGE_HOST_CONTROLLER_ACCESS);
tblKeysLocal.Row("K", GUI_OP_WRITE_MANAGE_LICENSE_KEYS);
tblKeysLocal.Row("Z", OPERATION_WRITE_CLEAR_CONFIGURATION);
tblKeysLocal.Row("G", OPERATION_WRITE_MANAGE_SPARE_DRIVE);
tblKeysLocal.Row("W", "<!.StringMappings=STR_WIZARDS>");

help[STR_KEYBOARD_SHORTCUTS].html(tblKeysGlobal.draw());

help[STR_KEYBOARD_SHORTCUTS].p(HELP_KEYBOARD_SHORTCUTS_LOCAL);
help[STR_KEYBOARD_SHORTCUTS].html(tblKeysLocal.draw());

// More Information
help[STR_MORE_INFO].h(STR_OVERVIEW);
help[STR_MORE_INFO].p(HELP_MORE_INFO_INSTRUCTIONS);
help[STR_MORE_INFO].steps(
   HELP_MORE_INFO_CLICK_TARGET,
   HELP_MORE_INFO_CLICK_MORE_INFO,
   STR_CLICK_OK);

// Status Alerts
help[STR_VIEW_STATUS_MESSAGES].h(STR_OVERVIEW);
help[STR_VIEW_STATUS_MESSAGES].p(HELP_STATUS_ALERTS_INFO);
help[STR_VIEW_STATUS_MESSAGES].legend(
   filterIcon('images/critical20.png', '20px', '20px', 'iconFilter'), ATTR_VALUE_STATUS_CRITICAL,
   filterIcon('images/degraded20.png', '20px', '20px', 'iconFilter'), "<!.StringMappings=GUI_VALUE_STATUS_TYPE_WARNING>",
   filterIcon('images/infostat20.png', '20px', '20px', 'iconFilter'), HELP_STATUS_ALERTS_INFORMATIONAL);
help[STR_VIEW_STATUS_MESSAGES].p(HELP_STATUS_ALERTS_NOTIFY_EXISTING);
help[STR_VIEW_STATUS_MESSAGES].ul(
   HELP_STATUS_ALERTS_NOTIFY_SYSTEM_STATUS,
   HELP_STATUS_ALERTS_NOTIFY_TREE,
   HELP_STATUS_ALERTS_NOTIFY_AVAILABLE_TASKS,
   HELP_STATUS_ALERTS_MORE_INFO);

// Image Legend
var tblImgLegend = new CTable('', "middle");
tblImgLegend.ColumnWidths(45, 390);
tblImgLegend.ColumnAligns("center", "left");
tblImgLegend.Row(STR_IMAGE, "<!.StringMappings=STR_DESCRIPTION>");
tblImgLegend.Row(drawImg("images/critical20.png", '20px', '20px'), ATTR_VALUE_STATUS_CRITICAL);
tblImgLegend.Row(drawImg("images/degraded20.png", '20px', '20px'), ATTR_VALUE_STATUS_DEGRADED);
tblImgLegend.Row(drawImg("images/infostat20.png", '20px', '20px'), HELP_STATUS_ALERTS_INFORMATIONAL);
tblImgLegend.Row(drawImg("images/lock20.png", '20px', '20px'), STR_LOCKED);
tblImgLegend.Row(drawImg("images/interim20.gif", '20px', '20px'), STR_INTERIM);
tblImgLegend.Row(drawImg("images/pause20.png", '20px', '20px'), STR_PAUSED);
tblImgLegend.Row(drawImg("images/queued20.png", '20px', '20px'), ATTR_VALUE_PARITY_INITIALIZATION_STATUS_NOT_STARTED);
tblImgLegend.Row(drawImg("images/transient20.png", '20px', '20px'), STR_TRANSIENT);
tblImgLegend.Row(drawImg("images/ctrl20.png", '20px', '20px'), STR_ARRAY_CONTROLLER);
tblImgLegend.Row(drawImg("images/ctrl20.png", '20px', '20px', "", "images/boot12.png"), STR_BOOT_ARRAY_CONTROLLER);
tblImgLegend.Row(drawImg("images/ctrlfibre20.png", '20px', '20px'), STR_ARRAY_CONTROLLER_FIBRE_CHANNEL);
tblImgLegend.Row(drawImg("images/embed20.png", '20px', '20px'), STR_ARRAY_CONTROLLER_EMBEDDED);
tblImgLegend.Row(drawImg("images/embed20.png", '20px', '20px', "", "images/boot12.png"), STR_BOOT_ARRAY_CONTROLLER_EMBEDDED);
tblImgLegend.Row(drawImg("images/unassigned20.png", '20px', '20px'), "<!.StringMappings=STR_UNASSIGNED_DRIVES>");
tblImgLegend.Row(drawImg("images/storenclosure20.png", '20px', '20px'), ATTR_VALUE_TYPE_STORAGE_ENCLOSURE);
tblImgLegend.Row(drawImg("images/drivecage20.png", '20px', '20px'), "<!.StringMappings=STR_INTERNAL_DRIVE_CAGE>");
tblImgLegend.Row(drawImg("images/arraysata20.png", '20px', '20px'), STR_SATA_ARRAY);
tblImgLegend.Row(drawImg("images/arraysata20.png", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_SATA_ARRAY);
tblImgLegend.Row(drawImg("images/arraysata20.png", '20px', '20px', "images/critical12.png"), STR_FAILED_SATA_ARRAY);
tblImgLegend.Row(drawImg("images/arrayscsi20.png", '20px', '20px'), STR_SCSI_ARRAY);
tblImgLegend.Row(drawImg("images/arrayscsi20.png", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_SCSI_ARRAY);
tblImgLegend.Row(drawImg("images/arrayscsi20.png", '20px', '20px', "images/critical12.png"), STR_FAILED_SCSI_ARRAY);
tblImgLegend.Row(drawImg("images/arraysas20.png", '20px', '20px'), STR_SAS_ARRAY);
tblImgLegend.Row(drawImg("images/arraysas20.png", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_SAS_ARRAY);
tblImgLegend.Row(drawImg("images/arraysas20.png", '20px', '20px', "images/critical12.png"), STR_FAILED_SAS_ARRAY);
tblImgLegend.Row(drawImg("images/satadrive20.png", '20px', '20px'), STR_SATA_DRIVE);
tblImgLegend.Row(drawImg("images/satadrive20.png", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_SATA_DRIVE);
tblImgLegend.Row(drawImg("images/satadrive20.png", '20px', '20px', "images/critical12.png"), STR_FAILED_SATA_DRIVE);
tblImgLegend.Row(drawImg("images/satadrive20.png", '20px', '20px', "images/queued12.png"), STR_SATA_DRIVE_QUEUED_FOR_DRIVE_ERASE);
tblImgLegend.Row("<img src='images/satadriveerase20.gif' />", STR_SATA_DRIVE_DRIVE_ERASE_IN_PROGRESS);
tblImgLegend.Row(drawImg("images/satadrive20.png", '20px', '20px', "images/transient12.png"), STR_TRANSIENT_SATA_DRIVE);
tblImgLegend.Row(drawImg("images/satadrive20.png", '20px', '20px', "images/pause12.png"), STR_OFFLINE_SATA_DRIVE);
tblImgLegend.Row(drawImg("images/sataspare20.png", '20px', '20px'), STR_SPARE_SATA_DRIVE);
tblImgLegend.Row(drawImg("images/sataspare20.png", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_SPARE_SATA_DRIVE);
tblImgLegend.Row(drawImg("images/sataspare20.png", '20px', '20px', "images/critical12.png"), STR_FAILED_SPARE_SATA_DRIVE);
tblImgLegend.Row("<img src='images/sataaspare20.gif' />", STR_ACTIVE_SPARE_SATA_DRIVE);
tblImgLegend.Row(drawImg("images/sataaspare20.gif", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_ACTIVE_SPARE_SATA_DRIVE);
tblImgLegend.Row(drawImg("images/scsidrive20.png", '20px', '20px'), STR_SCSI_DRIVE);
tblImgLegend.Row(drawImg("images/scsidrive20.png", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_SCSI_DRIVE);
tblImgLegend.Row(drawImg("images/scsidrive20.png", '20px', '20px', "images/critical12.png"), STR_FAILED_SCSI_DRIVE);
tblImgLegend.Row(drawImg("images/scsispare20.png", '20px', '20px', "images/critical12.png"), STR_FAILED_SPARE_SCSI_DRIVE);
tblImgLegend.Row(drawImg("images/scsispare20.png", '20px', '20px'), STR_SPARE_SCSI_DRIVE);
tblImgLegend.Row(drawImg("images/scsispare20.png", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_SPARE_SCSI_DRIVE);
tblImgLegend.Row("<img src='images/scsiaspare20.gif' />", STR_ACTIVE_SPARE_SCSI_DRIVE);
tblImgLegend.Row(drawImg("images/scsiaspare20.gif", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_ACTIVE_SPARE_SCSI_DRIVE);
tblImgLegend.Row(drawImg("images/sasdrive20.png", '20px', '20px'), STR_SAS_DRIVE);
tblImgLegend.Row(drawImg("images/sasdrive20.png", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_SAS_DRIVE);
tblImgLegend.Row(drawImg("images/sasdrive20.png", '20px', '20px', "images/critical12.png"), STR_FAILED_SAS_DRIVE);
tblImgLegend.Row(drawImg("images/sasdrive20.png", '20px', '20px', "images/queued12.png"), STR_SAS_DRIVE_QUEUED_FOR_DRIVE_ERASE);
tblImgLegend.Row("<img src='images/sasdriveerase20.gif' />", STR_SAS_DRIVE_DRIVE_ERASE_IN_PROGRESS);
tblImgLegend.Row(drawImg("images/sasdrive20.png", '20px', '20px', "images/transient12.png"), STR_TRANSIENT_SAS_DRIVE);
tblImgLegend.Row(drawImg("images/sasdrive20.png", '20px', '20px', "images/pause12.png"), STR_OFFLINE_SAS_DRIVE);
tblImgLegend.Row(drawImg("images/sasspare20.png", '20px', '20px'), STR_SPARE_SAS_DRIVE);
tblImgLegend.Row(drawImg("images/sasspare20.png", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_SPARE_SAS_DRIVE);
tblImgLegend.Row(drawImg("images/sasspare20.png", '20px', '20px', "images/critical12.png"), STR_FAILED_SPARE_SAS_DRIVE);
tblImgLegend.Row("<img src='images/sasaspare20.gif' />", STR_ACTIVE_SPARE_SAS_DRIVE);
tblImgLegend.Row(drawImg("images/sasaspare20.gif", '20px', '20px', "images/degraded12.png"), STR_DEGRADED_ACTIVE_SPARE_SAS_DRIVE);
tblImgLegend.Row(drawImg("images/unused20.png", '20px', '20px'), STR_UNUSED_SPACE);
tblImgLegend.Row(drawImg("images/logdrive20.png", '20px', '20px'), "<!.StringMappings=STR_LOGICAL_DRIVE>");
tblImgLegend.Row(drawImg("images/logdrive20.png", '20px', '20px', "", "images/boot12.png"), STR_BOOT_LOGICAL_DRIVE);
tblImgLegend.Row(drawImg("images/logdrive20.png", '20px', '20px', "images/critical12.png"), STR_FAILED_LOGICAL_DRIVE);
tblImgLegend.Row("<img src='images/logdriverbld20.gif' />", STR_REBUILDING_LOGICAL_DRIVE);
tblImgLegend.Row("<img src='images/logdriveexpand20.gif' />", STR_TRANSFORMING_LOGICAL_DRIVE);
tblImgLegend.Row(drawImg("images/logdrive20.png", '20px', '20px', "images/queued12.png"), STR_LOGICAL_DRIVE_QUEUED);
tblImgLegend.Row("<img src='images/logdriveerase20.gif' />", STR_LOGICAL_DRIVE_DRIVE_ERASE_IN_PROGRESS);
tblImgLegend.Row(drawImg("images/logdrive20.png", '20px', '20px', "images/interim12.gif"), STR_LOGICAL_DRIVE_IN_INTERIM_RECOVERY_MODE);
tblImgLegend.Row(drawImg("images/logdrive20.png", '20px', '20px', "images/pause12.png"), STR_LOGICAL_DRIVE_UNAVAILABLE);
tblImgLegend.Row(drawImg("images/logdrive20.png", '20px', '20px', "images/lock12.png"), STR_LOGICAL_DRIVE_LOCKED);
tblImgLegend.Row(drawImg("images/remvol20.png", '20px', '20px'), STR_REMOTE_VOLUME);
tblImgLegend.Row(drawImg("images/remvol20.png", '20px', '20px', "", "images/boot12.png"), STR_BOOT_REMOTE_VOLUME);
tblImgLegend.Row(drawImg("images/tapedrive20.png", '20px', '20px'), "<!.StringMappings=STR_TAPE_DRIVE>");
tblImgLegend.Row(drawImg("images/ctrlinitiator20.png", '20px', '20px'), "<!.StringMappings=ATTR_VALUE_TYPE_INITIATOR>");
tblImgLegend.Row(drawImg("images/help20.png", '20px', '20px'), "<!.StringMappings=STR_HELP_LINK>");
tblImgLegend.Row(drawImg("images/refresh20.png", '20px', '20px'), STR_REFRESH_SELECTED_CONTROLLER);
tblImgLegend.Row(drawImg("images/rescan25.png", '25px', '25px'), "<!.StringMappings=STR_RESCAN>");
tblImgLegend.Row(drawImg("images/printer30.png", '30px', '30px'), "<!.StringMappings=STR_PRINT>");

help[STR_IMAGE_LEGEND].html(tblImgLegend.draw());

// -- END GETTING STARTED WITH ACU PAGES

// -------------------------

// -- BEGIN CONTROLLER PAGES

// Configuration Overview
help[STR_CONFIGURATION_OVERVIEW].h(STR_OVERVIEW);
help[STR_CONFIGURATION_OVERVIEW].p(HELP_OVERVIEW_CONFIGURATION_OVERVIEW);

// Clear Configuration
help[OPERATION_WRITE_CLEAR_CONFIGURATION].h(STR_OVERVIEW);
help[OPERATION_WRITE_CLEAR_CONFIGURATION].p(HELP_TASK_CLEAR_CONFIGURATION);

// Advanced Controller Settings
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].h(STR_OVERVIEW);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].p(HELP_TASK_ADVANCED_CONTROLLER_SETTINGS);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].h(ATTR_NAME_SELECTED_PERFORMANCE_PROFILE);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].p(HELP_TASK_ADVANCED_CONTROLLER_SETTINGS_PERFORMANCE_PROFILE);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].h(ATTR_NAME_DEGRADED_PERFORMANCE_OPTIMIZATION);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].p(HELP_TASK_ADVANCED_CONTROLLER_SETTINGS_DEGRADED_PERFORMANCE_OPTIMIZATION);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].h(ATTR_NAME_ELEVATOR_SORT);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].p(HELP_TASK_ADVANCED_CONTROLLER_SETTINGS_ELEVATOR_SORT);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].h(ATTR_NAME_INCONSISTENCY_REPAIR_POLICY);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].p(HELP_TASK_ADVANCED_CONTROLLER_SETTINGS_INCONSISTENCY_REPAIR_POLICY);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].h(ATTR_NAME_QUEUE_DEPTH);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].p(HELP_TASK_ADVANCED_CONTROLLER_SETTINGS_QUEUE_DEPTH);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].h(ATTR_NAME_MNP_DELAY);
help[OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS].p(HELP_TASK_ADVANCED_CONTROLLER_SETTINGS_MNP_DELAY);

// Array Accelerator Settings
help[OPERATION_WRITE_MANAGE_ARRAY_ACCELERATOR].h(STR_OVERVIEW);
help[OPERATION_WRITE_MANAGE_ARRAY_ACCELERATOR].p(HELP_TASK_CREATE_ARRAY_ACC);
help[OPERATION_WRITE_MANAGE_ARRAY_ACCELERATOR].h(STR_TASK_OPTIONS);
help[OPERATION_WRITE_MANAGE_ARRAY_ACCELERATOR].task(HELP_SEL_LD, HELP_TASK_ARRAY_ACC);
help[OPERATION_WRITE_MANAGE_ARRAY_ACCELERATOR].task(HELP_TASK_CREATE_ARRAY_ACC_WRITE_CACHING, HELP_TASK_CREATE_ARRAY_ACC_WRITE_CACHING_DESC);

// Controller Settings
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].h(STR_OVERVIEW);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].p(HELP_TASK_CONTROLLER_SETTINGS);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].h(ATTR_NAME_CACHE_RATIO);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].p(HELP_TASK_CONTROLLER_SETTINGS_CACHE_RATIO);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].h(ATTR_NAME_EXPAND_PRIORITY);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].note(HELP_TASK_CONTROLLER_SETTINGS_EXPAND_PRIORITY_NOTE);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].task(ATTR_VALUE_EXPAND_PRIORITY_HIGH, HELP_TASK_CONTROLLER_SETTINGS_TRANSFORMATION_HIGH);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].task(ATTR_VALUE_EXPAND_PRIORITY_MEDIUM, HELP_TASK_CONTROLLER_SETTINGS_TRANSFORMATION_MEDIUM);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].task(ATTR_VALUE_EXPAND_PRIORITY_LOW, HELP_TASK_CONTROLLER_SETTINGS_TRANSFORMATION_LOW);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].note(HELP_TASK_CONTROLLER_SETTINGS_TRANSFORMATION_NOTE);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].h(ATTR_NAME_REBUILD_PRIORITY);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].task(ATTR_VALUE_REBUILD_PRIORITY_HIGH, HELP_TASK_CONTROLLER_SETTINGS_REBUILD_HIGH);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].task(ATTR_VALUE_REBUILD_PRIORITY_MEDIUM, HELP_TASK_CONTROLLER_SETTINGS_REBUILD_MEDIUM);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].task(ATTR_VALUE_REBUILD_PRIORITY_LOW, HELP_TASK_CONTROLLER_SETTINGS_REBUILD_LOW);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].note(HELP_TASK_CONTROLLER_SETTINGS_REBUILD_NOTE);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].h(ATTR_NAME_SURFACE_ANALYSIS_DELAY);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].p(HELP_TASK_CONTROLLER_SETTINGS_SURFACE_ANALYSIS);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].task(STR_DISABLED, HELP_TASK_CONTROLLER_SETTINGS_SURFACE_DISABLED);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].task(ATTR_VALUE_SURFACE_ANALYSIS_MODE_AGGRESSIVE_TRUE, HELP_TASK_CONTROLLER_SETTINGS_SURFACE_HIGH);
help[OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS].task(ATTR_VALUE_SURFACE_ANALYSIS_MODE_AGGRESSIVE_FALSE , HELP_TASK_CONTROLLER_SETTINGS_SURFACE_IDLE);

// Physical Drive Write Cache
help[OPERATION_WRITE_SET_DRIVE_WRITE_CACHE].h(STR_OVERVIEW);
help[OPERATION_WRITE_SET_DRIVE_WRITE_CACHE].p(HELP_TASK_SET_DRIVE_WRITE_CACHE);
help[OPERATION_WRITE_SET_DRIVE_WRITE_CACHE].note("<!.StringMappings=STR_NOTE_DRIVE_WRITE_CACHE>");

// Manage License Keys
help[GUI_OP_WRITE_MANAGE_LICENSE_KEYS].h(STR_OVERVIEW);
help[GUI_OP_WRITE_MANAGE_LICENSE_KEYS].note(HELP_NOTE_LICENSE_KEY_MANAGEMENT);
help[GUI_OP_WRITE_MANAGE_LICENSE_KEYS].p(HELP_OVERVIEW_LICENSE_KEY_MANAGEMENT);
help[GUI_OP_WRITE_MANAGE_LICENSE_KEYS].p(HELP_EXISTING_LICENSE_KEYS_TABLE_INFO);
var tblLicenseKeyStatus = new CTable(HELP_LICENSE_KEY_STATUS_DEFINITIONS);
tblLicenseKeyStatus.ColumnWidths(100, 330);
tblLicenseKeyStatus.Row("<!.StringMappings=ATTR_NAME_STATUS>", STR_DEFINITION);
tblLicenseKeyStatus.Row(ATTR_VALUE_STATUS_OK, HELP_LICENSE_KEY_STATUS_OK);
tblLicenseKeyStatus.Row(ATTR_VALUE_STATUS_DUPLICATE_FEATURE_NAME, HELP_LICENSE_KEY_STATUS_DUPLICATE_FEATURE_NAME);
//tblLicenseKeyStatus.Row(ATTR_VALUE_STATUS_HARDWARE_MISMATCH, HELP_LICENSE_KEY_STATUS_HARDWARE_MISMATCH); //not in ACU-XE
tblLicenseKeyStatus.Row(ATTR_VALUE_STATUS_KEY_EXPIRED, HELP_LICENSE_KEY_STATUS_KEY_EXPIRED); // not in ACU-XE
tblLicenseKeyStatus.Row(ATTR_VALUE_STATUS_SERIAL_NUMBER_MISMATCH, HELP_LICENSE_KEY_STATUS_SERIAL_NUMBER_MISMATCH);
tblLicenseKeyStatus.Row(ATTR_VALUE_STATUS_UNKNOWN_FEATURE_NAME, HELP_LICENSE_KEY_STATUS_UNKNOWN_FEATURE_NAME);
help[GUI_OP_WRITE_MANAGE_LICENSE_KEYS].html(tblLicenseKeyStatus.draw());

// Create Array
help[OPERATION_WRITE_CREATE_ARRAY].h(STR_OVERVIEW);
help[OPERATION_WRITE_CREATE_ARRAY].p(HELP_OVERVIEW_CREATE_ARRAY);
help[OPERATION_WRITE_CREATE_ARRAY].note(HELP_NOTE_USE_SAME_DRIVE_SIZE);
help[OPERATION_WRITE_CREATE_ARRAY].h(STR_TASK_OPTIONS);
help[OPERATION_WRITE_CREATE_ARRAY].task(ATTR_NAME_INTERFACE, HELP_TASK_CREATE_ARRAY_DRIVE_TYPE);
help[OPERATION_WRITE_CREATE_ARRAY].task(HELP_SEL_PD, HELP_TASK_CREATE_ARRAY_SEL_PDS);

// Duplicate Create Array to include it under multiple folders
help[OPERATION_WRITE_CREATE_ARRAY_2].setBody(help[OPERATION_WRITE_CREATE_ARRAY].getBody());

// Disable Redundant Controllers
help[OPERATION_WRITE_DISABLE_OTHER_CONTROLLER].h(STR_OVERVIEW);
help[OPERATION_WRITE_DISABLE_OTHER_CONTROLLER].p(HELP_TASK_DISABLE_STANDBY_CONTROLLER);

// Redundancy Settings
help[GUI_OPERATION_REDUNDANCY_SETTINGS].h(STR_OVERVIEW);
help[GUI_OPERATION_REDUNDANCY_SETTINGS].p(HELP_OVERVIEW_REDUNDANCY);
help[GUI_OPERATION_REDUNDANCY_SETTINGS].h(STR_TASK_OPTIONS);
help[GUI_OPERATION_REDUNDANCY_SETTINGS].task(ATTR_NAME_ASYMMETRICAL_ACTIVE_ACTIVE_SUBMODE, HELP_TASK_REDUNDANCY_MODE);
help[GUI_OPERATION_REDUNDANCY_SETTINGS].task("<!.StringMappings=STR_PREFERRED_LD_PATHS>", HELP_TASK_REDUNDANCY_PATH);

// Set Boot Controller
help[OPERATION_WRITE_SET_BOOT_CONTROLLER].h(STR_OVERVIEW);
help[OPERATION_WRITE_SET_BOOT_CONTROLLER].p(HELP_OVERVIEW_SET_BOOT_CONTROLLER);
help[OPERATION_WRITE_SET_BOOT_CONTROLLER].note(HELP_NOTE_OPERATION_PERFORMED_OFFLINE);
help[OPERATION_WRITE_SET_BOOT_CONTROLLER].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_OP);
help[OPERATION_WRITE_SET_BOOT_CONTROLLER].note(HELP_NOTE_SOME_SERVERS_NOT_SUPPORT_OP);

// Set Bootable Volume
help[GUI_OP_WRITE_SET_BOOT_VOLUME].h(STR_OVERVIEW);
help[GUI_OP_WRITE_SET_BOOT_VOLUME].p(HELP_OVERVIEW_SET_BOOTABLE_VOLUME);
help[GUI_OP_WRITE_SET_BOOT_VOLUME].h(STR_TASK_OPTIONS);
help[GUI_OP_WRITE_SET_BOOT_VOLUME].task(ATTR_NAME_BOOT_VOLUME_PRIMARY, HELP_TASK_BOOT_VOLUME_PRIMARY);
help[GUI_OP_WRITE_SET_BOOT_VOLUME].task(ATTR_NAME_BOOT_VOLUME_SECONDARY, HELP_TASK_BOOT_VOLUME_SECONDARY);
help[GUI_OP_WRITE_SET_BOOT_VOLUME].note(HELP_NOTE_OPERATION_PERFORMED_OFFLINE);
help[GUI_OP_WRITE_SET_BOOT_VOLUME].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_OP);

// -- END CONTROLLER PAGES

// -----------------------

// -- BEGIN ARRAY PAGES

// Delete Array
help[OPERATION_WRITE_DELETE_ARRAY].h(STR_OVERVIEW);
help[OPERATION_WRITE_DELETE_ARRAY].p(HELP_TASK_DELETE_ARRAY);

// Move Array
help[OPERATION_WRITE_MOVE_ARRAY].h(STR_OVERVIEW);
help[OPERATION_WRITE_MOVE_ARRAY].p(HELP_TASK_MOVE_ARRAY);
help[OPERATION_WRITE_MOVE_ARRAY].ul(
   HELP_TASK_MOVE_ARRAY_CONDITION_ELEMENTS,
   HELP_TASK_MOVE_ARRAY_CONDITION_ARRAY_TYPE,
   HELP_TASK_MOVE_ARRAY_CONDITION_CAPACITY);
help[OPERATION_WRITE_MOVE_ARRAY].note(HELP_NOTE_MOVE_ARRAY);
help[OPERATION_WRITE_MOVE_ARRAY].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

// Shrink Array
help[OPERATION_WRITE_SHRINK_ARRAY].h(STR_OVERVIEW);
help[OPERATION_WRITE_SHRINK_ARRAY].p(HELP_TASK_SHRINK_ARRAY);
help[OPERATION_WRITE_SHRINK_ARRAY].ul(
   HELP_TASK_SHRINK_ARRAY_CONDITION_FREE_SPACE,
   HELP_TASK_SHRINK_ARRAY_CONDITION_REMOVE_DRIVES,
   HELP_TASK_SHRINK_ARRAY_CONDITION_RAID_1,
   HELP_TASK_SHRINK_ARRAY_CONDITION_COMPOUND_RAID);
help[OPERATION_WRITE_SHRINK_ARRAY].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

// Split Mirror
help[OPERATION_WRITE_SPLIT_ARRAY].h(STR_OVERVIEW);
help[OPERATION_WRITE_SPLIT_ARRAY].p(HELP_OVERVIEW_SPLIT_MIRROR);
help[OPERATION_WRITE_SPLIT_ARRAY].note(HELP_NOTE_OPERATION_PERFORMED_OFFLINE);
help[OPERATION_WRITE_SPLIT_ARRAY].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

// Re-sync Mirror
help[OPERATION_WRITE_JOIN_ARRAY].h(STR_OVERVIEW);
help[OPERATION_WRITE_JOIN_ARRAY].p(HELP_OVERVIEW_RESYNC_MIRROR);
help[OPERATION_WRITE_JOIN_ARRAY].note(HELP_NOTE_OPERATION_PERFORMED_OFFLINE);
help[OPERATION_WRITE_JOIN_ARRAY].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

// Create Logical Drive
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE].h(STR_OVERVIEW);
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE].p(HELP_OVERVIEW_CREATE_LD);
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE].note(HELP_NOTE_CREATE_LD);
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE].h(STR_TASK_OPTIONS);
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE].task(ATTR_NAME_RAID, HELP_TASK_LD_RAID);
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE].task(ATTR_NAME_STRIPE_SIZE, HELP_TASK_LD_SS);
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE].task(ATTR_NAME_SECTORS, HELP_TASK_CREATE_LD_SECTORS);
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE].task(ATTR_NAME_USEABLE_BLOCKS, HELP_TASK_CREATE_LD_SIZE);
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE].task(ATTR_NAME_ARRAY_ACCELERATOR, HELP_TASK_CREATE_ARRAY_ACC);

// Duplicate Create Logical Drive to include it under multiple folders
help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE_2].setBody(help[OPERATION_WRITE_CREATE_LOGICAL_DRIVE].getBody());

// Expand Array 
help[OPERATION_WRITE_EXPAND_ARRAY].h(STR_OVERVIEW);
help[OPERATION_WRITE_EXPAND_ARRAY].p(HELP_OVERVIEW_EXPAND);
help[OPERATION_WRITE_EXPAND_ARRAY].note(HELP_NOTE_USE_SAME_DRIVE_SIZE);

// Spare Management
help[OPERATION_WRITE_MANAGE_SPARE_DRIVE].h(STR_OVERVIEW);
help[OPERATION_WRITE_MANAGE_SPARE_DRIVE].p(HELP_OVERVIEW_SPARE_MGMT);
help[OPERATION_WRITE_MANAGE_SPARE_DRIVE].note(HELP_NOTE_SPARE_MGMT);
help[OPERATION_WRITE_MANAGE_SPARE_DRIVE].note(HELP_NOTE_USE_SAME_DRIVE_SIZE);

// -- END ARRAY PAGES

// ----------------------------

// -- BEGIN DRIVE PAGES

// Erase Drive
help[OPERATION_WRITE_ERASE_DRIVE].h(STR_OVERVIEW);
help[OPERATION_WRITE_ERASE_DRIVE].p(HELP_TASK_ERASE_DRIVE);
help[OPERATION_WRITE_ERASE_DRIVE].task(HELP_TASK_ERASE_DRIVE_ONE_PASS, HELP_TASK_ERASE_DRIVE_ONE_PASS_DESC);
help[OPERATION_WRITE_ERASE_DRIVE].task(HELP_TASK_ERASE_DRIVE_TWO_PASS, HELP_TASK_ERASE_DRIVE_TWO_PASS_DESC);
help[OPERATION_WRITE_ERASE_DRIVE].task(HELP_TASK_ERASE_DRIVE_THREE_PASS, HELP_TASK_ERASE_DRIVE_THREE_PASS_DESC);
help[OPERATION_WRITE_ERASE_DRIVE].note(HELP_NOTE_REENABLE_PHYSICAL_DRIVE_AFTER_ERASE);
help[OPERATION_WRITE_ERASE_DRIVE].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

// -- END DRIVE TASKS

// ----------------------------

// -- BEGIN LOGICAL DRIVE PAGES

// Delete Logical Drive
help[OPERATION_WRITE_DELETE_LOGICAL_DRIVE].h(STR_OVERVIEW);
help[OPERATION_WRITE_DELETE_LOGICAL_DRIVE].p(HELP_TASK_DELETE_LOGICAL_DRIVE);
help[OPERATION_WRITE_DELETE_LOGICAL_DRIVE].note("<!.StringMappings=STR_SELECT_ALL_REMOVE_LD_NOTE>");

// Extend Logical Drive
help[OPERATION_WRITE_EXTEND_LOGICAL_DRIVE].h(STR_OVERVIEW);
help[OPERATION_WRITE_EXTEND_LOGICAL_DRIVE].p(HELP_OVERVIEW_EXTEND);

// Migrate RAID/Stripe Size
help[OPERATION_WRITE_MIGRATE_LOGICAL_DRIVE].h(STR_OVERVIEW);
help[OPERATION_WRITE_MIGRATE_LOGICAL_DRIVE].p(HELP_OVERVIEW_MIGRATE);
help[OPERATION_WRITE_MIGRATE_LOGICAL_DRIVE].h(STR_TASK_OPTIONS);
help[OPERATION_WRITE_MIGRATE_LOGICAL_DRIVE].task(ATTR_NAME_RAID, HELP_TASK_LD_RAID);
help[OPERATION_WRITE_MIGRATE_LOGICAL_DRIVE].task(ATTR_NAME_STRIPE_SIZE, HELP_TASK_LD_SS);

// Re-enable Failed Logical Drive
help[OPERATION_WRITE_REENABLE_LOGICAL_DRIVE].h(STR_OVERVIEW);
help[OPERATION_WRITE_REENABLE_LOGICAL_DRIVE].p(HELP_OVERVIEW_REENABLE_LOGICAL_DRIVE);

// -- END LOGICAL DRIVE PAGES

// --------------------------

// Edit Chassis Name
/*help[OPERATION_WRITE_MANAGE_BOX_NAME] = new CHelpPage(OPERATION_WRITE_MANAGE_BOX_NAME, OPERATION_WRITE_MANAGE_BOX_NAME);
help[OPERATION_WRITE_MANAGE_BOX_NAME].h(STR_OVERVIEW);
help[OPERATION_WRITE_MANAGE_BOX_NAME].p(HELP_OVERVIEW_CHASSIS_NAME);*/

//help[STR_EXPRESS_OVERVIEW] = new CHelpPage(STR_EXPRESS_OVERVIEW, STR_EXPRESS_OVERVIEW);
//help[STR_FAULT_TOLERANCE_OF_LOGICAL_DRIVES] = new CHelpPage(STR_FAULT_TOLERANCE_OF_LOGICAL_DRIVES, STR_FAULT_TOLERANCE_OF_LOGICAL_DRIVES);
//help[STR_ASSIGNING_SPARES] = new CHelpPage(STR_ASSIGNING_SPARES, STR_ASSIGNING_SPARES);
//help[STR_UNASSIGNED_PHYSICAL_DRIVES] = new CHelpPage(STR_UNASSIGNED_PHYSICAL_DRIVES, STR_UNASSIGNED_PHYSICAL_DRIVES);
//help[STR_SAVING_THE_CONFIGURATION] = new CHelpPage(STR_SAVING_THE_CONFIGURATION, STR_SAVING_THE_CONFIGURATION);

// Selective Storage Presentation
help[STR_SSP_OVERVIEW].h(STR_OVERVIEW);
help[STR_SSP_OVERVIEW].p(HELP_OVERVIEW_SSP);
help[STR_SSP_OVERVIEW].note(HELP_NOTE_SSP_WARNING);
help[STR_SSP_OVERVIEW].note(HELP_NOTE_SSP_HOST_MODES);
help[STR_SSP_OVERVIEW].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);
help[STR_SSP_OVERVIEW].h(STR_HOST_CONTROLLER_INFO);
help[STR_SSP_OVERVIEW].task(ATTR_NAME_CONNECTION_NAME, HELP_TASK_SSP_CN);
help[STR_SSP_OVERVIEW].task(ATTR_NAME_HOST_MODE, HELP_TASK_SSP_HM);
help[STR_SSP_OVERVIEW].task("<!.StringMappings=STR_ADAPTER_ID>", HELP_TASK_SSP_AI);
help[STR_SSP_OVERVIEW].task(ATTR_NAME_LOCATION, HELP_TASK_SSP_LC);
help[STR_SSP_OVERVIEW].task(ATTR_NAME_STATUS, HELP_TASK_SSP_ST);

// Diagnostics
help[STR_DIAGNOSTICS_OVERVIEW].h(STR_OVERVIEW);
help[STR_DIAGNOSTICS_OVERVIEW].p(HELP_OVERVIEW_DIAGNOSTICS);
help[STR_DIAGNOSTICS_OVERVIEW].h(STR_TASKS);
help[STR_DIAGNOSTICS_OVERVIEW].p(HELP_OVERVIEW_DIAGNOSTICS_TASKS);

// Wizards
help[STR_WIZARDS_OVERVIEW].h(STR_OVERVIEW);
help[STR_WIZARDS_OVERVIEW].p(HELP_OVERVIEW_WIZARDS);

// -- END DRIVE PAGES

// --------------------------

// -- BEGIN GLOSSARY PAGES

glossary[HELP_GLOSSARY_ACTIVE_SPARE].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_ACTIVE_SPARE].p(HELP_GLOSSARY_ACTIVE_SPARE_DEFINITION);

glossary[STR_ACU].h(STR_OVERVIEW);
glossary[STR_ACU].p(HELP_GLOSSARY_ACU_DEFINITION);

glossary[HELP_GLOSSARY_ADAPTER_ID].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_ADAPTER_ID].p(HELP_GLOSSARY_ADAPTER_ID_DEFINITION);

glossary[HELP_GLOSSARY_ADVANCED_CAPACITY_EXPANSION].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_ADVANCED_CAPACITY_EXPANSION].p(HELP_GLOSSARY_ADVANCED_CAPACITY_EXPANSION_DEFINITION);
glossary[HELP_GLOSSARY_ADVANCED_CAPACITY_EXPANSION].ul(
   OPERATION_WRITE_SHRINK_ARRAY,
   OPERATION_WRITE_MOVE_ARRAY);
glossary[HELP_GLOSSARY_ADVANCED_CAPACITY_EXPANSION].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

glossary[HELP_GLOSSARY_ADVANCED_CONTROLLER_SETTINGS].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_ADVANCED_CONTROLLER_SETTINGS].p(HELP_GLOSSARY_ADVANCED_CONTROLLER_SETTINGS_DEFINITION);
glossary[HELP_GLOSSARY_ADVANCED_CONTROLLER_SETTINGS].ul(
   ATTR_NAME_INCONSISTENCY_REPAIR_POLICY,
   ATTR_NAME_DEGRADED_PERFORMANCE_OPTIMIZATION,
   ATTR_NAME_ELEVATOR_SORT,
   ATTR_NAME_MNP_DELAY,
   ATTR_NAME_QUEUE_DEPTH);
glossary[HELP_GLOSSARY_ADVANCED_CONTROLLER_SETTINGS].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

/*glossary[HELP_GLOSSARY_ADU] = new CHelpPage(HELP_GLOSSARY_ADU, HELP_GLOSSARY_ADU, true);
glossary[HELP_GLOSSARY_ADU].h(HELP_GLOSSARY_ADU);
glossary[HELP_GLOSSARY_ADU].p(HELP_GLOSSARY_ADU_DEFINITION);*/

glossary[ATTR_NAME_ARRAY_ACCELERATOR].h(STR_OVERVIEW);
glossary[ATTR_NAME_ARRAY_ACCELERATOR].p(HELP_GLOSSARY_ARRAY_ACCELERATOR_DEFINITION);

glossary[STR_ARRAY].h(STR_OVERVIEW);
glossary[STR_ARRAY].p(HELP_GLOSSARY_ARRAYS_DEFINITION);

glossary[HELP_GLOSSARY_ARRAY_CONFIGURATION_UTILITY].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_ARRAY_CONFIGURATION_UTILITY].p(HELP_GLOSSARY_ARRAY_CONFIGURATION_UTILITY_DEFINITION);

glossary[ATTR_NAME_IS_BOOT_CONTROLLER].h(STR_OVERVIEW);
glossary[ATTR_NAME_IS_BOOT_CONTROLLER].p(HELP_GLOSSARY_BOOT_CONTROLLER_DEFINITION);

glossary[STR_BOOTABLE_VOLUME].h(STR_OVERVIEW);
glossary[STR_BOOTABLE_VOLUME].p(HELP_GLOSSARY_BOOTABLE_VOLUME_DEFINITION);

glossary[HELP_GLOSSARY_CAPACITY_EXPANSION].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_CAPACITY_EXPANSION].p(HELP_GLOSSARY_CAPACITY_EXPANSION_DEFINITION);

glossary[ATTR_NAME_CONNECTION_NAME].h(STR_OVERVIEW);
glossary[ATTR_NAME_CONNECTION_NAME].p(HELP_GLOSSARY_CONNECTION_NAME_DEFINITION);

glossary[HELP_GLOSSARY_CONTROLLER_DUPLEXING].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_CONTROLLER_DUPLEXING].p(HELP_GLOSSARY_CONTROLLER_DUPLEXING_DEFINITION);
glossary[HELP_GLOSSARY_CONTROLLER_DUPLEXING].note(HELP_GLOSSARY_CONTROLLER_DUPLEXING_DEFINITION_NOTE);
glossary[HELP_GLOSSARY_CONTROLLER_DUPLEXING].ul(
   HELP_GLOSSARY_CONTROLLER_DUPLEXING_ONLINE_SPARE,
   HELP_GLOSSARY_CONTROLLER_DUPLEXING_AUTO_RELIABILITY_MONITORING,
   HELP_GLOSSARY_CONTROLLER_DUPLEXING_INTERIM_DATA_RECOVERY,
   HELP_GLOSSARY_CONTROLLER_DUPLEXING_AUTOMATIC_DATA_RECOVERY);

glossary[STR_DUAL_DOMAIN].h(STR_OVERVIEW);
glossary[STR_DUAL_DOMAIN].p(HELP_GLOSSARY_DUAL_DOMAIN_DEFINITION);
glossary[STR_DUAL_DOMAIN].note(HELP_GLOSSARY_DUAL_DOMAIN_DEFINITION_NOTE);
glossary[STR_DUAL_DOMAIN].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

glossary[ATTR_NAME_EXPAND_PRIORITY].h(STR_OVERVIEW);
glossary[ATTR_NAME_EXPAND_PRIORITY].p(HELP_GLOSSARY_EXPAND_PRIORITY_DEFINITION);

glossary[ATTR_NAME_RAID].h(STR_OVERVIEW);
glossary[ATTR_NAME_RAID].p(HELP_GLOSSARY_FAULT_TOLERANCE_DEFINITION);
glossary[ATTR_NAME_RAID].task(ATTR_VALUE_RAID_1, STR_DRIVE_MIRRORING);
glossary[ATTR_NAME_RAID].task(ATTR_VALUE_RAID_10, STR_DRIVE_MIRRORING_WITH_STRIPING);
glossary[ATTR_NAME_RAID].task(ATTR_VALUE_RAID_4, STR_DATA_GUARDING);
glossary[ATTR_NAME_RAID].task(ATTR_VALUE_RAID_5, HELP_RAID_CMP_DDG);
glossary[ATTR_NAME_RAID].task(ATTR_VALUE_RAID_6, HELP_RAID_CMP_ADG);
glossary[ATTR_NAME_RAID].task(ATTR_VALUE_RAID_50, STR_STRIPING_OVER_RAID_5_DISTRIBUTED_DATA_GUARDING);
glossary[ATTR_NAME_RAID].task(ATTR_VALUE_RAID_60, STR_STRIPING_OVER_RAID_6_ADVANCED_DATA_GUARDING);

glossary[ATTR_NAME_HOST_MODE].h(STR_OVERVIEW);
glossary[ATTR_NAME_HOST_MODE].p(HELP_GLOSSARY_HOST_MODE_DEFINITION);

glossary[STR_DRIVE_ERASE].h(STR_OVERVIEW);
glossary[STR_DRIVE_ERASE].p(HELP_TASK_ERASE_DRIVE);
glossary[STR_DRIVE_ERASE].task(HELP_TASK_ERASE_DRIVE_ONE_PASS, HELP_TASK_ERASE_DRIVE_ONE_PASS_DESC);
glossary[STR_DRIVE_ERASE].task(HELP_TASK_ERASE_DRIVE_TWO_PASS, HELP_TASK_ERASE_DRIVE_TWO_PASS_DESC);
glossary[STR_DRIVE_ERASE].task(HELP_TASK_ERASE_DRIVE_THREE_PASS, HELP_TASK_ERASE_DRIVE_THREE_PASS_DESC);
glossary[STR_DRIVE_ERASE].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

glossary[HELP_GLOSSARY_LOGICAL_DRIVE_EXTENSION].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_LOGICAL_DRIVE_EXTENSION].p(HELP_GLOSSARY_LOGICAL_DRIVE_EXTENSION_DEFINITION);

glossary[STR_LOGICAL_DRIVE].h(STR_OVERVIEW);
glossary[STR_LOGICAL_DRIVE].p(HELP_GLOSSARY_LOGICAL_DRIVES_DEFINITION);

glossary[HELP_GLOSSARY_MAXIMUM_BOOT_SIZE].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_MAXIMUM_BOOT_SIZE].p(HELP_GLOSSARY_MAXIMUM_BOOT_SIZE_DEFINITION);

glossary[ATTR_NAME_QUEUE_DEPTH].h(STR_OVERVIEW);
glossary[ATTR_NAME_QUEUE_DEPTH].p(HELP_GLOSSARY_QUEUE_DEPTH_DEFINITION);

glossary[HELP_GLOSSARY_MIGRATION].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_MIGRATION].p(HELP_GLOSSARY_MIGRATION_DEFINTION);

glossary[ATTR_NAME_MNP_DELAY].h(STR_OVERVIEW);
glossary[ATTR_NAME_MNP_DELAY].p(HELP_GLOSSARY_MONITOR_PERFORMANCE_ANALYSIS_DELAY);
glossary[ATTR_NAME_MNP_DELAY].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

glossary[OPERATION_WRITE_MOVE_ARRAY].h(STR_OVERVIEW);
glossary[OPERATION_WRITE_MOVE_ARRAY].p(HELP_TASK_MOVE_ARRAY);
glossary[OPERATION_WRITE_MOVE_ARRAY].ul(
   HELP_TASK_MOVE_ARRAY_CONDITION_ELEMENTS,
   HELP_TASK_MOVE_ARRAY_CONDITION_ARRAY_TYPE,
   HELP_TASK_MOVE_ARRAY_CONDITION_CAPACITY);
glossary[OPERATION_WRITE_MOVE_ARRAY].note(HELP_NOTE_MOVE_ARRAY);
glossary[OPERATION_WRITE_MOVE_ARRAY].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

glossary[HELP_GLOSSARY_NPG].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_NPG].p(HELP_GLOSSARY_NPG_DEFINITION);

glossary[HELP_GLOSSARY_ONLINE_RECOVERY_SERVER].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_ONLINE_RECOVERY_SERVER].p(HELP_GLOSSARY_ONLINE_RECOVERY_SERVER_DEFINITION);

glossary[HELP_GLOSSARY_ONLINE_SPARE].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_ONLINE_SPARE].p(HELP_GLOSSARY_ONLINE_SPARE_DEFINITION);

glossary[HELP_GLOSSARY_PARITY_GROUP].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_PARITY_GROUP].p(HELP_GLOSSARY_PARITY_GROUP_DEFINITION);

glossary[STR_PHYSICAL_DRIVE].h(STR_OVERVIEW);
glossary[STR_PHYSICAL_DRIVE].p(HELP_GLOSSARY_PHYSICAL_DRIVES_DEFINITION);

glossary[ATTR_NAME_ELEVATOR_SORT].h(STR_OVERVIEW);
glossary[ATTR_NAME_ELEVATOR_SORT].p(HELP_GLOSSARY_PHYSICAL_DRIVE_REQUEST_ELEVATOR_SORT_DEFINITION);

glossary[ATTR_NAME_PORT].h(STR_OVERVIEW);
glossary[ATTR_NAME_PORT].p(HELP_GLOSSARY_PORT_DEFINITION);

glossary[ATTR_NAME_BOOT_VOLUME_PRIMARY].h(STR_OVERVIEW);
glossary[ATTR_NAME_BOOT_VOLUME_PRIMARY].p(HELP_TASK_BOOT_VOLUME_PRIMARY);

glossary[ATTR_NAME_BOOT_VOLUME_SECONDARY].h(STR_OVERVIEW);
glossary[ATTR_NAME_BOOT_VOLUME_SECONDARY].p(HELP_TASK_BOOT_VOLUME_SECONDARY);

glossary[HELP_GLOSSARY_RAID].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_RAID].p(HELP_GLOSSARY_RAID_DEFINITION);
glossary[HELP_GLOSSARY_RAID].task(ATTR_VALUE_RAID_0, STR_NO_FAULT_TOLERANCE);
glossary[HELP_GLOSSARY_RAID].task(ATTR_VALUE_RAID_1, STR_DRIVE_MIRRORING);
glossary[HELP_GLOSSARY_RAID].task(ATTR_VALUE_RAID_10, STR_DRIVE_MIRRORING_WITH_STRIPING);
glossary[HELP_GLOSSARY_RAID].task(ATTR_VALUE_RAID_4, STR_DATA_GUARDING);
glossary[HELP_GLOSSARY_RAID].task(ATTR_VALUE_RAID_5, HELP_RAID_CMP_DDG);
glossary[HELP_GLOSSARY_RAID].task(ATTR_VALUE_RAID_6, HELP_RAID_CMP_ADG);
glossary[HELP_GLOSSARY_RAID].task(ATTR_VALUE_RAID_50, STR_STRIPING_OVER_RAID_5_DISTRIBUTED_DATA_GUARDING);
glossary[HELP_GLOSSARY_RAID].task(ATTR_VALUE_RAID_60, STR_STRIPING_OVER_RAID_6_ADVANCED_DATA_GUARDING);
glossary[HELP_GLOSSARY_RAID].html("<br/>");

glossary[HELP_GLOSSARY_RAID].h(g_sp.LS(ATTR_VALUE_RAID_0) + " - " + g_sp.LS(STR_NO_FAULT_TOLERANCE));
glossary[HELP_GLOSSARY_RAID].p(HELP_GLOSSARY_RAID_0_DEFINITION);

glossary[HELP_GLOSSARY_RAID].h(g_sp.LS(ATTR_VALUE_RAID_1) + " - " + g_sp.LS(STR_DRIVE_MIRRORING));
glossary[HELP_GLOSSARY_RAID].p(HELP_GLOSSARY_RAID_1_DEFINITION);

glossary[HELP_GLOSSARY_RAID].h(g_sp.LS(ATTR_VALUE_RAID_10) + " - " + g_sp.LS(STR_DRIVE_MIRRORING_WITH_STRIPING));
glossary[HELP_GLOSSARY_RAID].p(HELP_GLOSSARY_RAID_10_DEFINITION);

glossary[HELP_GLOSSARY_RAID].h(g_sp.LS(ATTR_VALUE_RAID_4) + " - " + g_sp.LS(STR_DATA_GUARDING));
glossary[HELP_GLOSSARY_RAID].p(HELP_GLOSSARY_RAID_4_DEFINITION);
glossary[HELP_GLOSSARY_RAID].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

glossary[HELP_GLOSSARY_RAID].h(g_sp.LS(ATTR_VALUE_RAID_5) + " - " + g_sp.LS(HELP_RAID_CMP_DDG));
glossary[HELP_GLOSSARY_RAID].p(HELP_GLOSSARY_RAID_5_DEFINITION);

glossary[HELP_GLOSSARY_RAID].h(g_sp.LS(ATTR_VALUE_RAID_50) + " - " + g_sp.LS(STR_STRIPING_OVER_RAID_5_DISTRIBUTED_DATA_GUARDING));
glossary[HELP_GLOSSARY_RAID].p(HELP_GLOSSARY_RAID_50_DEFINITION);

glossary[HELP_GLOSSARY_RAID].h(g_sp.LS(ATTR_VALUE_RAID_6) + " - " + g_sp.LS(HELP_RAID_CMP_ADG));
glossary[HELP_GLOSSARY_RAID].p(HELP_GLOSSARY_RAID_6_DEFINITION);
glossary[HELP_GLOSSARY_RAID].note(HELP_GLOSSARY_RAID_6_DEFINITION_NOTE_SUPPORT);
glossary[HELP_GLOSSARY_RAID].note(HELP_GLOSSARY_RAID_6_DEFINITION_NOTE_PD);

glossary[HELP_GLOSSARY_RAID].h(g_sp.LS(ATTR_VALUE_RAID_60) + " - " + g_sp.LS(STR_STRIPING_OVER_RAID_6_ADVANCED_DATA_GUARDING));
glossary[HELP_GLOSSARY_RAID].p(HELP_GLOSSARY_RAID_60_DEFINITION);
glossary[HELP_GLOSSARY_RAID].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

glossary[ATTR_VALUE_RAID_0].h(STR_OVERVIEW);
glossary[ATTR_VALUE_RAID_0].p(HELP_GLOSSARY_RAID_0_DEFINITION);

glossary[ATTR_VALUE_RAID_1].h(STR_OVERVIEW);
glossary[ATTR_VALUE_RAID_1].p(HELP_GLOSSARY_RAID_1_DEFINITION);

glossary[ATTR_VALUE_RAID_10].h(STR_OVERVIEW);
glossary[ATTR_VALUE_RAID_10].p(HELP_GLOSSARY_RAID_10_DEFINITION);

glossary[ATTR_VALUE_RAID_4].h(STR_OVERVIEW);
glossary[ATTR_VALUE_RAID_4].p(HELP_GLOSSARY_RAID_4_DEFINITION);

glossary[ATTR_VALUE_RAID_5].h(STR_OVERVIEW);
glossary[ATTR_VALUE_RAID_5].p(HELP_GLOSSARY_RAID_5_DEFINITION);

glossary[ATTR_VALUE_RAID_50].h(STR_OVERVIEW);
glossary[ATTR_VALUE_RAID_50].p(HELP_GLOSSARY_RAID_50_DEFINITION);

glossary[ATTR_VALUE_RAID_6].h(STR_OVERVIEW);
glossary[ATTR_VALUE_RAID_6].p(HELP_GLOSSARY_RAID_6_DEFINITION);

glossary[ATTR_VALUE_RAID_60].h(STR_OVERVIEW);
glossary[ATTR_VALUE_RAID_60].p(HELP_GLOSSARY_RAID_60_DEFINITION);

glossary[ATTR_NAME_DEGRADED_PERFORMANCE_OPTIMIZATION].h(STR_OVERVIEW);
glossary[ATTR_NAME_DEGRADED_PERFORMANCE_OPTIMIZATION].p(HELP_GLOSSARY_RAID_5_6_50_60_DEGRADED_PERFORMANCE_OPTIMIZATION_DEFINITION);

glossary[ATTR_NAME_INCONSISTENCY_REPAIR_POLICY].h(STR_OVERVIEW);
glossary[ATTR_NAME_INCONSISTENCY_REPAIR_POLICY].p(HELP_GLOSSARY_INCONSISTENCY_RAID_6_60_REPAIR_POLICY_DEFINITION);

glossary[HELP_GLOSSARY_RAID_OVERHEAD].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_RAID_OVERHEAD].p(HELP_GLOSSARY_RAID_OVERHEAD_DEFINITION);

glossary[ATTR_NAME_REBUILD_PRIORITY].h(STR_OVERVIEW);
glossary[ATTR_NAME_REBUILD_PRIORITY].p(HELP_GLOSSARY_REBUILD_PRIORITY_DEFINITION);

glossary[HELP_GLOSSARY_REDUNDANT_CONTROLLERS].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_REDUNDANT_CONTROLLERS].p(HELP_GLOSSARY_REDUNDANT_CONTROLLERS_DEFINITION);

glossary[ATTR_VALUE_BUS_TYPE_SCSI].h(STR_OVERVIEW);
glossary[ATTR_VALUE_BUS_TYPE_SCSI].p(HELP_GLOSSARY_SCSI_DEFINITION);

glossary[HELP_GLOSSARY_SCSI_ID].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_SCSI_ID].p(HELP_GLOSSARY_SCSI_ID_DEFINITION);

glossary[GUI_OPERATION_WRITE_SSP].h(STR_OVERVIEW);
glossary[GUI_OPERATION_WRITE_SSP].p(HELP_OVERVIEW_SSP);
glossary[GUI_OPERATION_WRITE_SSP].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

glossary[OPERATION_WRITE_SHRINK_ARRAY].h(STR_OVERVIEW);
glossary[OPERATION_WRITE_SHRINK_ARRAY].p(HELP_TASK_SHRINK_ARRAY);
glossary[OPERATION_WRITE_SHRINK_ARRAY].ul(
   HELP_TASK_SHRINK_ARRAY_CONDITION_FREE_SPACE,
   HELP_TASK_SHRINK_ARRAY_CONDITION_REMOVE_DRIVES,
   HELP_TASK_SHRINK_ARRAY_CONDITION_RAID_1,
   HELP_TASK_SHRINK_ARRAY_CONDITION_COMPOUND_RAID);
glossary[OPERATION_WRITE_SHRINK_ARRAY].note(HELP_NOTE_SOME_CONTROLLERS_NOT_SUPPORT_FEATURE);

glossary[ATTR_NAME_STRIPE_SIZE].h(STR_OVERVIEW);
glossary[ATTR_NAME_STRIPE_SIZE].p(HELP_GLOSSARY_STRIP_SIZE_DEFINITION);

glossary[GUI_NAME_FULL_STRIPE_SIZE].h(STR_OVERVIEW);
glossary[GUI_NAME_FULL_STRIPE_SIZE].p(HELP_GLOSSARY_STRIPE_SIZE_DEFINITION);

glossary[HELP_GLOSSARY_SURFACE_SCAN_ANALYSIS].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_SURFACE_SCAN_ANALYSIS].p(HELP_GLOSSARY_SURFACE_SCAN_ANALYSIS_DEFINITION);

glossary[HELP_GLOSSARY_TRANSIENT_DRIVE].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_TRANSIENT_DRIVE].p(HELP_GLOSSARY_TRANSIENT_DRIVE_DEFINITION);

glossary[HELP_GLOSSARY_USABLE_CAPACITY].h(STR_OVERVIEW);
glossary[HELP_GLOSSARY_USABLE_CAPACITY].p(HELP_GLOSSARY_USABLE_CAPACITY_DEFINITION);

// -- END GLOSSARY PAGES

// --------------------------

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ADD HELP PAGE STEP 3: Add help page to help folder (CHelpFolder).
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

help[HELP_GLOSSARY] = new CHelpFolder(HELP_GLOSSARY);
help[HELP_GLOSSARY].addGlossary(
   HELP_GLOSSARY_ACTIVE_SPARE,
   HELP_GLOSSARY_ADAPTER_ID,
   HELP_GLOSSARY_ADVANCED_CAPACITY_EXPANSION,
   HELP_GLOSSARY_ADVANCED_CONTROLLER_SETTINGS,
   //HELP_GLOSSARY_ADU,
   STR_ACU,
   ATTR_NAME_ARRAY_ACCELERATOR,
   STR_ARRAY,
   HELP_GLOSSARY_ARRAY_CONFIGURATION_UTILITY,
   ATTR_NAME_IS_BOOT_CONTROLLER,
   STR_BOOTABLE_VOLUME,
   HELP_GLOSSARY_CAPACITY_EXPANSION,
   ATTR_NAME_CONNECTION_NAME,
   HELP_GLOSSARY_CONTROLLER_DUPLEXING,
   STR_DUAL_DOMAIN,
   ATTR_NAME_RAID,
   ATTR_NAME_HOST_MODE,
   STR_DRIVE_ERASE,
   HELP_GLOSSARY_LOGICAL_DRIVE_EXTENSION,
   STR_LOGICAL_DRIVE,
   HELP_GLOSSARY_MAXIMUM_BOOT_SIZE,
   ATTR_NAME_QUEUE_DEPTH,
   HELP_GLOSSARY_MIGRATION,
   ATTR_NAME_MNP_DELAY,
   OPERATION_WRITE_MOVE_ARRAY,
   HELP_GLOSSARY_NPG,
   HELP_GLOSSARY_ONLINE_RECOVERY_SERVER,
   HELP_GLOSSARY_ONLINE_SPARE,
   HELP_GLOSSARY_PARITY_GROUP,
   STR_PHYSICAL_DRIVE,
   ATTR_NAME_ELEVATOR_SORT,
   ATTR_NAME_PORT,
   ATTR_NAME_BOOT_VOLUME_PRIMARY,
   ATTR_NAME_BOOT_VOLUME_SECONDARY,
   HELP_GLOSSARY_RAID,
   ATTR_VALUE_RAID_0,
   ATTR_VALUE_RAID_1,
   ATTR_VALUE_RAID_10,
   ATTR_VALUE_RAID_4,
   ATTR_VALUE_RAID_5,
   ATTR_VALUE_RAID_50,
   ATTR_VALUE_RAID_6,
   ATTR_VALUE_RAID_60,
   ATTR_NAME_DEGRADED_PERFORMANCE_OPTIMIZATION,
   ATTR_NAME_INCONSISTENCY_REPAIR_POLICY,
   HELP_GLOSSARY_RAID_OVERHEAD,
   ATTR_NAME_REBUILD_PRIORITY,
   HELP_GLOSSARY_REDUNDANT_CONTROLLERS,
   ATTR_VALUE_BUS_TYPE_SCSI,
   HELP_GLOSSARY_SCSI_ID,
   GUI_OPERATION_WRITE_SSP,
   OPERATION_WRITE_SHRINK_ARRAY,
   ATTR_NAME_STRIPE_SIZE,
   GUI_NAME_FULL_STRIPE_SIZE,
   HELP_GLOSSARY_SURFACE_SCAN_ANALYSIS,
   ATTR_NAME_EXPAND_PRIORITY,
   HELP_GLOSSARY_TRANSIENT_DRIVE,
   HELP_GLOSSARY_USABLE_CAPACITY);

// -- GETTING STARTED WITH ACU FOLDER

help[STR_GETTING_STARTED_WITH_ACU] = new CHelpFolder(STR_GETTING_STARTED_WITH_ACU);
help[STR_GETTING_STARTED_WITH_ACU].children(
   STR_GETTING_STARTED_WITH_ACU_OVERVIEW,
   STR_KEYBOARD_CONTROLS,
   STR_KEYBOARD_SHORTCUTS,
   STR_MORE_INFO,
   STR_VIEW_STATUS_MESSAGES,
   STR_IMAGE_LEGEND);

// -- CONTROLLERS FOLDER

var STR_CONTROLLERS = "STR_CONTROLLERS";
s_t[STR_CONTROLLERS] = "<!.StringMappings=STR_CONTROLLERS>";
help[STR_CONTROLLERS] = new CHelpFolder(STR_CONTROLLERS);
help[STR_CONTROLLERS].children(
   OPERATION_WRITE_CLEAR_CONFIGURATION,
   OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS,
   OPERATION_WRITE_MANAGE_ARRAY_ACCELERATOR,
   OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS,
   OPERATION_WRITE_SET_DRIVE_WRITE_CACHE,
   OPERATION_WRITE_SET_BOOT_CONTROLLER,
   GUI_OP_WRITE_SET_BOOT_VOLUME,
   GUI_OP_WRITE_MANAGE_LICENSE_KEYS,
   OPERATION_WRITE_CREATE_ARRAY,
   OPERATION_WRITE_DISABLE_OTHER_CONTROLLER,
   GUI_OPERATION_REDUNDANCY_SETTINGS);

// -- ARRAYS FOLDER

help[STR_ARRAYS] = new CHelpFolder(STR_ARRAYS);
help[STR_ARRAYS].children(
   OPERATION_WRITE_CREATE_ARRAY_2,
   OPERATION_WRITE_DELETE_ARRAY,
   //OPERATION_WRITE_REPLACE_ARRAY,
   OPERATION_WRITE_MOVE_ARRAY,
   OPERATION_WRITE_SHRINK_ARRAY,
   OPERATION_WRITE_SPLIT_ARRAY,
   OPERATION_WRITE_JOIN_ARRAY,
   OPERATION_WRITE_CREATE_LOGICAL_DRIVE,
   OPERATION_WRITE_EXPAND_ARRAY,
   OPERATION_WRITE_MANAGE_SPARE_DRIVE);

// -- LOGICAL DRIVES FOLDER

help[STR_LOGICAL_DRIVES] = new CHelpFolder(STR_LOGICAL_DRIVES);
help[STR_LOGICAL_DRIVES].children(
   OPERATION_WRITE_CREATE_LOGICAL_DRIVE_2,
   OPERATION_WRITE_DELETE_LOGICAL_DRIVE,
   OPERATION_WRITE_EXTEND_LOGICAL_DRIVE,
   OPERATION_WRITE_MIGRATE_LOGICAL_DRIVE,
   OPERATION_WRITE_REENABLE_LOGICAL_DRIVE);

// -- PHYSICAL DRIVES FOLDER

/*
help[STR_PHYSICAL_DRIVES] = new CHelpFolder(STR_PHYSICAL_DRIVES);
help[STR_PHYSICAL_DRIVES].children(
   OPERATION_WRITE_ERASE_DRIVE);
*/

// -- DRIVES FOLDER

help[STR_DRIVES] = new CHelpFolder(STR_DRIVES);
help[STR_DRIVES].children(
   OPERATION_WRITE_ERASE_DRIVE,
   STR_LOGICAL_DRIVES);

// -- CONFIGURATION FOLDER

var STR_CONFIGURATION = "STR_CONFIGURATION";
s_t[STR_CONFIGURATION] = "<!.StringMappings=STR_CONFIGURATION>";
help[STR_CONFIGURATION] = new CHelpFolder(STR_CONFIGURATION);
help[STR_CONFIGURATION].children(
   STR_CONFIGURATION_OVERVIEW,
//   OPERATION_WRITE_MANAGE_BOX_NAME,
   STR_CONTROLLERS,
   STR_ARRAYS,
   STR_DRIVES);

// -- SSP FOLDER

var STR_SSP = "STR_SSP";
s_t[STR_SSP] = "<!.StringMappings=STR_SSP>";
help[STR_SSP] = new CHelpFolder(STR_SSP);
help[STR_SSP].children(
   STR_SSP_OVERVIEW);

// -- DIAGNOSTICS FOLDER

var STR_DIAGNOSTICS = "STR_DIAGNOSTICS";
s_t[STR_DIAGNOSTICS] = "<!.StringMappings=STR_DIAGNOSTICS>";
help[STR_DIAGNOSTICS] = new CHelpFolder(STR_DIAGNOSTICS);
help[STR_DIAGNOSTICS].children(
   STR_DIAGNOSTICS_OVERVIEW);

// -- WIZARDS FOLDER

var STR_WIZARDS = "STR_WIZARDS";
s_t[STR_WIZARDS] = "<!.StringMappings=STR_WIZARDS>";
help[STR_WIZARDS] = new CHelpFolder(STR_WIZARDS);
help[STR_WIZARDS].children(
   STR_WIZARDS_OVERVIEW);

// -- ROOT FOLDER (root of the help content tree)

var rootHelpFolder = new CHelpFolder("");
rootHelpFolder.children(
   STR_WELCOME_TO_ACU, 
   STR_GETTING_STARTED_WITH_ACU,
   STR_CONFIGURATION,
   STR_SSP,
   STR_DIAGNOSTICS,
   STR_WIZARDS,
   HELP_GLOSSARY);

// ----------------------------
// END ADDING HELP FOLDERS HERE
// ----------------------------

var selectedHelpPage = STR_WELCOME_TO_ACU; // current help page to be displayed
var selectedHelpFolder = ""; // the folder the current help page is located in

// ---------------------------
// BEGIN HELP SYSTEM FUNCTIONS
// ---------------------------


function getHistoryImage(sImgSrc, sImgName, sAlt)
{
   var sAttr = 'name="' + sImgName + '" alt="' + sAlt + '"';
   return filterIcon(sImgSrc, '20px', '20px', '', '', sAttr);
}

// Displays the help content for the given page (sLinkName)
function loadHelpContent(sLinkName, isDefinition, showParents, byHistory)
{
   var helpContent = document.getElementById("helpContent");
   var oHelpPage;

   if (typeof(isDefinition) != "undefined" && isDefinition == '1')
   {
      oHelpPage = glossary[sLinkName];
      helpContent.innerHTML = oHelpPage.draw();
   }
   else
   {
      oHelpPage = help[sLinkName];
      helpContent.innerHTML = oHelpPage.draw();
   }

   if ((byHistory == undefined) && (g_history_sLinkName != sLinkName))
   {
      if (g_history.length == 0)
      {
         // initialize the current position
         g_history_curPos = 0;
      } 
      else
      {
         // Increament the current position
         g_history_curPos += 1;
      }

      // Delete the older branch of history and start the new history branch by adding
      // a new value at the current posion. This is neccessary when user jump to a new page
      // from the previously viewed page. 
      // The current position is less than or equal to the array value position
      if (g_history_curPos < g_history.length)
      {
         g_history.splice(g_history_curPos, g_history.length - g_history_curPos, oHelpPage);
         g_history_curPos = g_history.length - 1;
      } 
      else
      {
            g_history[g_history.length] = oHelpPage;
      }
   }
   g_history_sLinkName = sLinkName;
   g_currentPage = oHelpPage;

   // clear previously selected
   if(selectedHelpPage != '')
   {
      var oldTreeLink = document.getElementById("tree_0" + selectedHelpPage); // for help pages
      if (oldTreeLink)
      {
         oldTreeLink.className = "notSelected";
      }
      oldTreeLink = document.getElementById("tree_1" + selectedHelpPage); // for glossary pages
      if (oldTreeLink)
      {
         oldTreeLink.className = "notSelected";
      }
   }
   var newTreeLink = document.getElementById("tree_" + isDefinition + sLinkName);
   newTreeLink.className = "selected";
   selectedHelpPage = sLinkName;

   // If showParents is true, then call show() on the parents).
   if(showParents)
   {
      if(isDefinition == '1')
      {
         if(glossary[selectedHelpPage].getParent() != '')
         {
            help[glossary[selectedHelpPage].getParent()].show();
         }
      }
      else
      {
         if(help[selectedHelpPage].getParent() != '')
         {
            help[help[selectedHelpPage].getParent()].show();
         }
      }
   }
   
   // Browse History
   if (g_history.length > 1)
   {
      if (byHistory != undefined)
      {
         if (byHistory == "back")
         {
            g_history_curPos = g_history_curPos - 1;
         }
         if (byHistory == "forw")
         {
            g_history_curPos = g_history_curPos + 1;
         }
      }

      //going backward
      if (g_history.length > 1 && g_history_curPos > 0)
      {
         document.getElementById("linkNavBack").style.display = "inline";
         document.getElementById("historyBackwardOff").style.display = "none";
         document.getElementById("historyBackwardOn").style.display = "none";
         document.getElementById("historyBackward").style.display = "inline";
      } 
      else
      {
         document.getElementById("linkNavBack").style.display = "none";
         document.getElementById("historyBackwardOn").style.display = "none";
         document.getElementById("historyBackward").style.display = "none";
         document.getElementById("historyBackwardOff").style.display = "inline";
      }


      //going forward
      if (g_history.length - g_history_curPos > 1 )
      {
         document.getElementById("linkNavForw").style.display = "inline";
         document.getElementById("historyForwardOff").style.display = "none";
         document.getElementById("historyForwardOn").style.display = "none";
         document.getElementById("historyForward").style.display = "inline";
      } 
      else
      {
         document.getElementById("linkNavForw").style.display = "none";
         document.getElementById("historyForwardOn").style.display = "none";
         document.getElementById("historyForward").style.display = "none";
         document.getElementById("historyForwardOff").style.display = "inline";
      }
   }
}

// controlls button hehavior on mouse over
// input:
//    imgName      - Name of the image button.

function changeBackImage()
{
   if (g_history.length > 1 && g_history_curPos > 0)
   {
      document.getElementById("historyBackwardOff").style.display = "none";
      document.getElementById("historyBackward").style.display = "none";
      document.getElementById("historyBackwardOn").style.display = "inline";
   }
}

function changeForwImage()
{

   if (g_history.length - g_history_curPos > 1)
   {
      document.getElementById("historyForwardOff").style.display = "none";
      document.getElementById("historyForward").style.display = "none";
      document.getElementById("historyForwardOn").style.display = "inline";
   }
}

function changeBackImageBack()
{
   if (g_history.length > 1 && g_history_curPos > 0)
   {
      document.getElementById("historyBackwardOff").style.display = "none";
      document.getElementById("historyBackwardOn").style.display = "none";
      document.getElementById("historyBackward").style.display = "inline";
   }
}

function changeForwImageBack()
{
   if (g_history.length - g_history_curPos > 1)
   {
      document.getElementById("historyForwardOff").style.display = "none";
      document.getElementById("historyForwardOn").style.display = "none";
      document.getElementById("historyForward").style.display = "inline";
   }
}


// Displays the help tree (links)
function loadHelpTree()
{
   var helpTreeRoot = document.getElementById("helpTreeRoot");
   helpTreeRoot.innerHTML = rootHelpFolder.draw();
   var tempParent = selectedHelpFolder;
   while(tempParent != '')
   {
      help[tempParent].show();
      tempParent = help[tempParent].getParent();
   }
}

// An inline link to be displayed in help content.
// Input:
//    sLinkName      - Name of the link.
//    isDefinition   - True/false if the link is a definition for the glossary.
//    bCaseSensitive - True/false if search for inline link is case sensitive.
//    exceptions     - Phrases containing the link name that are to be ignored
//                     when finding links in help content.
function CInlineLink(sLinkName, isDefinition, bCaseSensitive, exceptions)
{
   var m_sLinkName      = sLinkName;
   var m_isDefinition   = isDefinition;
   var m_sLinkText      = g_sp.LS(sLinkName);
   var m_bCaseSensitive = typeof(bCaseSensitive) == "undefined" ? false : bCaseSensitive;
   var m_exceptions     = exceptions;

   // Returns the link name.
   this.getLinkName = function()
   {
      return m_sLinkName;
   }

   // Returns whether or not this link name is a definition.
   this.getIsDefinition = function()
   {
      return m_isDefinition;
   }

   // Returns whether or not search for inline link is case sensitive.
   this.getCaseSensitive = function()
   {
      return m_bCaseSensitive;
   }

   // Returns the link to be used in help content.
   this.getInlineLink = function()
   {
      if(m_isDefinition)
      {
         return glossary[m_sLinkName].getInlineLink(m_sLinkText);
      }
      else
      {
         return help[m_sLinkName].getInlineLink(m_sLinkText);
      }
   }

   // Returns the length of the translated link name.
   this.getLinkNameLength = function()
   {
      return (g_sp.LS(m_sLinkName)).length;
   }
   
   // Returns the length of the link text.
   this.getLinkTextLength = function()
   {
      if(m_sLinkText == "")
      {
         return (g_sp.LS(m_sLinkName)).length;
      }
      else
      {
         return m_sLinkText.length;
      }
   }     

   // Returns the target string to be searched for in the source content.
   this.getTarget = function()
   {
      return m_bCaseSensitive ? m_sLinkText : m_sLinkText.toLowerCase();
   }

   // Returns the link text.
   this.getLinkText = function()
   {
      return m_sLinkText;
   }

   // Returns the exceptions.
   this.getExceptions = function()
   {
      return m_exceptions;
   }
   
   // Sets the link text.
   this.setLinkText = function(sText)
   {
      m_sLinkText = sText;
   }

   // Checks if given link name is the same as this one.
   this.isLinkName = function(sLN)
   {
      return sLN == m_sLinkName;
   }
   
   // Updates this CInlineLink to the one passed in.
   this.update = function(oInlineLink)
   {
      m_sLinkName = oInlineLink.getLinkName();
      m_isDefinition = oInlineLink.getIsDefinition();
      m_sLinkText = oInlineLink.getLinkText();
      m_bCaseSensitive = oInlineLink.getCaseSensitive();
      delete m_exceptions;
      m_exceptions = oInlineLink.getExceptions();
   }

   // Returns the index of the target in the source content.   
   this.findTarget = function(sSrc, sTarget)
   {
      var sSrc = m_bCaseSensitive ? sSrc : sSrc.toLowerCase();
      var searchResult = sSrc.indexOf(sTarget);
      if(typeof(m_exceptions) != "undefined")
      {
         for(var i = 0; i < m_exceptions.length && searchResult != -1; ++i)
         {
            var exc = m_bCaseSensitive ? g_sp.LS(m_exceptions[i]) :
                      g_sp.LS(m_exceptions[i]).toLowerCase();
            // If exception found, then mark search result as not found.
            if(searchResult == 
               sSrc.indexOf(exc))
            {
               searchResult = -1;
            }
         }
      }
      return searchResult;
   }

   // Returns the index of where the link is found in the content.
   // Returns -1 if not found.
   this.find = function(sContent)
   {
      return this.findTarget(sContent, this.getTarget());
   }

   // The following methods are for English language translation only.
   // Returns the plural suffix for the link name.
   this.getPluralSuffix = function()
   {
      var len = this.getLinkNameLength();
      if(len > 0 && 
         this.getTarget().charAt(len-1) == "s")
      {
         return "es";
      }
      else
      {
         return "s";
      }
   }

   // Returns the index of where the pluralized link is found in the content.
   // Returns -1 if not found.
   this.findPlural = function(sContent)
   {
      return this.findTarget(sContent, this.getTarget() +
                                       this.getPluralSuffix());
   }

   // Returns the length of the plural suffix for hte link name.
   this.getPluralLength = function()
   {
      return this.getLinkNameLength() +
             this.getPluralSuffix().length;
   }
}
// Adds inline links for keywords matching the name of help pages added to the 'help' and 'glossary' arrays.
// Input:
//    sContent  - the content to find inline links for.
//    sLinkName - the link name of the page that the content came from.
function addInlineLinks(sContent, sLinkName)
{
   var m_foundIndices = new Array();
   var m_foundInlineLinks = new Array();
   var m_sContentWithLinks = sContent;

   for(var index = 0; index < g_inlineLinks.length; ++index)
   {
      // Do not add inline links to self.
      if(!g_inlineLinks[index].isLinkName(sLinkName))
      {
         var searchResult = g_inlineLinks[index].find(sContent);
         // Only create a link for the first match in content.
         if(searchResult != -1)
         {
            // See if longer form of the search phrase exists at same location.
            // Do this for English only.
            var bPluralFound = false;
            if(g_languageCode == "en")
            {
               bPluralFound = searchResult == 
                              g_inlineLinks[index].findPlural(sContent);
            }
            if(typeof(m_foundInlineLinks[searchResult]) == "undefined")
            {
               // Save index.
               m_foundIndices[m_foundIndices.length] = searchResult;
               // Save search string.
               // If plural match was found, copy inline link without
               // the exceptions.
               if(bPluralFound)
               {
                  m_foundInlineLinks[searchResult] = new CInlineLink(
                     g_inlineLinks[index].getLinkName(),
                     g_inlineLinks[index].getIsDefinition(),
                     g_inlineLinks[index].getCaseSensitive());
                  m_foundInlineLinks[searchResult].setLinkText(sContent.substr(
                     searchResult,
                     m_foundInlineLinks[searchResult].getPluralLength()));
               }
               else
               {
                  m_foundInlineLinks[searchResult] = new CInlineLink();
                  m_foundInlineLinks[searchResult].update(g_inlineLinks[index]);
                  m_foundInlineLinks[searchResult].setLinkText(sContent.substr(
                     searchResult,
                     m_foundInlineLinks[searchResult].getLinkTextLength()));
               }
            }
            // Save search string only if it is longer than the previous search
            // string that matched.
            else if(g_inlineLinks[index].getLinkNameLength() > 
                    m_foundInlineLinks[searchResult].getLinkNameLength())
            {
               // Overwrite the old search string with the new one.
               m_foundInlineLinks[searchResult].update(g_inlineLinks[index]);
               // If plural match was found at same location, update link text 
               // to include the plural suffix.
               if(bPluralFound)
               {
                  m_foundInlineLinks[searchResult].setLinkText(sContent.substr(
                     searchResult,
                     m_foundInlineLinks[searchResult].getPluralLength()));
               }
               else
               {
                  m_foundInlineLinks[searchResult].setLinkText(sContent.substr(
                     searchResult,
                     m_foundInlineLinks[searchResult].getLinkTextLength()));
               }
            }
         }
      }
   }

   function sortNumber(a,b)
   {
      return a - b;
   }
   // Sort the list of indices.
   m_foundIndices.sort(sortNumber);

   var prevPosEnd = -1;
   // Now make sure no search string runs into another. If one does, only keep
   // the string that came first in the content.
   for (var index = 0; index < m_foundIndices.length; ++index)
   {
      var currPosBegin = m_foundIndices[index];
      // Check if current string runs into previous string.
      if(currPosBegin <= prevPosEnd)
      {
         // It does, so remove the current string since the previous came first
         // in the content.
         delete m_foundInlineLinks[currPosBegin];
         delete m_foundIndices[index];
      }
      else
      {
         // It does not, so we can safely advance the end position that we want
         // to make sure no other search strings touch.
         prevPosEnd = m_foundInlineLinks[currPosBegin].getLinkTextLength() + 
                      currPosBegin - 1;
      }
   }

   for (var revIndex = m_foundIndices.length - 1; revIndex >= 0; --revIndex)
   {
      // m_foundIndices contains deleted entries, so only look at defined ones.
      // m_foundInlineLinks only contains entries that are mapped by
      // m_foundIndices, so no need to check if defined.
      if(typeof(m_foundIndices[revIndex]) != "undefined")
      {
         var posBegin = m_foundIndices[revIndex];
         var posEnd = m_foundInlineLinks[posBegin].getLinkTextLength() + posBegin;
         m_sContentWithLinks = m_sContentWithLinks.substr(0, posBegin) +
                               m_foundInlineLinks[posBegin].getInlineLink() +
                               m_sContentWithLinks.substr(posEnd);
      }
   }
   return m_sContentWithLinks;
}

// CHelpFolder is a folder containing methods to add and retrieve pages or folders
function CHelpFolder(sLinkName)
{
   // Folder link name
   var m_sLinkName = sLinkName;
   
   // The folder's contents
   var m_children = new Array();

   // The folder's glossary
   var m_glossary = new Array();

   // The folder's parent folder
   var m_sParent = '';
   
   // Takes in and adds any number of children
   this.children = function()
   {
      for(var i = 0; i < arguments.length; ++i)
      {
         m_children[m_children.length] = arguments[i];
         help[arguments[i]].setParent(m_sLinkName);
      }
   }

   // Takes in and adds any number of children for the glossary
   this.addGlossary = function()
   {
      for (var i = 0; i < arguments.length; ++i)
      {
         m_glossary[m_glossary.length] = arguments[i];
         glossary[arguments[i]].setParent(m_sLinkName);
      }
   }

   // Get the parent of this folder (which is another folder)
   this.getParent = function()
   {
      return m_sParent;
   }
   
   // Set the parent of this folder
   this.setParent = function(parent)
   {
      m_sParent = parent;
   }
   
   // Get the link for this folder in the help tree
   this.getLink = function()
   {
      var treeImg = "images/themes/blue/button_tree_expand.gif";
      if(selectedHelpFolder != '' && (m_sLinkName == selectedHelpFolder ||  help[selectedHelpFolder].isAncestor(m_sLinkName)))
      {
         treeImg = "images/themes/blue/button_tree_contract.gif";
      }
      var link = '<a onclick=help["'+m_sLinkName+'"].toggle() href=#><img id="img_'+m_sLinkName+'" class="treeIcon" src="'+treeImg+'" /></a><a onclick=help["'+m_sLinkName+'"].click() href=# class="notSelected" style="font-weight:bold;">'+g_sp.LS(m_sLinkName)+'</a><ul style="padding-top:2px;" class="hidden" id="folder_'+m_sLinkName+'">'+this.draw()+"</ul>"; 
      return link;
   }

   // Check if given link name is an ancestor of this folder
   this.isAncestor = function(sLinkName)
   {
      return m_sParent != '' && (m_sParent == sLinkName || help[m_sParent].isAncestor(sLinkName));
   }

   // Toggle this folder in the help tree (show/hide its children)
   this.toggle = function()
   {
      if(document.getElementById("img_"+m_sLinkName).getAttribute("src").indexOf("expand") != -1)
      {
         this.show();
      }
      else
      {
         this.hide();
      }
   }

   // Called when link is clicked
   this.click = function()
   {
      //var helpTreeRoot = document.getElementById("helpTreeRoot");
      selectedHelpFolder = m_sLinkName;
      //helpTreeRoot.innerHTML = rootHelpFolder.draw();
      //this.show();
      this.toggle();
   }

   // Draw the contents of this folder in the help tree
   this.draw = function()
   {
      var content = '';
      for(var i=0; i<m_children.length; i++)
      {
         content += "<li>";
         content += help[m_children[i]].getLink();
         content += "</li>";
      }
      for (var i = 0; i < m_glossary.length; i++)
      {
         content += "<li>";
         content += glossary[m_glossary[i]].getLink();
         content += "</li>";
      }
      return content;
   }

   // Hide the child links
   this.hide = function()
   {
      document.getElementById("img_"+m_sLinkName).setAttribute("src", "images/themes/blue/button_tree_expand.gif");
      document.getElementById("folder_"+m_sLinkName).className = "hidden";      
   }

   // Show the child links
   this.show = function()
   {
      document.getElementById("img_"+m_sLinkName).setAttribute("src", "images/themes/blue/button_tree_contract.gif");
      document.getElementById("folder_"+m_sLinkName).className = "";
      if(m_sParent != '')
      {
         help[m_sParent].show();
      }      
   }
   
   // Recursively contract all the folders within this folder
   this.hideAll = function()
   {
      for(var i=0; i<m_children.length; i++)
      {
         if(help[m_children[i]] instanceof CHelpFolder)
         {
            help[m_children[i]].hide();
            help[m_children[i]].hideAll();
         }
      }
   }
   
   // Recursively expand all the folders within this folder
   this.showAll = function()
   {
      for(var i=0; i<m_children.length; i++)
      {
         if(help[m_children[i]] instanceof CHelpFolder)
         {
            help[m_children[i]].show();
            help[m_children[i]].showAll();
         }
      }
   }
}



// Help page containing methods for adding and retrieving help content.
// Input:
//    sLinkName      - Name of the link shown in the contents tree.
//    sHelpHeader    - The title of the help content section of the help page.
//    isDefinition   - True/false: help page is a definition for the glossary.
//    addInlineLink  - True/false: the name of the help page should be added as 
//                     a search string when adding inline links to help content.
//    bCaseSensitive - True/false: search for inline link is case sensitive.
//    exceptions     - An array of strings that specify in what context inline 
//                     links should not be generated for this help page.
function CHelpPage(sLinkName, sHelpHeader, isDefinition, addInlineLink, bCaseSensitive, exceptions){
   // Page link name
   var m_sLinkName = sLinkName;

   if(addInlineLink)
   {
      g_inlineLinks[g_inlineLinks.length] = new CInlineLink(sLinkName, isDefinition, bCaseSensitive, exceptions);
   }

   // Content page header
   var m_sHeader = '<div class="helpContentHeader">' + g_sp.LS(sHelpHeader) + "</div>";
   
   // Is page a defintion in the glossary
   var m_isDefinition = isDefinition ? '1' : '0';

   // The page's parent folder
   var m_sParent = '';
   
   // Content body containing multiple sections
   var m_body = new Array();
   
   // Get the page body
   this.getBody = function()
   {
      return m_body;
   }

   // Set the page body
   this.setBody = function(body)
   {
      m_body = body;
   }

   // Get the parent of the help page (the folder the page belongs to)
   this.getParent = function()
   {
      return m_sParent;
   }
   
   // Set the parent of the help page
   this.setParent = function(parent)
   {
      m_sParent = parent;
   }
   
   // Takes and adds a body section header
   this.h = function(sSectionHeader)
   {
      m_body[m_body.length] = "<h2>"+g_sp.LS(sSectionHeader)+"</h2>";
   }
   
   // Takes in and adds any number of paragraphs of content
   this.p = function()
   {
      for(var i=0; i<arguments.length; i++)
      {
         // Add inline links to content.
         m_body[m_body.length] = 
            "<p>" + addInlineLinks(g_sp.LS(arguments[i]), sLinkName) + "</p>";
      }
   }
   
   // Adds a note to the help page
   this.note = function(sNote)
   {
      m_body[m_body.length] = 
         "<p><strong>" + g_sp.LS(HELP_NOTE) + ": </strong>" + 
         addInlineLinks(g_sp.LS(sNote), sLinkName) + "</p>";
   }
   
   // Adds a task option description including a task name and a task description to the help page
   this.task = function(sTaskName, sTaskDesc)
   {
      m_body[m_body.length] = 
         '<div class="helpTask"><div class="helpTaskName">' + 
         g_sp.LS(sTaskName) + '</div><div class="helpTaskDesc">' + 
         addInlineLinks(g_sp.LS(sTaskDesc), sLinkName) + 
         '</div><div style="clear:both;"></div></div>';
   }
   
   // Takes in and adds any number of steps for a procedures table
   this.steps = function()
   {
      var numSteps = arguments.length;
      if(numSteps>0)
      {
         var stepNum;
         this.beginTable();
         for(var i=0; i<numSteps; i++)
         {
            stepNum = i+1;
            m_body[m_body.length] = 
               '<tr><td style="width:15px;padding-right:5px;border:0;">' + 
               stepNum + '.</td><td style="border:0;">' +
               addInlineLinks(g_sp.LS(arguments[i]), sLinkName) + '</td></tr>';
         }
         this.endTable();
      }
   }
   
   // Takes in any number of image and text pairs to add a legend to the help page
   this.legend = function()
   {
      var numSteps = arguments.length;
      if(numSteps>0 && numSteps%2==0)
      {
         this.beginTable();
         for(var i=0; i<numSteps; i+=2)
         {
            m_body[m_body.length] = 
               '<tr><td style="width:20px;padding-right:5px;border:0;">' 
               + arguments[i] +
               '</td><td style="border:0;vertical-align:middle;font-weight:bold;">' +
               addInlineLinks(g_sp.LS(arguments[i+1]), sLinkName) +
               '</td></tr>';
         }
         this.endTable();
      }
   }
   
   // Add table opening tag to help page
   this.beginTable = function()
   {
      m_body[m_body.length] = '<table style="margin-bottom:15px; border:0; font-size:100%;" border="0" cellpadding="0" cellspacing="0">';
   }
   
   // Add table closing tag to help page   
   this.endTable = function()
   {
      m_body[m_body.length] = '</table>';
   }
   
   // Takes in and adds any number of items for an unordered list
   this.ul = function()
   {
      var numSteps = arguments.length;
      if(numSteps>0)
      {
         m_body[m_body.length] = '<ul style="font-size:100%;">';
         for(var i=0; i<numSteps; i++)
         {
            m_body[m_body.length] = '<li>' +
               addInlineLinks(g_sp.LS(arguments[i]), sLinkName) + '</li>';
         }
         m_body[m_body.length] = '</ul>';
      }
   }
   
   // Adds HTML to the help page
   this.html = function(sHTML)
   {
      m_body[m_body.length] = sHTML;
   }
   
   // Returns the link to the help page for the help tree
   this.getLink = function()
   {
      var linkClass = 'notSelected';

      if (selectedHelpPage == m_sLinkName)
      {
         linkClass = 'selected';
      }
      var mozPadding = '';
      if (g_isMoz)
      {
         mozPadding = ' style="padding-right:3px;"';
      }
      var link = '<img class="treeIcon" src="images/spacer12.gif"' + mozPadding + ' />' + 
                 '<a id="tree_' + m_isDefinition + m_sLinkName + 
                 '" onclick="loadHelpContent(' + m_sLinkName + ", " + m_isDefinition + ", false" +
                 ');" href=# class="' + linkClass + '">' + g_sp.LS(m_sLinkName) + '</a>';
      return link;
   }

   // Get the link of the help page for an inline link.
   this.getInlineLink = function(sLinkText)
   {
      var sText;
      if(typeof(sLinkText) != "undefined" && sLinkText != "")
      {
         sText = sLinkText;
      }
      else
      {
         sText = g_sp.LS(m_sLinkName);
      }
      var link = '<a id="tree_' + m_isDefinition + m_sLinkName + 
                 '" onclick="loadHelpContent(' + m_sLinkName + ", " + m_isDefinition + ", true" +
                 ');" href=#>' + sText + '</a>';
      return link;
   }

   // Returns the linkname
   this.getLinkName = function()
   {
      return m_sLinkName;
   }

   // Returns whether or not this page is a definition page.
   this.getIsDefinition = function()
   {
      return m_isDefinition;
   }

   // Returns the HTML representation of the help content
   this.draw = function()
   {
      var content = m_sHeader;
      content += '<div class="helpContentBody"';
      if (!g_isMoz)
      {
         content += ' style="height:421px;" ';
      }
      content += ">";
      content += this.buildBodyContent();
      content += "<br/></div>";
      return content;
      //document.write(content);
   }

   // Returns the HTML representation of the help content in printable format
   this.drawPrintableContent = function()
   {
      var content = "";
      content += '<h1>' + g_sp.LS(sHelpHeader) + '</h1>';            
      content += this.buildBodyContent();
      return content;
   }
   
   // Contructs content body
   this.buildBodyContent = function()
   {         
      var content = "";
      for (var i = 0; i < m_body.length; ++i)
      {
         content += m_body[i];
      }
      return content;
   }
}

// Determines whether or not an operation has help content
function hasOp(opName)
{
   return help[opName] ? true : false;
}

// Expands every folder in the help tree
function showAll()
{
   rootHelpFolder.showAll();
   return false;
}

// Contracts every folder in the help tree
function hideAll()
{
   rootHelpFolder.hideAll();
   return false;
}

var ourButtonManager = new ButtonManager(); // used for the expander buttons

function onBackClick()
{
   var oHPBack = g_history[g_history_curPos - 1];
   loadHelpContent(oHPBack.getLinkName(), oHPBack.getIsDefinition(), true, 'back');
}

function onForwardClick()
{
   var oHPForw = g_history[g_history_curPos + 1];
   loadHelpContent(oHPForw.getLinkName(), oHPForw.getIsDefinition(), true, 'forw');
}

// This function is called (widgets_ext.js) after the help popup page is finished loading to display the help content.
function load(){
   var selectedHelpPage = document.getElementById("taskHelpOpName").value;
   if(!hasOp(selectedHelpPage)){
      var currentTab = document.getElementById("currentTab").value;
      if(g_sp.LS(currentTab) == "<!.StringMappings=STR_CONFIGURE>"){
         selectedHelpPage = STR_CONFIGURATION_OVERVIEW;
      }else if(g_sp.LS(currentTab) == "<!.StringMappings=STR_SSP>"){
         selectedHelpPage = STR_SSP_OVERVIEW;
      }else if(g_sp.LS(currentTab) == "<!.StringMappings=STR_DIAGNOSE>"){
         selectedHelpPage = STR_DIAGNOSTICS_OVERVIEW;
      }else if(g_sp.LS(currentTab) == "<!.StringMappings=STR_WIZARDS>"){
         selectedHelpPage = STR_WIZARDS_OVERVIEW;
      }else{
         selectedHelpPage = STR_WELCOME_TO_ACU;
      }
   }
   selectedHelpFolder = help[selectedHelpPage].getParent();
   loadHelpTree();
   loadHelpContent(selectedHelpPage, '0', false); // '0' indicates help page, not glossary page
   var n = document.getElementById('POPUP_MARGIN');
   n.style['margin'] = '0 0 10px 0';
	ourButtonManager.init();

   // Backward
	document.getElementById("historyBackwardOn").innerHTML = getHistoryImage("images/backwardon20.png", "hBackward", "History Backward");
	document.getElementById("historyBackward").innerHTML = getHistoryImage("images/backward20.png", "hBackward", "History Backward");
   // Forward
   document.getElementById("historyForwardOn").innerHTML = getHistoryImage("images/forwardon20.png", "hForward", "History Forward");
   document.getElementById("historyForward").innerHTML = getHistoryImage("images/forward20.png", "hForward", "History Forward");
   // Initialize Help Search Box.
   var helpSearch = new CHelpSuggest("helpSearchInput");
}
// -------------------------
// END HELP SYSTEM FUNCTIONS
// -------------------------

</script>
</head>
<body onbeforeprint="HandleOnBeforePrint();" onafterprint="HandleOnAfterPrint();" oncontextmenu="return false;">

<div id="POPUP_CONTAINER" style="overflow:auto;height:100%;">

<!--Add a nice header - WITH a print icon thing-->
<div>
<table border='0' cellpadding='0' cellspacing='0' width='100%' class='applicationMastheadSmall'>
   <tr>
      <td class="mastheadIcon" width="30"><img src="images/logo_hp_masthead.gif" width="30" alt="HP"/></td>
      <td class="mastheadTitle" style="padding-bottom:9px;"><h1 id="POPUP_HEADER_ID"></h1></td>
      <td id="POPUP_PRINT_BUTTON_ID" valign="middle" width="75px" height="39px" style="display:none;font-size:90%;cursor:hand;padding-top:5px;"><a href='' style="cursor:hand;" onclick='window.print();return false;'>
      <script type="text/javascript">document.write(filterIcon('images/printer30.png', '30px', '30px', 'iconFilter'));</script><span id="POPUP_PRINT_TEXT_ID"></span></a>
      </td>
   </tr>
</table>
</div> 
<div id="POPUP_MARGIN">
<div id="POPUP_TEXT_ID">
</div>
</div>
<div style="text-align:center;"><a href="#" style="color:#003366;" onclick="window.close()"><span id="POPUP_CLOSE_TEXT"></span></a></div>

</div>
<div id="PRINTABLE_CONTAINER" style="display:none;">
</div>
</body>
<script type="text/javascript">
   // Prevent the F5 page refresh, as that will clear the page! Eeh-gads! 
   if(document.addEventListener) 
   {
      document.addEventListener("keypress", PreventRefresh, true);   
   }
   else
   {
      document.onkeydown = PreventRefresh;
   }
   function PreventRefresh(ev)
   {
      var nKeyCode = ev ? ev.keyCode : window.event.keyCode; 
      if( nKeyCode == 116 ) // F5 - value 116
      {
         if(!ev)
         {
            try {
             event.keyCode = 0;
            }
            catch(e){
            // do nothing
            }
            event.returnValue = false;
         }
         else
         {
            ev.preventDefault(); 
            if (ev.stopPropagation) ev.stopPropagation();            
         }
      }    
   }
</script>
</html>
