
function ButtonManager()
{
}
ButtonManager.prototype.getWrapperReference= function(btnWrapperObj)
{
var ob= btnWrapperObj;
var className= ob.className;
while (className.indexOf("bWrapper")==-1)
{
ob= ob.parentNode;
className= ob.className;
}
return ob;
}
ButtonManager.prototype.hpButtonOver= function(btnWrapperObj)
{
if (!this.getButtonChild(btnWrapperObj).disabled)
{
var ob= this.getWrapperReference(btnWrapperObj);
if (ob.className.indexOf("bEmphasized")!=-1)
{
ob.className= "bWrapperOver bEmphasized";
}
else
{
ob.className= "bWrapperOver";
}
}
}
ButtonManager.prototype.hpButtonUp= function(btnWrapperObj)
{
if (!this.getButtonChild(btnWrapperObj).disabled)
{
var ob= this.getWrapperReference(btnWrapperObj);
if (ob.className.indexOf("bEmphasized")!=-1)
{
ob.className= "bWrapperUp bEmphasized";
}
else
{
ob.className= "bWrapperUp";
}
}
}
ButtonManager.prototype.hpButtonDown= function(btnWrapperObj)
{
var ob= this.getWrapperReference(btnWrapperObj);
var childButton= this.getButtonChild(btnWrapperObj);
if (!childButton.disabled)
{
if (ob.className.indexOf("bEmphasized")!=-1)
{
ob.className= "bWrapperDown bEmphasized";
}
else
{
ob.className= "bWrapperDown";
}
childButton.focus();
}
}
ButtonManager.prototype.disableButton= function(btnObj)
{
btnObj.disabled= true;
var wrapper= this.getWrapperReference(btnObj);
var wrapper= this.getWrapperReference(btnObj);
wrapper.onmousedown= null;
wrapper.onmouseup=  null;
wrapper.onmouseover=  null;
wrapper.onmouseout=  null;
if (wrapper.className.indexOf("bEmphasized")!=-1)
{
wrapper.className= "bWrapperDisabled bEmphasized";
}
else
{
wrapper.className= "bWrapperDisabled";
}
}
ButtonManager.prototype.enableButton= function(btnObj)
{
btnObj.disabled= false;
var wrapper= this.getWrapperReference(btnObj);
if (wrapper.className.indexOf("bEmphasized")!=-1)
{
wrapper.className= "bWrapperUp bEmphasized";
}
else
{
wrapper.className= "bWrapperUp";
}
var wrapper= this.getWrapperReference(btnObj);
wrapper.onmousedown= function()
{ourButtonManager.hpButtonDown(this);}
wrapper.onmouseup= function()
{ourButtonManager.hpButtonOver(this);}
wrapper.onmouseover= function()
{ourButtonManager.hpButtonOver(this);}
wrapper.onmouseout= function()
{ourButtonManager.hpButtonUp(this);}
}
ButtonManager.prototype.disableButtonById= function(btnId)
{
var btnObj= document.getElementById(btnId);
this.disableButton(btnObj);
}
ButtonManager.prototype.enableButtonById= function(btnId)
{
var btnObj= document.getElementById(btnId);
this.enableButton(btnObj);
}
ButtonManager.prototype.getButtonChild= function(divObj)
{
var obj= divObj;
while ((obj.childNodes[0]!=null) && ((obj.tagName!="BUTTON") && (obj.tagName!="INPUT")) &&  (obj.tagName!="A") && (obj.tagName!="SUBMIT") )
{
var isFound= false;
for(var i=0; i<obj.childNodes.length && !isFound; ++i)
{
if(obj.childNodes[i].nodeType==1)
{
obj= obj.childNodes[i];
isFound= true;
}
} 
}
return obj;
}
ButtonManager.prototype.init= function() 
{
var divs= document.getElementsByTagName("DIV");
for (var i=0;i<divs.length;i++) 
{ 
if (divs[i].className.indexOf("bWrapper")!=-1) 
{ 
var button= this.getButtonChild(divs[i]);
var lookingForVerticalButtonSet= divs[i];
while ((lookingForVerticalButtonSet) && (lookingForVerticalButtonSet.className!="verticalButtonSet")) 
{
lookingForVerticalButtonSet= lookingForVerticalButtonSet.parentNode;
}
if (lookingForVerticalButtonSet) 
{
button.style.width= "100%";
}
else if ((!button.getAttribute("disableminimumwidth")) && (button.className.indexOf("shrinkWrapButton")==-1))
{ 
if (button.className.indexOf("hpButtonSmall")!=-1) 
{ 
if (button.offsetWidth < 47) button.style.width= "47px";
}
else if (button.className.indexOf("hpButtonVerySmall")!=-1) 
{
}
else if (button.offsetWidth < 83) button.style.width= "83px";
}
if (!button.disabled) 
{
divs[i].onmousedown= function()
{ourButtonManager.hpButtonDown(this);}
divs[i].onmouseup= function()
{ourButtonManager.hpButtonOver(this);}
divs[i].onmouseover= function()
{ourButtonManager.hpButtonOver(this);}
divs[i].onmouseout= function()
{ourButtonManager.hpButtonUp(this);}
if (button.onclick)
{ 
eval("divs[i].onclick= function(){var hardCodedFunction = "+button.onclick+" ;return hardCodedFunction();};");
button.onclick= function(event){};
}
var buttonChildren= divs[i].getElementsByTagName("BUTTON");
var inputChildren= divs[i].getElementsByTagName("INPUT");
for (var j=0;j<buttonChildren.length;j++)
{ 
buttonChildren[j].onfocus= function()
{ourButtonManager.hpButtonDown(this);}
buttonChildren[j].onblur= function()
{ourButtonManager.hpButtonUp(this);}
}
for (var j=0;j<inputChildren.length;j++)
{
inputChildren[j].onfocus= function()
{ourButtonManager.hpButtonDown(this);}
inputChildren[j].onblur= function()
{ourButtonManager.hpButtonUp(this);}
}
}
else
{
if (divs[i].className.indexOf("bEmphasized")!=-1)
{
divs[i].className= "bWrapperDisabled bEmphasized";
}
else
{
divs[i].className= "bWrapperDisabled";
}
}
}
}
}

function CStoragePresenter()
{
var m_hintPresenter= new CHintPresenter();
var m_BYTES_PER_BLOCK= 512;
var m_MKT_BYTES_PER_MB= 1000000;
var m_MKT_MB_PER_GB= 1000;
var m_BLOCKS_PER_KB= 2;
var m_BLOCKS_PER_MB= 2048;
var m_BLOCKS_PER_GB= 2097152;
var m_BLOCKS_PER_TB= 2147483648;
var m_MB_PER_TB= 1048576;
var m_MB_PER_GB= 1024;
var m_KB_PER_MB= 1024;
this.getDisplayName= function(attrName, attrValue)
{
var name= "";
if ((attrName== ATTR_NAME_UNIQUE_ID) && attrValue)
{
var d=g_model.getDevice(attrValue);
if (d)
{
name= this.LoadString(d.getAttribute(ATTR_NAME_TYPE));
}
}
else
{
name= this.LoadString(attrName);
if(g_model.deviceRoot().getAttribute(GUI_NAME_MOCKUP_DATA)==GUI_VALUE_TRUE)
{
name= name.replace("_", " ");
}
}
return name;
}
this.getDisplayValue= function(attrName, attrValue)
{
var value;
if ((attrName== ATTR_NAME_UNIQUE_ID) && attrValue)
{
var d=g_model.getDevice(attrValue);
if (d)
{
value= d.getAttribute(GUI_NAME_LABEL);
}
}
else if( (attrName== ATTR_NAME_BOX_NAME)||
(attrName== ATTR_NAME_SECTORS) ){ value = attrValue;}
else if( (attrName== ATTR_NAME_ARRAY_NUMBER)){ value = this.intToAlpha(attrValue);}
else if( (attrName== ATTR_NAME_DRIVE_NUMBER) || 
(attrName== ATTR_NAME_IO_SLOT) ||
(attrName== ATTR_NAME_SCSI_BUS) ||
(attrName== ATTR_NAME_BUS)){ value = this.increment(attrValue);}
else if( (attrName== ATTR_NAME_USEABLE_BLOCKS) ){ value = this.convertStr(attrValue, STR_BLOCKS, STR_MB);}
else if( (attrName== ATTR_NAME_FREE_BLOCKS)){ value = this.convertStr(attrValue, STR_BLOCKS, STR_MB);}
else if( (attrName== ATTR_NAME_TOTAL_BLOCKS)){ value = this.BlocksToMarketingPhysicalSizeStr(attrValue);}
else if( (attrName== ATTR_NAME_STRIPE_SIZE)){ value = this.convertStr(attrValue, STR_BLOCKS, STR_KB);}
else if( (attrName== ATTR_NAME_CACHE_SIZE_READ) ||
(attrName== ATTR_NAME_CACHE_SIZE_WRITE) ||
(attrName== ATTR_NAME_CACHE_SIZE_TOTAL) ||
(attrName== ATTR_NAME_CACHE_SIZE_TOTAL_BBBWC)){ value = this.convertStr(attrValue, STR_BLOCKS, STR_MB);}
else if( (attrName== ATTR_NAME_ERASE_PERCENT_COMPLETE) ||
(attrName== ATTR_NAME_EXPAND_PERCENT_COMPLETE)||
(attrName== ATTR_NAME_REBUILD_PERCENT_COMPLETE) ){ value = this.toPercent(attrValue, 0);}
else if( (attrName== ATTR_NAME_ROTATIONAL_SPEED) ){ value = attrValue/1000 + "K";}
else
{
value= this.LoadString(attrValue);
}
return value;
}
this.LoadString= function(id)
{
var str= id;
if (s_t[id] != null)
{
str= s_t[id];
}
return str;
}
this.LS= this.LoadString;
this.LoadParmString= function(id, p1, p2, p3, p4, p5)
{
var parm= new Array();
var message= this.LoadString(id);
if (typeof(p1) != "undefined"){parm[parm.length]=p1;};
if (typeof(p2) != "undefined"){parm[parm.length]=p2;};
if (typeof(p3) != "undefined"){parm[parm.length]=p3;};
if (typeof(p4) != "undefined"){parm[parm.length]=p4;};
if (typeof(p5) != "undefined"){parm[parm.length]=p5;};
for ( var i= 0; i < parm.length; ++i )
{
var expression= "<" + i + "[a-z_A-Z]*>";
var parmTag= new RegExp(expression, "g");
message= message.replace(parmTag, parm[i]);
}
return message;
}
this.LPS= this.LoadParmString;
this.getOperationDisplayName= function(opID, device)
{
var opDisplayName= this.LoadString(opID);
if (typeof(device) != "undefined")
{
var deviceType= device.getAttribute(ATTR_NAME_TYPE);
if( (deviceType== ATTR_VALUE_TYPE_ARRAY_CONTROLLER) && (opID == OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS) )
{
opDisplayName= this.LS(STR_LABEL_CONTROLLER_SETTINGS);
}
}
return opDisplayName;
}
this.convertToLabels= function(sUniqueIDList, sOutputDelimiter)
{
if(!sUniqueIDList) return ""; 
var idList= sUniqueIDList.split("&");
sOutputDelimiter= sOutputDelimiter ? sOutputDelimiter : "<BR>";
var lblList= "";
for (var i=0; i < idList.length; ++i)
{
var device= g_model.getDevice(idList[i]); 
if(device)
{
if(lblList=="") lblList+=device.getAttribute(GUI_NAME_LABEL_SHORT);
else lblList += sOutputDelimiter+device.getAttribute(GUI_NAME_LABEL_SHORT); 
}
}   
return lblList;
}
this.getOperationHelpHint= function(opID, device)
{
if (typeof(device) != "undefined")
{
var deviceType= device.getAttribute(ATTR_NAME_TYPE);
if( (deviceType== ATTR_VALUE_TYPE_ARRAY_CONTROLLER) && (opID == OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS) )
{
opID= STR_LABEL_CONTROLLER_SETTINGS;
}
}
var opHelpHint= m_hintPresenter.ShowHint(opID);
if (!opHelpHint)
{
opHelpHint= this.getOperationDisplayName(opID);
}
return opHelpHint;
}
this.convert= function(nValue, sFrom, sTo, nPrecision)
{
if(!nPrecision)
{ 
if(sTo==STR_GB) nPrecision= 3;
else if(sTo==STR_TB) nPrecision= 6;
else nPrecision= 0;
}     
sFrom= sFrom.replace(/^\s+/g, '').replace(/\s+$/g, '');
sTo= sTo.replace(/^\s+/g, '').replace(/\s+$/g, '');
var nCurrentVal= toBlocks(nValue, sFrom);
var nConvertedVal= fromBlocks(nCurrentVal, sTo);
var n= Math.pow(10, nPrecision);
nConvertedVal= Math.floor( nConvertedVal*n )/n;
return nConvertedVal;
}
this.convertStr= function(nValue, sFrom, sTo)
{ 
return this.convert(nValue, sFrom, sTo) + " " + g_sp.LS(sTo);
}  
function toBlocks(sValue, sUnits)
{
var sBlocks= sValue;
if ( sUnits== STR_KB ){ sBlocks = MBToBlocks( sValue/m_KB_PER_MB );}
else if( sUnits== STR_MB ){ sBlocks = MBToBlocks( sValue );}
else if( sUnits== STR_GB ){ sBlocks = MBToBlocks( sValue*m_MB_PER_GB );}
else if( sUnits== STR_TB ){ sBlocks = MBToBlocks( sValue*m_MB_PER_TB );}      
return sBlocks;
} 
function fromBlocks(sBlocks, sUnits)
{ 
var sSize= sBlocks;
if ( sUnits== STR_KB ){ sSize = sBlocks/m_BLOCKS_PER_KB;}
else if( sUnits== STR_MB ){ sSize = sBlocks/m_BLOCKS_PER_MB;}
else if( sUnits== STR_GB ){ sSize = sBlocks/m_BLOCKS_PER_GB;}
else if( sUnits== STR_TB ){ sSize = sBlocks/m_BLOCKS_PER_TB;}    
return sSize;
} 
function MBToBlocks(sizeMB)
{
return ((sizeMB * m_BLOCKS_PER_MB) + m_BLOCKS_PER_MB - 1);
}
this.BlocksToMarketingPhysicalSizeStr= function(sizeBlocks)
{
var size;
if ( (sizeBlocks== 644700) ||
(sizeBlocks== 636508)){ size = "330 " + this.LoadString(STR_MB);}
else if ( (sizeBlocks== 1091000) ||
(sizeBlocks== 1082808)){ size = "550 " + this.LoadString(STR_MB);}
else if ( (sizeBlocks== 2051000) ||
(sizeBlocks== 2042808)){ size = "1.05 " + this.LoadString(STR_GB);}
else if (sizeBlocks== 4110000){ size = "2.1 " + this.LoadString(STR_GB);}
else if ( (sizeBlocks== 8386000) ||
(sizeBlocks== 8380080) ||
(sizeBlocks== 8377808) ||
(sizeBlocks== 8371888) ){ size = "4.3 " + this.LoadString(STR_GB);}
else if ( (sizeBlocks== 17765332) ||
(sizeBlocks== 17765308)){ size = "9.1 " + this.LoadString(STR_GB);}
else
{
var totalMBs= (sizeBlocks * m_BYTES_PER_BLOCK)/m_MKT_BYTES_PER_MB;
var GBs= Math.floor((totalMBs) / m_MKT_MB_PER_GB);
var MBs= Math.floor(totalMBs % m_MKT_MB_PER_GB / 100);
size= GBs + "." + MBs + " " + this.LoadString(STR_GB);
if (isNaN(GBs) || isNaN(MBs))
{
size= "??? " + this.LoadString(STR_GB);
}
}
return size;
}
this.intToAlpha= function(value)
{
var alphaCode= parseInt(value) + 65; 
if (alphaCode > 90) 
{
alphaCode= alphaCode + 6;
}
return String.fromCharCode(alphaCode);
}
this.increment= function(value)
{
return parseInt(value) + 1;
}
this.toPercent=function(value, precision)
{
var floatValue= parseFloat(value);
if (!precision)
{
precision= 0;
}
var n= Math.pow(10, precision);
floatValue= Math.floor( floatValue*n )/n;
var percentString= "" + floatValue + "%";
return percentString;
}                  
} 

function CHintPresenter()
{
this.ShowHint= function(sOpName)
{
return o_h[sOpName];
}
var o_h= new Array();
o_h[STR_LABEL_CONTROLLER_SETTINGS]= s_t[STR_OP_HINT_WRITE_MANAGE_CONTROLLER_PARAMETERS];
o_h[STR_MORE_INFO]= s_t[STR_OP_HINT_MORE_INFO];
o_h[STR_VIEW_STATUS_MESSAGES]= s_t[STR_OP_HINT_VIEW_STATUS_MESSAGES];
o_h[GUI_OP_WRITE_REENABLE_LOGICAL_DRIVE]= s_t[STR_OP_HINT_GUI_OP_WRITE_REENABLE_LOGICAL_DRIVE];
o_h[GUI_OP_WRITE_ADD_LOGICAL_DRIVE]= s_t[STR_OP_HINT_GUI_OP_WRITE_ADD_LOGICAL_DRIVE];
o_h[GUI_OP_WRITE_MODIFY_LOGICAL_DRIVE]= s_t[STR_OP_HINT_GUI_OP_WRITE_MODIFY_LOGICAL_DRIVE];
o_h[GUI_OP_WRITE_DELETE_LOGICAL_DRIVE]= s_t[STR_OP_HINT_GUI_OP_WRITE_DELETE_LOGICAL_DRIVE];
o_h[GUI_OP_WRITE_MANAGE_SPARE_DRIVES]= s_t[STR_OP_HINT_GUI_OP_WRITE_MANAGE_SPARE_DRIVES];
o_h[GUI_LINK_ADD_CAPACITY_SETTINGS]= s_t[STR_OP_HINT_WRITE_EXPAND_ARRAY];
o_h[GUI_OP_SHRINK_ARRAY]= s_t[STR_OP_HINT_WRITE_SHRINK_ARRAY];
o_h[GUI_OP_MOVE_ARRAY]= s_t[STR_OP_HINT_WRITE_MOVE_ARRAY];
o_h[GUI_OPERATION_REDUNDANCY_SETTINGS]= s_t[STR_OP_HINT_GUI_OP_REDUNDANCY_SETTINGS]
o_h["OPERATION_WRITE_CLEAR_CONFIGURATION"]= s_t[STR_OP_HINT_WRITE_CLEAR_CONFIGURATION];
o_h["OPERATION_WRITE_CREATE_ARRAY"]= s_t[STR_OP_HINT_WRITE_CREATE_ARRAY];
o_h["OPERATION_WRITE_CREATE_LOGICAL_DRIVE"]= s_t[STR_OP_HINT_WRITE_CREATE_LOGICAL_DRIVE];
o_h["OPERATION_WRITE_DELETE_ARRAY"]= s_t[STR_OP_HINT_WRITE_DELETE_ARRAY];
o_h["OPERATION_WRITE_DELETE_LOGICAL_DRIVE"]= s_t[STR_OP_HINT_WRITE_DELETE_LOGICAL_DRIVE];
o_h["OPERATION_WRITE_DISABLE_OTHER_CONTROLLER"]= s_t[STR_OP_HINT_WRITE_DISABLE_OTHER_CONTROLLER];
o_h["OPERATION_WRITE_EXPAND_ARRAY"]= s_t[STR_OP_HINT_WRITE_EXPAND_ARRAY];
o_h["OPERATION_WRITE_EXTEND_LOGICAL_DRIVE"]= s_t[STR_OP_HINT_WRITE_EXTEND_LOGICAL_DRIVE];
o_h["OPERATION_WRITE_MANAGE_ARRAY_ACCELERATOR"]= s_t[STR_OP_HINT_WRITE_MANAGE_ARRAY_ACCELERATOR];
o_h["OPERATION_WRITE_MANAGE_BOX_NAME"]= s_t[STR_OP_HINT_WRITE_MANAGE_BOX_NAME];
o_h["OPERATION_WRITE_MANAGE_CONNECTION_NAME"]= s_t[STR_OP_HINT_WRITE_MANAGE_CONNECTION_NAME];
o_h["OPERATION_WRITE_MANAGE_CONTROLLER_PARAMETERS"]= s_t[STR_OP_HINT_WRITE_MANAGE_CONTROLLER_PARAMETERS];
o_h["OPERATION_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS"]= s_t[STR_OP_HINT_WRITE_MANAGE_ADVANCED_CONTROLLER_PARAMETERS];
o_h["OPERATION_WRITE_MANAGE_HOST_MODE"]= s_t[STR_OP_HINT_WRITE_MANAGE_HOST_MODE];
o_h["OPERATION_WRITE_MANAGE_SPARE_DRIVE"]= s_t[STR_OP_HINT_WRITE_MANAGE_SPARE_DRIVE];
o_h["OPERATION_WRITE_MANAGE_SSP_ACL"]= s_t[STR_OP_HINT_WRITE_MANAGE_SSP_ACL];
o_h["OPERATION_WRITE_MANAGE_SSP_STATE"]= s_t[STR_OP_HINT_WRITE_MANAGE_SSP_STATE];
o_h["OPERATION_WRITE_MIGRATE_LOGICAL_DRIVE"]= s_t[STR_OP_HINT_WRITE_MIGRATE_LOGICAL_DRIVE];
o_h["OPERATION_WRITE_REENABLE_LOGICAL_DRIVE"]= s_t[STR_OP_HINT_WRITE_REENABLE_LOGICAL_DRIVE];
o_h["OPERATION_WRITE_REENUMERATE"]= s_t[STR_OP_HINT_WRITE_REENUMERATE];
o_h["OPERATION_WRITE_REORDER_LOGICAL_DRIVE"]= s_t[STR_OP_HINT_WRITE_REORDER_LOGICAL_DRIVE];
o_h["OPERATION_WRITE_SET_ASYMMETRICAL_ACTIVE_ACTIVE_SUBMODE"]= s_t[STR_OP_HINT_WRITE_SET_ASYMMETRICAL_ACTIVE_ACTIVE_SUBMODE];
o_h["OPERATION_WRITE_SET_DRIVE_WRITE_CACHE"]= s_t[STR_OP_HINT_WRITE_SET_DRIVE_WRITE_CACHE]; 
o_h["GUI_OP_EXPRESS_CONFIGURATION"]= s_t[STR_OP_HINT_GUI_OP_EXPRESS_CONFIGURATION];
o_h["GUI_LINK_ADVANCED_WIZARDS"]= s_t[STR_OP_HINT_GUI_LINK_ADVANCED_WIZARDS];
o_h["GUI_LINK_PERFORMANCE_SETTING"]= s_t[STR_OP_HINT_GUI_LINK_PERFORMANCE_SETTING];
o_h["GUI_LINK_SSP_SETTINGS"]= s_t[STR_OP_HINT_GUI_LINK_SSP_SETTINGS];
o_h["GUI_LINK_REMOVE_SETTINGS"]= s_t[STR_OP_HINT_GUI_LINK_REMOVE_SETTINGS];
o_h["GUI_LINK_EXPRESS_CREATE_ARRAYS"]= s_t[STR_OP_HINT_GUI_LINK_EXPRESS_CREATE_ARRAYS];
o_h["GUI_LINK_EXPRESS_EXPAND_ARRAYS"]= s_t[STR_OP_HINT_GUI_LINK_EXPRESS_EXPAND_ARRAYS];
o_h["GUI_LINK_EXTEND_LOGICAL_DRIVE"]= s_t[STR_OP_HINT_WRITE_EXTEND_LOGICAL_DRIVE];
o_h["GUI_OP_WRITE_MANAGE_LICENSE_KEYS"]= s_t[STR_OP_HINT_WRITE_MANAGE_LICENSE_KEYS];
o_h["OPERATION_WRITE_ADD_LICENSE_KEY"]= s_t[STR_OP_HINT_WRITE_ADD_LICENSE_KEY];
o_h["OPERATION_WRITE_REMOVE_LICENSE_KEY"]= s_t[STR_OP_HINT_WRITE_REMOVE_LICENSE_KEY];
o_h["OPERATION_WRITE_ERASE_DRIVE"]= s_t[STR_OP_HINT_WRITE_ERASE_DRIVE];
o_h["OPERATION_WRITE_STOP_DRIVE_ERASE"]= s_t[STR_OP_HINT_WRITE_STOP_DRIVE_ERASE];
o_h["OPERATION_WRITE_ENABLE_ERASED_DRIVE"]= s_t[STR_OP_HINT_WRITE_ENABLE_ERASED_DRIVE];
o_h[GUI_OP_VIEW_DIAGNOSTIC_REPORT]= s_t[STR_OP_HINT_GUI_OP_VIEW_DIAGNOSTIC_REPORT];
o_h[GUI_OP_GENERATE_DIAGNOSTIC_REPORT]= s_t[STR_OP_HINT_GUI_OP_GENERATE_DIAGNOSTIC_REPORT];
o_h[GUI_OP_WRITE_MANAGE_HOST_CONTROLLER_ACCESS]= s_t[STR_OP_HINT_GUI_OP_WRITE_MANAGE_HOST_CONTROLLER_ACCESS];
o_h[GUI_OP_WRITE_MANAGE_HOST_CONTROLLER_ACCESS_LOGICAL_DRIVE]= s_t[STR_OP_HINT_GUI_OP_WRITE_MANAGE_HOST_CONTROLLER_ACCESS_LOGICAL_DRIVE];
o_h[GUI_OP_WRITE_ENABLE_SSP]= s_t[STR_OP_HINT_GUI_OP_WRITE_ENABLE_SSP];
o_h[GUI_OP_WRITE_DISABLE_SSP]= s_t[STR_OP_HINT_GUI_OP_WRITE_DISABLE_SSP];
o_h[OPERATION_WRITE_SPLIT_ARRAY]= s_t[STR_OP_HINT_WRITE_SPLIT_ARRAY];
o_h[OPERATION_WRITE_SHRINK_ARRAY]= s_t[STR_OP_HINT_WRITE_SHRINK_ARRAY];
o_h[OPERATION_WRITE_MOVE_ARRAY]= s_t[STR_OP_HINT_WRITE_MOVE_ARRAY];
o_h[OPERATION_WRITE_JOIN_ARRAY]= s_t[STR_OP_HINT_WRITE_JOIN_ARRAY];
o_h[OPERATION_WRITE_SET_BOOT_CONTROLLER]= s_t[STR_OP_HINT_WRITE_SET_BOOT_CONTROLLER];
o_h[GUI_OP_WRITE_SET_BOOT_VOLUME]= s_t[STR_OP_HINT_WRITE_SET_BOOT_VOLUME]; 
}


function filterIcon(iconFileName, iconHeight, iconWidth, iconClass, iconID, imgExtraAttributes){
if(iconClass=== undefined || iconClass == ''){
iconClass= "";
}else if(iconClass != ''){
iconClass= "class='"+iconClass+"'";
}
if (iconID=== undefined || iconID == ''){
iconID= "";
} else if (iconID != ''){
iconID= " id='" + iconID + "'";
}
if (imgExtraAttributes=== undefined || imgExtraAttributes == '')
{
imgExtraAttributes= "";
} else if (imgExtraAttributes != '')
{
imgExtraAttributes= " " + imgExtraAttributes;
}
var imgType= iconFileName.substr(iconFileName.length - 3, 3);
if (g_isMoz || imgType != "png") 
{
var iconHtml= "<img align='absmiddle' "+iconClass+iconID+" style='border:none;height:" + iconHeight + ";width:" + iconWidth + ";' src='"+iconFileName+"'"+imgExtraAttributes+"/>";
}
else
{
var iconHtml= "<!--[if lt IE 7]><img src='images/spacer9.gif' align='absmiddle' " + iconClass + iconID + " style=border:none;height:" + iconHeight + ";width:" + iconWidth + ";filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + iconFileName + "',sizingMethod='scale');" + imgExtraAttributes + " /><![endif]--><!--[if gte IE 7]><img align='absmiddle' " + iconClass + iconID + " style='border:none;' src='" + iconFileName + "'" + imgExtraAttributes + " /><![endif]-->";
}
return iconHtml;
}
function isEven(value)
{
if (value % 2== 0)
{
return true;
}
else
{
return false;
}
} 
function lcm( num1, num2 ) 
{
var w;
var x= num1;
var y= num2;
if ( num1== 0 || num2 == 0 )
{
return 0;
}
while (y != 0)
{
w= x % y;
x= y;
y= w;
}
return ((num1 * num2)/x);
}
function isHeaderAndFooter (opName)
{
return ((opName != OPERATION_WRITE_REENUMERATE) &&
(opName != OPERATION_WRITE_CLEAR_CONFIGURATION) &&
(opName != OPERATION_WRITE_SET_BOOT_CONTROLLER) &&
(opName != OPERATION_WRITE_DELETE_ARRAY) &&
(opName != OPERATION_WRITE_DELETE_LOGICAL_DRIVE) &&
(opName != OPERATION_WRITE_ENABLE_ERASED_DRIVE) &&
(opName != OPERATION_WRITE_DISABLE_OTHER_CONTROLLER) &&
(opName != OPERATION_WRITE_REENABLE_LOGICAL_DRIVE) &&
(opName != OPERATION_WRITE_STOP_DRIVE_ERASE) &&
(opName != GUI_OP_WIZARD_HOME) &&
(opName != OPERATION_WRITE_SPLIT_ARRAY));
}                             
function xShowHeader(sID)
{
if(sID)
{
var m_Element= document.getElementById(sID); 
var m_headerElement= document.getElementById(sID + "_HEADER");
var m_headerElement1= document.getElementById(sID + "_HEADER_1");
if (m_headerElement)
{
m_headerElement.style.display= "block";
}    
if (m_headerElement1)
{
m_headerElement1.style.display= "block";
}
if (m_Element)
{
m_Element.style.borderTopWidth= "0px";
}
CResizeCtrl.handleResize();
}
}
function xHideHeader (sID)
{
if(sID)
{
var m_Element= document.getElementById(sID); 
var m_headerElement= document.getElementById(sID + "_HEADER");
var m_headerElement1= document.getElementById(sID + "_HEADER_1");
if (m_headerElement)
{
m_headerElement.style.display= "none";
}   
if (m_headerElement1)
{
m_headerElement1.style.display= "none";
}
if (m_Element)
{
m_Element.style.borderTopWidth= "3px";
m_Element.style.borderTopColor= "#CCCCCC";
}
CResizeCtrl.handleResize();
}
}
function hideTaskFooter(sID)
{
if (sID)
{
var m_Element= document.getElementById(sID); 
var m_footerElement= document.getElementById(sID + "_FOOTER");
if(m_footerElement)
{
m_footerElement.style.display= "none";
}
CResizeCtrl.handleResize();
}
}
function showTaskFooter (sID)
{
if (sID)
{
var m_Element= document.getElementById(sID); 
var m_footerElement= document.getElementById(sID + "_FOOTER");
if(m_footerElement)
{
m_footerElement.style.display= "block";
}
CResizeCtrl.handleResize();
}
}
function DisplayMessage(sMsg, sID)
{
if(document.getElementById(sID))
{
document.getElementById(sID).innerHTML= "<DIV id=ProcessingAreaID class='LoadingArea'><SPAN ID=SavingMsg>" + sMsg + "</SPAN><BR/><IMG SRC='images/progress_bar_large.gif'/></DIV>";
}
}
function isSSPController(device)
{
return device.getAttribute(ATTR_NAME_TYPE) == ATTR_VALUE_TYPE_STORAGE_SYSTEM;
}
function getSelectedController(returnDevice)
{
if (typeof (g_dropDown) != "undefined")
{
var deviceID= g_dropDown.getCurrentSelectedValue();
if (typeof (returnDevice) != "undefined" && returnDevice)
{
var requestor= new CDeviceRequestor();
requestor.setAttribute(GUI_NAME_INCLUDE_OPERATIONS, GUI_VALUE_FALSE);
requestor.setAttribute(ATTR_NAME_UNIQUE_ID, deviceID);
requestor.setAttribute(GUI_NAME_REENUMERATE, GUI_VALUE_FALSE);
return requestor.executeRequest();
}
else
{
return deviceID;
}
}
else
{
return false;
}
}
function getSelectedTab()
{
return (new CUserPreferences()).GetValue("TAB_ID", "");
}
function getBootController()
{
var bootController= "";
var requestor= new CDeviceRequestor();
requestor.setAttribute(GUI_NAME_DEPTH, 1);
requestor.setAttribute(GUI_NAME_REENUMERATE, GUI_VALUE_FALSE);
requestor.setAttribute(GUI_NAME_INCLUDE_OPERATIONS, GUI_VALUE_FALSE);
var modroot= requestor.executeRequest();
var internalFinder= new DeviceFinder();
internalFinder.setAttribute(ATTR_NAME_TYPE, ATTR_VALUE_TYPE_ARRAY_CONTROLLER);
internalFinder.setAttribute(ATTR_NAME_LOCATION, ATTR_VALUE_LOCATION_LOCAL);
var children= internalFinder.findAll(modroot);
for (var i= 0; i < children.length && bootController == ""; ++i)
{
var isBoot= children[i].getAttribute(ATTR_NAME_IS_BOOT_CONTROLLER);
if (typeof (isBoot) != "undefined" && isBoot== ATTR_VALUE_IS_BOOT_CONTROLLER_TRUE)
{
bootController= children[i];
}
}
return bootController;
}
function msieversion()
{
var ua= window.navigator.userAgent;
var msie= ua.indexOf("MSIE ");
if (msie > 0) 
{
return parseInt(ua.substring(msie + 5, ua.indexOf(".", msie)));
}
else 
{
return 0;
}
}
function getTreeDeviceIcon(device)
{
var sIconHtml= '';
var sStateOverlay;
if (typeof (device) == "object")
{
var sIcon= device.getAttribute(GUI_NAME_ICON_SMALL);
var sOverlay= ""; 
var sStateOverlay= device.getAttribute("GUI_NAME_OVERLAY_ICON_SMALL");
var sTLOverlaySrc= device.getAttribute("GUI_NAME_OVERLAY_TL_ICON_SMALL");
var sStatusType= device.getAttribute("GUI_NAME_STATUS_TYPE");
var sStatusValue= device.getAttribute(ATTR_NAME_STATUS);
if (sStatusType != "GUI_VALUE_STATUS_TYPE_OK")
{
sOverlay= device.getAttribute("GUI_NAME_STATUS_ICON_SMALL");
}
sIconHtml= filterIcon(sIcon, '20px', '20px');
if (sStateOverlay)
{
sIconHtml += filterIcon(sStateOverlay, '12px', '12px', 'overlay');
if (sOverlay)
{
sIconHtml += filterIcon(sOverlay, '12px', '12px', 'overlayLeft');
}
}
else if (sOverlay)
{
sIconHtml += filterIcon(sOverlay, '12px', '12px', 'overlay');
}
if (sTLOverlaySrc)
{
sIconHtml += filterIcon(sTLOverlaySrc, '12px', '12px', 'overlayTL');
}
}
else if(device != '')
{
sIconHtml= filterIcon(device, '20px', '20px');
}
return '<span style="margin-right:6px;">' + sIconHtml + '</span>';
}
function drawNote(sNote)
{
return "<TABLE style=\"margin-left:5px;\"><TR><TD valign=\"top\">" + filterIcon("images/infostat20.png", 20, 20) + "</TD><TD class=\"InfoNote\">" + g_sp.LS(STR_NOTE) + g_sp.LS(sNote) + "</TD></TR></TABLE>";
}
function isInTask()
{
var session= new CSessionData();
return (session.GetData("task_state", "task_in_progress")) || (session.GetData("wizard_state", "wizard_in_progress"));
}
function ldPred(lhs, rhs)
{
return parseInt(lhs.getAttribute(ATTR_NAME_DRIVE_NUMBER)) - parseInt(rhs.getAttribute(ATTR_NAME_DRIVE_NUMBER));
}
function GE(eid)
{
return document.getElementById(eid);
}

var KEY_ENTER= 13;
var KEY_ESCAPE= 27;
var KEY_ARROWUP= 38;
var KEY_ARROWDOWN= 40;
function CHelpSuggest(sID)
{
this.m_isBlank;
this.m_highlighted;
this.m_input= this.getElement(sID);
this.m_sIDSuggestionsDIV= "suggestionsDIV";
this.m_sIDSuggestionsUL= "suggestionsUL";
this.m_suggestions;
var m_self= this;
this.m_input.onfocus= function(e)
{
return m_self.onfocus(e);
}
this.m_input.onblur= function(e)
{
return m_self.onblur(e);
}
this.m_input.onkeypress= function(e)
{
return m_self.onkeypress(e);
}
this.m_input.onkeyup= function(e)
{
return m_self.onkeyup(e);
}
this.m_input.setAttribute("autocomplete", "off");
this.reset= function()
{
this.m_input.value= g_sp.LS(HELP_SEARCH);
this.m_input.className= "idleSearchInput";
this.m_isBlank= true;
this.removeSuggestions();
}
this.reset();
}
CHelpSuggest.prototype.onfocus= function(e)
{
if (this.m_isBlank)
{
this.m_input.value= "";
this.m_input.className= "activeSearchInput";
}
else
{
this.getSuggestions(this.m_input.value);
}
}
CHelpSuggest.prototype.onblur= function(e)
{
if (typeof (this.m_input.value) == "undefined" || 
this.m_input.value== "")
{
this.reset();
}
else
{
this.m_isBlank= false;
}
}
CHelpSuggest.prototype.onkeypress= function(e)
{
var key= (window.event) ? window.event.keyCode : e.keyCode;
switch (key)
{
case KEY_ESCAPE:
{
this.removeSuggestions();
this.m_input.blur();
}
case KEY_ENTER:
{
this.selectSuggestion();
}
}
}
CHelpSuggest.prototype.onkeyup= function(e)
{
var key= (window.event) ? window.event.keyCode : e.keyCode;
switch (key)
{
case KEY_ARROWUP:
{
this.updateHighlight(key);
break;
}
case KEY_ARROWDOWN:
{
this.updateHighlight(key);
break;
}
case KEY_ESCAPE:
{
break;
}
default:
{
this.getSuggestions(this.m_input.value);
}
}
}
CHelpSuggest.prototype.updateHighlight= function(key)
{
var ulSuggestions= this.getElement(this.m_sIDSuggestionsUL);
if (ulSuggestions)
{
var index;
if (key== KEY_ARROWUP)
{
index= this.m_highlighted - 1;
}
else if (key== KEY_ARROWDOWN)
{
index= this.m_highlighted + 1;
}
if (index > ulSuggestions.childNodes.length)
{
index= ulSuggestions.childNodes.length;
}
if (index < 1)
{
index= 1;
}
this.highlightSuggestion(index);
}
else
{
return false;
}
}
CHelpSuggest.prototype.selectSuggestion= function()
{
if (this.m_highlighted)
{
var sug= this.m_suggestions[this.m_highlighted - 1];
this.removeSuggestions();
this.m_input.value= "";
this.m_input.blur();
loadHelpContent(sug.link, sug.isDefinition, true);
}
}
CHelpSuggest.prototype.highlightSuggestion= function(index)
{
var ulSuggestions= this.getElement(this.m_sIDSuggestionsUL);
if (ulSuggestions)
{
if (this.m_highlighted > 0)
{
this.removeHighlight();
}
this.m_highlighted= Number(index);
ulSuggestions.childNodes[this.m_highlighted - 1].className= 
"highlightedSuggestion";
}
else
{
return false;
}
}
CHelpSuggest.prototype.removeHighlight= function()
{
var ulSuggestions= this.getElement(this.m_sIDSuggestionsUL);
if (ulSuggestions)
{
if (this.m_highlighted > 0)
{
ulSuggestions.childNodes[this.m_highlighted - 1].className= "";
this.m_highlighted= 0;
}
}
else
{
return false;
}
}
CHelpSuggest.prototype.getSuggestions= function(searchVal)
{
this.removeSuggestions();
if (this.m_input.value.length > 0)
{
var sValLower= searchVal.toLowerCase();
var searchLength= sValLower.length;
for (var index= 0; index < g_inlineLinks.length; ++index)
{
var sLinkTextLower= g_inlineLinks[index].getLinkText().toLowerCase();
var result= sLinkTextLower.indexOf(sValLower);
if (result != -1)
{
var sVal= g_inlineLinks[index].getLinkText();
var emEndIndex= result + searchLength;
var newIndex= this.m_suggestions.length;
this.m_suggestions[newIndex]= new Object();
this.m_suggestions[newIndex].isDefinition=
g_inlineLinks[index].getIsDefinition() ? '1' : '0';
this.m_suggestions[newIndex].link= 
g_inlineLinks[index].getLinkName();
this.m_suggestions[newIndex].value=
sVal.substring(0, result) +
"<em>" +
sVal.substring(result, emEndIndex) +
"</em>" +
sVal.substring(emEndIndex);
}
}
this.showSuggestions();
}
}
CHelpSuggest.prototype.showSuggestions= function()
{
var divSuggestions= this.createElement("div",
{ id: this.m_sIDSuggestionsDIV });
var ulSuggestions= this.createElement("ul",
{ id: this.m_sIDSuggestionsUL });
if (this.m_suggestions.length > 0)
{
if (this.m_suggestions.length > 10)
{
divSuggestions.className= "suggestionsOverflow";
}
var self= this;
for (var i= 0; i < this.m_suggestions.length; ++i)
{
var spanSuggestion= this.createElement("span");
spanSuggestion.innerHTML= this.m_suggestions[i].value;
if (this.m_suggestions[i].isDefinition== '1')
{
this.m_suggestions[i].info= HELP_GLOSSARY;
}
else
{
this.m_suggestions[i].info= 
help[this.m_suggestions[i].link].getParent();
}
if (this.m_suggestions[i].info != "")
{
var infoSuggestion= this.createElement("info");
infoSuggestion.innerHTML= g_sp.LS(this.m_suggestions[i].info);
spanSuggestion.appendChild(infoSuggestion);
}
var aSuggestion= this.createElement("a", { href: "#" });
aSuggestion.name= i + 1;
aSuggestion.onmousedown= function()
{
self.selectSuggestion();
return false;
}
aSuggestion.onmouseover= function()
{
self.highlightSuggestion(this.name);
}
aSuggestion.appendChild(spanSuggestion);
var liSuggestion= this.createElement("li");
liSuggestion.appendChild(aSuggestion);
ulSuggestions.appendChild(liSuggestion);
}
}
else
{
var liSuggestion= this.createElement("li",
{ className: "warningSuggestion" });
var spanSuggestion= this.createElement("span");
spanSuggestion.innerHTML= g_sp.LS(HELP_NO_RESULTS_FOUND);
liSuggestion.appendChild(spanSuggestion);
ulSuggestions.appendChild(liSuggestion);
}
divSuggestions.appendChild(ulSuggestions);
var fieldPos= this.getPosition(this.m_input);
divSuggestions.style.left= fieldPos.x + "px";
divSuggestions.style.top= (fieldPos.y + this.m_input.offsetHeight) + "px";
divSuggestions.style.width= this.m_input.offsetWidth + "px";
document.getElementsByTagName("body")[0].appendChild(divSuggestions);
}
CHelpSuggest.prototype.removeSuggestions= function()
{
this.removeElement(this.m_sIDSuggestionsDIV);
this.m_highlighted= 0;
delete this.m_suggestions;
this.m_suggestions= new Array();
}
CHelpSuggest.prototype.getElement= function(sID)
{
var oElement= document.getElementById(sID);
return oElement ? oElement : false;
}
CHelpSuggest.prototype.createElement= function(elemType, elemAttributes)
{
var oElement= document.createElement(elemType);
if (oElement)
{
for (var attr in elemAttributes)
{
oElement[attr]= elemAttributes[attr];
}
return oElement;
}
else
{
return false;
}
}
CHelpSuggest.prototype.removeElement= function(sID)
{
var oElement= this.getElement(sID);
return oElement && oElement.parentNode.removeChild(oElement);
}
CHelpSuggest.prototype.getPosition= function(oElement)
{
var oElem= oElement;
var leftPos= 0;
var topPos= 0;
if (oElem.offsetParent)
{
while (oElem.offsetParent)
{
leftPos += oElem.offsetLeft;
topPos += oElem.offsetTop;
oElem= oElem.offsetParent;
}
}
else
{
if (oElem.x)
{
leftPos += oElem.x;
}
if (oElem.y)
{
topPos += oElem.y;
}
}
return { x: leftPos, y: topPos };
}
