#!/bin/sh
INSTALL_ROOT=/opt/compaq/cpqacuxe/
BIN_DIR=/opt/compaq/cpqacuxe/bld/
HPSMH_DIR=/opt/hp/hpsmh

#
# see if hpsmh is installed and running
HPSMH_INSTALL=`rpm -q hpsmh`
if [ $? == 0 ] && [ -f "/opt/hp/hpsmh/logs/httpd.pid" ]
then
	# Permissions
	chown -R hpsmh:root $INSTALL_ROOT
	chown hpsmh:hpsmh $INSTALL_ROOT `find $INSTALL_ROOT/ -type l`
	chown root:hpsmh $BIN_DIR/getusb.sh
	chmod -R 700 $BIN_DIR
	chown root:hpsmh $BIN_DIR/ipcelmclient
	chmod 6710 $BIN_DIR/ipcelmclient
	chmod 400 $BIN_DIR/ACU-XE.xml $BIN_DIR/ipcelmclient.php

	chown hpsmh:hpsmh $INSTALL_ROOT/HTML
	chmod 710 $INSTALL_ROOT/HTML
	chmod 500 `find $INSTALL_ROOT/HTML/ -type d` > /dev/null 2>&1
	chmod 400 `find $INSTALL_ROOT/HTML/ -type f` > /dev/null 2>&1

	# Cleansweep XML file
	mkdir -p $HPSMH_DIR/webapp
	rm -f $HPSMH_DIR/webapp/ACU-XE.xml.inactive
	ln -sf $BIN_DIR/ACU-XE.xml $HPSMH_DIR/webapp/ACU-XE.xml.inactive
	chown hpsmh:hpsmh $HPSMH_DIR/webapp/ACU-XE.xml.inactive
	# Cleansweep HTML folder
	rm -f $HPSMH_DIR/data/htdocs/ACU-XE
	mkdir -p $HPSMH_DIR/data/htdocs
	ln -sf $INSTALL_ROOT/HTML $HPSMH_DIR/data/htdocs/ACU-XE
	chown hpsmh:hpsmh $HPSMH_DIR/data/htdocs/ACU-XE
fi
