<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
  <!-- the main template/body of document -->
  <xsl:template match="ADUReport">
    <script language="javascript">
      <![CDATA[
      ResetADUReportSections();
   ]]>
    </script>
    <!-- create the ADU Info table at the top of the report. -->
    <table id="ADUReportTop" border="0" cellspacing="0" cellpadding="0" width="100%" class="dataTable">
      <caption>
        <xsl:text>Diagnostic Report Information</xsl:text>
      </caption>
      <xsl:for-each select="MetaProperty">
        <tr>
          <td width="20%">
            <xsl:value-of select="@id"/>
          </td>
          <td width="80%">
            <xsl:value-of select="@value"/>
          </td>
        </tr>
      </xsl:for-each>
      <tr>
        <td colspan="2" height="15px;"></td>
      </tr>
      <xsl:if test="count(child::Device) &gt; 0">
        <tr class="captionRow">
          <th colspan="2">
            Top-Level Controller(s)
          </th>
        </tr>
        <xsl:for-each select="Device">
          <tr>
            <td colspan="2">
              <a style="cursor:hand;cursor:pointer;" onclick="ScrollToADUReportDevice('{@id}');">
                <xsl:value-of select="@marketingName"/>
              </a>
            </td>
          </tr>
        </xsl:for-each>
        <xsl:if test="count(Device/Errors/Message) &gt; 0">
          <tr class="captionRow">
            <th colspan="2">
              Consolidated Error Report
            </th>
          </tr>
          <xsl:for-each select="./Device/Errors/Message">
            <xsl:variable name="controllerId" select="../../@id" />
            <xsl:variable name="controllerName" select="../../@marketingName" />
            <tr>
              <td nowrap="1">
                <xsl:if test="@marketingName != $controllerName">
                  <a style="cursor:hand;cursor:pointer;" title="Click to scroll to this device">
                    <xsl:attribute name="onclick">
                      ScrollToADUReportDevice('<xsl:value-of select="$controllerId"/>');
                    </xsl:attribute>
                    <xsl:value-of select="$controllerName"/>
                  </a> :
                </xsl:if>
                <a style="cursor:hand;cursor:pointer;" title="Click to scroll to this device">
                  <xsl:attribute name="onclick">
                    ScrollToADUReportDevice('<xsl:value-of select="@id"/>');
                  </xsl:attribute>
                  <xsl:value-of select="@marketingName"/>
                </a>
              </td>
              <td>
                <xsl:value-of select="@message"/>
              </td>
            </tr>
          </xsl:for-each>
        </xsl:if>
      </xsl:if>
    </table>

    <!-- Begin with all top-level devices -->
    <xsl:choose>
      <xsl:when test="count(child::Device) &gt; 0">
        <xsl:apply-templates select="Device"/>
      </xsl:when>
      <xsl:otherwise>
        <table id="{@id}" border="0" cellspacing="0" cellpadding="0" width="100%" class="dataTable">
          <tr>
            <td>No supported controllers were detected</td>
          </tr>
        </table>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="ChildDeviceLinks">
    <xsl:param name="currentDevice"/>
    <a style="cursor:hand;cursor:pointer;">
      <xsl:attribute name="onclick">
        ScrollToADUReportDevice('<xsl:value-of select="$currentDevice/@id"/>');
      </xsl:attribute>
      <xsl:value-of select="$currentDevice/@marketingName"/>
    </a>
    <xsl:if test="count($currentDevice/child::Device) &gt; 0">
      <table style="margin-left:60px;border-collapse:collapse;">
        <xsl:for-each select="$currentDevice/Device">
          <tr>
            <td style="border:none;padding:0px;">
              <xsl:call-template name="ChildDeviceLinks">
                <xsl:with-param name="currentDevice" select="."/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:for-each>
      </table>
    </xsl:if>
  </xsl:template>

  <!-- Returns the path to a given device -->
  <xsl:template name="DevicePath">
    <xsl:param name="currentDevice"/>
    <xsl:choose>
      <xsl:when test="count($currentDevice/ancestor::Device)>0">
        <xsl:call-template name="DevicePath">
          <xsl:with-param name="currentDevice" select="$currentDevice/parent::*"/>
        </xsl:call-template>
        &#160;&#8594;&#160;
        <a style="cursor:hand;cursor:pointer;" title="Click to scroll to this device">
          <xsl:attribute name="onclick">
            ScrollToADUReportDevice('<xsl:value-of select="$currentDevice/@id"/>');
          </xsl:attribute>
          [ <xsl:value-of select="$currentDevice/@marketingName"/> ]
        </a>
        <!--<xsl:value-of select="concat($devicePath, '&#160;&#8594;&#160;', $currentDevice/@marketingName)"/> -->
      </xsl:when>
      <xsl:otherwise>
        <a style="cursor:hand;cursor:pointer;" title="Scroll to the top of the report">
          <xsl:attribute name="onclick">ScrollToADUReportTop();</xsl:attribute>[ Top ]
        </a>&#160;&#8594;&#160;
        <a style="cursor:hand;cursor:pointer;" title="Click to scroll to this device">
          <xsl:attribute name="onclick">
            ScrollToADUReportDevice('<xsl:value-of select="$currentDevice/@id"/>');
          </xsl:attribute>
          [ <xsl:value-of select="$currentDevice/@marketingName"/> ]
        </a>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- get all structures within top-level device tags -->
  <xsl:template match="MetaStructure[not(self::node()[@id='MNPParameterControl'])]">
    <tr class="captionRow" id="{@id}">
      <th colspan="3">
        <!-- Concatenate nested Device tags within the Caption Row. Display ourself, and then recursively display all parent devices. -->
        <xsl:if test="count(ancestor::Device)>0">
          <xsl:call-template name="DevicePath">
            <xsl:with-param name="currentDevice" select="parent::Device"/>
          </xsl:call-template>
        </xsl:if>&#160;&#8594;&#160;<xsl:value-of select="@id"/>
      </th>
    </tr>

    <!-- This block sets a param with custom property tags (to be filtered on) for some structures -->
    <!--
    <xsl:choose>
       <xsl:when test="@id='IdentifyController'">
          <xsl:call-template name="PropertyFilter">
          <xsl:with-param name="filter_string" select="'ConfiguredLogicalDrivesCfgSignatureROMFirmwareRevisionHardwareRevisionBoardIDSCSIChipCountHostI2CAutorevROMInactiveRevisionPercentWriteCacheDaughterboardSizeInMBCacheBatteryCountTotalAvailableMemorySizeMaximumPhysicalDevicesSupportedMaximumPhysicalDrivesPerLogicalUnit'"/>
          </xsl:call-template>
       </xsl:when>
       <xsl:when test="@id='RedundantControllerParameters'">
          <xsl:call-template name="PropertyFilter">
          <xsl:with-param name="filter_string" select="'CurrentModeControllerStatusFailureReasonCurrentControllerIDLinkedControllerIDCommonControllerIDCurrentControllerTypeLinkedControllerTypeControllerOrder'"/>
          </xsl:call-template>
       </xsl:when>
       <xsl:when test="@id='CacheConfigStatus'">
          <xsl:call-template name="PropertyFilter">
          <xsl:with-param name="filter_string" select="'ReadCacheSizeWriteCacheSizeTotalMemorySizeParityReadErrorsParityWriteErrorsNonBatteryBackedMemorySizeCacheAutoRevTotalAvailableMemorySizePercentReadCachePercentWriteCacheDefaultPercentReadCacheDefaultPercentWriteCache'"/>
          </xsl:call-template>
       </xsl:when>
       <xsl:when test="@id='ControllerParameters'">
          <xsl:call-template name="PropertyFilter">
          <xsl:with-param name="filter_string" select="'RebuildPriorityExpandPrioritySoftwareNameHardwareNameOverTempWarningOverTempShutdownOverTempConditionCancelledAccessID'"/>
          </xsl:call-template>
       </xsl:when>
       <xsl:when test="@id='SurfaceStatus'">
          <xsl:call-template name="PropertyFilter">
          <xsl:with-param name="filter_string" select="'CurrentDriveTimerRemainingSurfaceDelaySurfaceAnalysisStatusSurfaceAnalysisPassTimeSurfaceAnalysisPassesControllerResetsBlocksReassignedCurrentVolumeInitializationPercentageCompleteExtendedSurfaceAnalysisPassTimeExtendedSurfaceAnalysisPassCountExtendedControllerResets'"/>
          </xsl:call-template>
       </xsl:when>
       <xsl:when test="@id='SubSystemParameters'">
          <xsl:call-template name="PropertyFilter">
          <xsl:with-param name="filter_string" select="'ControllerSlotNumberChassisSerialNumberControllerSerialNumberSCSIDriveBackplaneSerialNumberNodeName'"/>
          </xsl:call-template>
       </xsl:when>
       <xsl:when test="@id='SenseBusParameters'">
          <xsl:call-template name="PropertyFilter">
          <xsl:with-param name="filter_string" select="'PeripheralTypeProductIDProductRevisionHotPlugCountPhysicalBoxSCSIDeviceRevisionSCSIDeviceTypeUltraBusFaultsPhysicalPortBayCountExpanderCountChassisSerialNumberFastBusFaultsUltra2BusFaultsUltra3BusFaultsUltra320BusFaults'"/>
          </xsl:call-template>
       </xsl:when>
       <xsl:when test="@id='PhysicalDriveStatus'">
          <xsl:call-template name="PropertyFilter">
          <xsl:with-param name="filter_string" select="'SCSIBusSCSIIDBlockSizeTotalBlocksDriveModelDriveSerialNumberDriveFirmwareRevisionCompaqDriveStampedLastFailureReasonPhysicalPortPhysicalBoxPhysicalBayRPMDeviceTypeSATAVersionBigTotalBlockCountRISSizeWWID'"/>
          </xsl:call-template>
       </xsl:when>
       
       <xsl:when test="@id='SenseMNPStatistics'">
          <xsl:call-template name="PropertyFilter">
          <xsl:with-param name="filter_string" select="'SerialNumberFirmwareRevisionProductRevisionReferenceTimeSectorsReadReadErrorsHardReadErrorsRetryRecoveredReadErrorsECCCorrectedSectorsWrittenWriteErrorsHardWriteErrorsRetryRecoveredReallocatedSectorsOtherTimeoutsDriveRebuildCountRecoversFailedReadRecoversFailedWriteFormatErrorsNotReadyFailuresBusFaultsHotPlugCountMediaFailuresHardwareErrorsPredictiveFailureErrors'"/>
          </xsl:call-template>
       </xsl:when>
       
       <xsl:otherwise>
         <xsl:for-each select="./MetaProperty">
            <xsl:call-template name="MetaProperty"/>
         </xsl:for-each>
       </xsl:otherwise>
    </xsl:choose>
      -->
    <xsl:for-each select="child::*">
      <xsl:apply-templates select=".">
        <xsl:with-param name="pos" select="position()"/>
      </xsl:apply-templates>
    </xsl:for-each>
  </xsl:template>

  <!-- generic block to filter device data -->
  <xsl:template name="PropertyFilter">
    <xsl:param name="filter_string">none</xsl:param>
    <xsl:for-each select="MetaProperty[contains($filter_string,@id)]">
      <xsl:call-template name="MetaProperty"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="Device">
    <br/>
    <table id="{@id}" border="0" cellspacing="0" cellpadding="0" width="100%" class="dataTable">
      <caption>
        <xsl:if test="count(ancestor::Device) &gt; 0">
          <xsl:call-template name="DevicePath">
            <xsl:with-param name="currentDevice" select=".."/>
          </xsl:call-template>&#160;&#8594;&#160;
          <xsl:value-of select="@marketingName"/>
        </xsl:if>
        <xsl:if test="count(ancestor::Device) = 0">
          <a style="cursor:hand;cursor:pointer;" title="Scroll to the top of the report">
            <xsl:attribute name="onclick">ScrollToADUReportTop();</xsl:attribute>[ Top ]
          </a>&#160;&#8594;&#160;
          <xsl:value-of select="@marketingName"/>
        </xsl:if>
      </caption>
      <tr>
        <td nowrap="1" width="20%" align="right">Report Section(s):</td>
        <td colspan="2">
          <xsl:if test="count(./MetaStructure) &gt; 0">
            <xsl:for-each select="MetaStructure">
              <xsl:if test="position() &gt; 1">
                <br/>
              </xsl:if>
              <a style="cursor:hand;cursor:pointer;" onclick="ScrollToADUReportDeviceSection('{../@id}','{@id}');">
                <xsl:value-of select="@id"/>
              </a>
            </xsl:for-each>
          </xsl:if>
          <xsl:if test="count(./MetaStructure) = 0">
            <a style="cursor:hand;cursor:pointer;">
              None<br/>
            </a>
          </xsl:if>
        </td>
      </tr>
      <!-- See if there are any child device(s) -->
      <xsl:if test="count(./Device) &gt; 0">
        <xsl:variable name="numChildren" select="count(./Device)"/>
        <xsl:for-each select="Device">
          <tr>
            <xsl:if test="position() = 1">
              <td nowrap="1" align="right" valign="top">
                <xsl:attribute name="rowspan">
                  <xsl:value-of select="$numChildren"/>
                </xsl:attribute>Attached Device(s):
              </td>
            </xsl:if>
            <td colspan="2">
              <xsl:call-template name="ChildDeviceLinks">
                <xsl:with-param name="currentDevice" select="."/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:for-each>
      </xsl:if>
      <xsl:apply-templates select="./Errors"/>
      <xsl:apply-templates select="./MetaStructure"/>
    </table>
    <xsl:if test="count(./Device) &gt; 0">
      <xsl:apply-templates select="Device"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="Errors">
    <xsl:if test="count(./Message) &gt; 0">
      <tr class="captionRow">
        <th colspan="3">
          <xsl:call-template name="DevicePath">
            <xsl:with-param name="currentDevice" select="parent::Device"/>
          </xsl:call-template>&#160;&#8594;&#160;Device Error Report
        </th>
      </tr>
      <tr>
        <th>Device</th>
        <th align="left">Status</th>
      </tr>
      <xsl:for-each select="./Message">
        <tr>
          <td nowrap="1">
            <a style="cursor:hand;cursor:pointer;" title="Click to scroll to this device">
              <xsl:attribute name="onclick">
                ScrollToADUReportDevice('<xsl:value-of select="@id"/>');
              </xsl:attribute>
              <xsl:value-of select="@marketingName"/>
            </a>
          </td>
          <td>
            <xsl:value-of select="@message"/>
          </td>
        </tr>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>

  <!-- get Property tags within structures -->
  <xsl:template name="MetaProperty" match="MetaProperty">
    <xsl:param name="pos"/>
    <tr>
      <xsl:if test="$pos mod 2 =0">
        <xsl:attribute name="class">altRowColor</xsl:attribute>
      </xsl:if>
      <td width="20%">
        <xsl:value-of select="@id"/>
      </td>
      <td width="80%" colspan="2">
        <xsl:if test="@value=''">
          <xsl:text>empty</xsl:text>
        </xsl:if>
        <xsl:choose>
          <xsl:when test="@metaValue">
            <xsl:value-of select="@metaValue"/>&#160;<SPAN STYLE="color:#555555;">
              (<xsl:value-of select="@value"/>)
            </SPAN>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="@value"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
  </xsl:template>

  <!-- Embedded tables -->
  <xsl:template match="MetaPropertyStructure">
    <xsl:param name="pos"/>
    <xsl:if test="count(./MetaStructure) &gt; 0">
      <tr>
        <xsl:if test="$pos mod 2 =0">
          <xsl:attribute name="class">altRowColor</xsl:attribute>
        </xsl:if>
        <td>
          <xsl:value-of select="@id"/>
        </td>
        <td colspan="2">
          <xsl:value-of select="@value"/>
          <table cellspacing="0" cellpadding="3" class="nestedTable">
            <xsl:for-each select="MetaStructure">
              <xsl:if test="position() = 1">
                <tr class="captionRow">
                  <xsl:for-each select="child::*">
                    <th>
                      <xsl:value-of select="@id"/>
                    </th>
                  </xsl:for-each>
                </tr>
              </xsl:if>
              <tr>
                <xsl:for-each select="MetaProperty">
                  <td>
                    <xsl:choose>
                      <xsl:when test="@metaValue">
                        <xsl:value-of select="@metaValue"/>&#160;<SPAN STYLE="color:#555555;">
                          (<xsl:value-of select="@value"/>)
                        </SPAN>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:if test="@value=''">
                          <xsl:text>empty</xsl:text>
                        </xsl:if>
                        <xsl:value-of select="@value"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </xsl:for-each>
              </tr>
            </xsl:for-each>
          </table>
        </td>
      </tr>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
