#!/bin/sh

#########################################################################
# This scripts finds a USB device and mounts it to /mnt/floppy. To do this
# it finds the files under /proc/scsi/usb-storage. Each file name
# corresponds to it's Host Scsi ID (i.e. file '3' is scsi3). Then the
# /proc/scsi/scsi file is searched to find the index in which the 
# host scsi ID appears in that file.
# Once the disk index (n) in the /proc/scsi/scsi file is found, we search  
# for the nth scsi disc device in the /proc/partitions table
#
# Note 1: There is a sequential cross reference to the "Host:" entries 
# and SCSI disk ("sd") devices in the /proc/partitions file
# Processor and CD-ROM entries are ignored since they don't have a 
# corresponding "sd" device
#
# Note 2: USB floppy drives must be mounted as the entire drive (i.e. /dev/sda)
# while USB drive keys and iLO virtual devices are mounted as partition 
# one (i.e. /dev/sda1)
#########################################################################

if [ -z "$PHOENIX_ACUXE_EXIT_MARKER_FILE" ]
then
	exit 96
fi

SCSI_USB_DIR="/proc/scsi/usb-storage"
PROC_SCSI_FILE="/proc/scsi/scsi"
PROC_PARTITIONS_FILE="/proc/partitions"
if [ ! -f "$PROC_SCSI_FILE" ]
then
	echo "ERROR: No $PROC_SCSI_FILE found"
	exit 99
fi

USB_DEV=`ls -1 $SCSI_USB_DIR`

if [ -z "$USB_DEV" ]
then
	echo "ERROR: No USB devices found"
	exit 98
fi

RET_STAT=97
for i in $USB_DEV
do
	ID=scsi$i
	DISK_INDEX=`cat $PROC_SCSI_FILE | \
	awk 'BEGIN { hcnt=0 ;
		} 
	{
		if($1 == "Host:") {
			HOST=$2;
			hcnt++;
			if(hcnt > 26) { exit; }

			#print "hcnt:" hcnt $0;
			getline;
			VENDOR=$0;
			getline;
			TYPE=$0;

			if(index(TYPE,"Processor")!=0) { hcnt--;next; }
			if(index(TYPE,"CD-ROM")!=0) { hcnt--;next; }
			if(index(TYPE,"RAID")!=0) { hcnt--;next; }

			if(HOST != "'$ID'") { next; }

			print hcnt;
			exit;
		}
	}'`
	
   # If DISK_INDEX is not empty
	if [ ! -z "$DISK_INDEX" ]; then
	   # Before reading the /proc/partitions file, refresh the kernel's partition table
	   for DISK in `ls -1 /dev/sd?`; do
	      /sbin/blockdev --rereadpt $DISK 2> /dev/null
	   done
      # Wait for refreshing to complete so that devices can be found
	   sleep 1
	   # Get a list of disk devices from the /proc/partitions special file
	   # and get the DISK_INDEXth device
	   DEVROOT=`cut -c 23-26 $PROC_PARTITIONS_FILE | grep -e sd[a-z] | grep -v sd[a-z][1-9] | head -$DISK_INDEX | tail -1`
	   # echo $DEVROOT
      # Check to see if this disk contains a partition
	   DISKPART=`grep -c ${DEVROOT}1 $PROC_PARTITIONS_FILE`
	   if [ $DISKPART = 1 ]; then
	      DEV="/dev/${DEVROOT}1"
	   else
	      DEV="/dev/${DEVROOT}"
	   fi
	   # echo "DEV = $DEV"
	   echo "mount $DEV /mnt/floppy"
	   umount /mnt/floppy > /dev/null 2>&1
	   mount -o sync $DEV /mnt/floppy
	   RET_STAT=$?
	   if [ "$RET_STAT" = "0" ]
	   then
	      exit 0
	   fi
	fi
done

exit $RET_STAT

