<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<!-- for browser or command line xml transformer use. updated 27 oct 2004. -->

<xsl:output method="html"/>

<xsl:template match="diagOutput">
    <html>
    <head><title>HP Insight Diagnostics Survey Report</title></head>
    <body>
    <p><xsl:text>HP Insight Diagnostics Survey </xsl:text>
       <xsl:text> v</xsl:text>
       <xsl:value-of select="@version"/>
       <br/>
       <xsl:text> Session time stamp: </xsl:text>
       <xsl:value-of select="@timeStampCaption"/></p>
    <xsl:apply-templates select="category"/>
    </body>
    </html>
</xsl:template>

<xsl:template match="category">
    <div class="category">
        <p style="font-weight:bold;text-decoration:underline;">
            <xsl:value-of select="@caption"/></p>
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="structure">
    <span>
        <xsl:value-of select="@caption"/>
        <xsl:if test="@description">
            <xsl:text>, </xsl:text>
            <xsl:value-of select="@description"/></xsl:if>
        <xsl:if test="@value">
            <xsl:text>, </xsl:text>
            <xsl:value-of select="@value"/></xsl:if>
    </span>
    <br/>
    <div class="structure" style="margin-left:15pt;">
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="property">
    <span style="margin-left:15pt;">
        <xsl:value-of select="@caption"/>
        <xsl:if test="@value">
            <xsl:text>, </xsl:text>
            <xsl:value-of select="@value"/></xsl:if>
        <xsl:if test="@description">
            <xsl:text>, </xsl:text>
            <xsl:value-of select="@description"/></xsl:if>
    </span>
    <br/>
</xsl:template>

<xsl:template match="device">
    <span class="device">
        <xsl:value-of select="@caption"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="@description"/>
        <xsl:if test="@category">
            <xsl:text>, </xsl:text>
            <xsl:value-of select="@category"/></xsl:if>
    </span>
    <br/>
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="interface">
    <span class="interface">
        <xsl:value-of select="@caption"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="@description"/>
    </span>
    <xsl:apply-templates/>
</xsl:template>

</xsl:stylesheet>