<?php
  header('Content-type: text/plain', true);

  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Check for ID result
  if (!file_exists(IDRESULT_PATH))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'idResult missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  // Make ID result into a XMLDocument
  $xml = new XMLDocument(file_get_contents(IDRESULT_PATH));
  $xpath = xpath_new_context($xml->document_element());
  $categoryNodes = xpath_eval($xpath, '/diagOutput/category');

  $currentConfig = array();
  $key = array('categories' => 'c',
               'name'       => 'n',
               'caption'    => 'c',
               'sections'   => 's',
               'value'      => 'v',
               'isAdvanced' => 'a',
               'isHex'      => 'h',
               'entries'    => 'e',
               'depth'      => 'd');
  $currentConfig['key']  = $key;
  $currentConfig['data'] = array();
  $currentConfig['data'][$key['categories']] = array();
  foreach($categoryNodes->nodeset as $category)
  {
    $categoryArray = array();
    $categoryArray[$key['name']] = $category->get_attribute('name');
    $categoryArray[$key['caption']] = $category->get_attribute('caption');
    $categoryArray[$key['sections']] = array();
    $xpath = xpath_new_context($category);
    $categoryChildren = xpath_eval($xpath, '/child::*');
    foreach($categoryChildren->nodeset as $child)
    {
      $tagName = $child->tagname;
      $testOnly = $child->get_attribute('testOnly');
      // Make sure we want to display this entry
      if ($testOnly != '1' && ($tagName == 'device' || $tagName == 'structure' || $tagName == 'property'))
      {
        $sublevel = 0;
        $categoryArray[$key['sections']][] = buildEntry($child, $sublevel);
      }
    }
    $currentConfig['data'][$key['categories']][] = $categoryArray;
  }
  
  function buildEntry($entry, $sublevel, $advanced=false)
  {
    global $key;
    $value = $entry->get_attribute('value');
    $description = $entry->get_attribute('description');
    $trueValue = ($value != '') ? $value : (($description != '') ? $description : '');
    $entryArray = array();
    $entryArray[$key['caption']] = $entry->get_attribute('caption');
    $entryArray[$key['value']] = $trueValue;
    $entryArray[$key['isAdvanced']] = ($advanced || $entry->get_attribute('techDetail') == '1') ? true : false;
    if ($sublevel == 0)
    {
      $entryArray[$key['entries']] = array();
    }
    else
    {
      $entryArray[$key['isHex']] = ($entry->get_attribute('hexData') == '1') ? true : false;
      $entryArray[$key['depth']] = $sublevel;
    }
    $xpath = xpath_new_context($entry);
    $children = xpath_eval($xpath, '/child::node()');
    for($i=0; $i<count($children->nodeset); $i++)
    {
      $child = $children->nodeset[$i];
      // Make sure child is an XML_ELEMENT_NODE
      if ($child->node_type() == XML_ELEMENT_NODE)
      {
        $tagName = $child->tagname;
        $testOnly = $child->get_attribute('testOnly');
        // Make sure we want to display this entry
        if ($testOnly != '1' && ($tagName == 'device' || $tagName == 'structure' || $tagName == 'property'))
        {
          $nestedAdvanced = false;
          // If this element is advanced, all of its children need to be marked advanced as well so they are hidden or visible along with their parent
          $nestedAdvanced = ($advanced || $entryArray[$key['isAdvanced']]) ? true : false;
          $sublevel++;
          $entryArray[$key['entries']][] = buildEntry($child, $sublevel, $nestedAdvanced);
          $sublevel--; // put sublevel back to original number on return
        }
      }
    }
    return $entryArray;
  }
  // Output JSON object
  exit(Rosetta::arrayToJSON($currentConfig));
  //*/
?>
