<?php
  header('Content-type: text/plain', true);

  include_once '../includes/globals.php';
  include_once '../includes/aibridge.class.php';
  include_once '../includes/rosetta.class.php';

  // Call AI
  $stdout = AIBridge::getSaveDevices();

  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    if ($document->tagname() == 'error') // If AI returned an error:
    {
      $outputArray = array(
        'name'  => 'AI Error',
        'value' => $document->get_content());
      die(Rosetta::arrayToJSON($outputArray));
    }
  }
  else
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

  $key = array(
    'devicePath' => 'd',
    'name' => 'n');
  $deviceArray = array();
  $deviceArray['key'] = $key;
  $deviceArray['data'] = array();

  $xpath = xpath_new_context($document);
  $devices = xpath_eval($xpath, '/removableMediaDevice');
  foreach ($devices->nodeset as $device)
  {
    $item = array();
    $item[$key['devicePath']] = $device->get_attribute('devicePath');
    $friendlyNames = $device->get_elements_by_tagname('friendlyName');
    if (count($friendlyNames) > 0)
    {
      $friendlyName = $friendlyNames[0];
      $item[$key['name']] = $friendlyName->get_content();
    }
    else
    {
      $item[$key['name']] = $item[$key['devicePath']];
    }
    $deviceArray['data'][] = $item;
  }

  exit(Rosetta::arrayToJSON($deviceArray));

?>
