<?php
  header('Content-type: text/plain', true);

  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Call AI
  $stdout = AIBridge::getTestLog();

  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    if ($document->tagname() == 'error') // If AI returned an error:
    {
      $outputArray = array(
        'name'  => 'AI Error',
        'value' => $document->get_content());
      die(Rosetta::arrayToJSON($outputArray));
    }
  }
  else
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

    // Create associative array of pertinent testlog info
  $key = array(
    'test'    => 't',
    'failed'  => 'f',
    'time'    => 'i',
    'tested'  => 'd',
    'last'    => 'l',
    'result'  => 'r');
  $testLogArray = array();
  $testLogArray['key']  = $key;
  $testLogArray['data'] = array();
  $xpath = xpath_new_context($document);
  $records = xpath_eval($xpath, '/testLogRecord');
  foreach ($records->nodeset as $record)
  {
    $testArray = array();
    $testArray[$key['test']]   = $record->get_attribute('testCaption');
    $testArray[$key['failed']] = $record->get_attribute('failedCount');
    $testArray[$key['time']]   = $record->get_attribute('testTime');
    
    $xpath = xpath_new_context($record);
    $completions = xpath_eval($xpath, '/testCompletion[@result!=""]'); // only get test completions with actual results
    $numberOfCompletions = count($completions->nodeset);
    $testArray[$key['tested']] = $numberOfCompletions;
    if ($numberOfCompletions)
    {
      $lastCompletion = $completions->nodeset[$numberOfCompletions-1]; // get the last testCompetion
      $testArray[$key['last']] = $lastCompletion->get_attribute('completionTime');
      $testArray[$key['result']] = $lastCompletion->get_attribute('result');
    }
    else
    {
      $testArray[$key['last']] = '';
      $testArray[$key['result']] = ''; 
    }
    $testLogArray['data'][] = $testArray;
  }
  // Output JSON object
  exit(Rosetta::arrayToJSON($testLogArray));
  //*/
?>