<?php
header('Content-type: text/html', true);

define('IS_ATTACHMENT', (isset($_GET['attachment']) && $_GET['attachment'] == 1));

include_once '../includes/globals.php';
include_once '../includes/rosetta.class.php';
include_once '../includes/aibridge.class.php';
include_once '../includes/parseComparison.php';
include_once '../includes/filesaver.class.php';
include_once '../includes/fileprompter.class.php';

if (IS_ATTACHMENT)
{
  if (!requiredParameters('filename', 'category', 'advanced', 'leftFile', 'leftFileName', 'rightFile', 'rightFileName'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  FilePrompter::prepareForSaving();
}
else
{
  if (!requiredParameters('devicePath', 'filename', 'category', 'advanced', 'leftFile', 'leftFileName', 'rightFile', 'rightFileName'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  if ((!isset($_GET['overwrite']) || $_GET['overwrite'] != 'yes') &&
      FileSaver::doesFileExist($_GET['filename'], 'html', $_GET['devicePath']))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'error:exists');
    die(Rosetta::arrayToJSON($outputArray));
  }
}

define('LEFT_FILENAME', ($_GET['leftFileName'] == 'original') ? translate('MSG_ORIGINAL_CONFIGURATION') : $_GET['leftFileName']);
define('RIGHT_FILENAME', ($_GET['rightFileName'] == 'current') ? translate('MSG_CURRENT_CONFIGURATION') : $_GET['rightFileName']);
define('VIEW_ADVANCED', ($_GET['advanced'] == 'yes') ? true : false);
define('CHANGES_ONLY', ($_GET['changesOnly'] == 'yes') ? true : false);

$comparisonData = parseComparison($_GET['leftFile'], $_GET['rightFile'], $_GET['category']);

// Output HTML
$computerName = getComputerName();
$buildVersion = getBuildVersion();
$html = array();

$html[] = '<html>';
$html[] = '<head>';
$html[] = '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">';
$html[] = '<title>' . $computerName . ' - ' . translate('MSG_SURVEY_COMPARISON') . '</title>';
$html[] = includeStyleSheet('compareConfigStyle.css');
$html[] = '</head>';
$html[] = '<body>';

if ($buildVersion != '')
  $html[] = ('<i>HP Insight Diagnostics ' . translate('MSG_VERSION') . ' ' . $buildVersion . '</i><br>');

if ($computerName != '')
  $html[] = (translate('MSG_COMPUTER_NAME') . ': <b>' . $computerName . '</b>');

// $html[] = ('<br><span class="changed">' . translate('MSG_CHANGE_IN_CONFIGURATION') . '</span>');
$html[] = '<table>';

if ($comparisonData == 0)
{
  $html[] = '<tr class="message">';
  $html[] = ('<td>' . translate('MSG_NO_CHANGES_FOUND') . '</td>');
  $html[] = '</tr>';
}
else
{
  $categoryCount = count($comparisonData);
  foreach ($comparisonData as $category)
  {
    if (CHANGES_ONLY === false || $category['containsNestedChanges'] === true)
    {
      if ($categoryCount > 1)
        outputHeader($html, $category['caption']);
      foreach ($category['children'] as $child)
      {
        if (shouldDisplayChild($child))
        {
          $sublevel = ($categoryCount > 1) ? 1 : 0;
          outputData($html, $child, $sublevel);
        }
      }
    }
  }
}

function outputHeader(&$html, $caption)
{
  $html[] = '<tr class="header">';
  $html[] = '<td> </td>';
  $html[] = '<th>' . $caption . '</th>';
  $html[] = '<th>' . LEFT_FILENAME . '</th>';
  $html[] = '<th>' . RIGHT_FILENAME . '</th>';
  $html[] = '</tr>';
}

function outputData(&$html, &$child, $sublevel)
{
  if ($sublevel == 0)
  {
    outputHeader($html, $child['caption']);
  }
  else
  {
    if (CHANGES_ONLY === false || $child['compareResult'] != 'unchanged')
    {
      switch ($child['compareResult'])
      {
      case 'added':
        outputAddedData($html, $child['caption'], $child['right'], $child['isHexData'], $sublevel);
        break;
      case 'removed':
        outputRemovedData($html, $child['caption'], $child['left'], $child['isHexData'], $sublevel);
        break;
      default:
        outputStandardData($html, $child, $sublevel);
      }
    }
  }
  foreach ($child['children'] as $nextChild)
  {
    if (shouldDisplayChild($nextChild))
    {
      $sublevel++;
      outputData($html, $nextChild, $sublevel);
      $sublevel--;
    }
  }
}

function outputAddedData(&$html, $caption, $value, $isHexData, $sublevel)
{
  $padding = ($sublevel > 1) ? (15 * ($sublevel - 1)) : 2;
  $class = array('changed');
  if ($isHexData === true)
    $class[] = 'hex';
  if ($sublevel == 1)
    $class[] = 'top';
  $html[] = '<tr class="' . implode(' ', $class) . '">';
  $html[] = ('<td class="cr">' . translate('MSG_ADDED') . '</td>');
  $html[] = ('<td style="padding-left:' . $padding . 'px">' . $caption . '</td>');
  $html[] = ('<td> </td>');
  $html[] = ('<td>' . $value . '</td>');
  $html[] = '</tr>';
}

function outputRemovedData(&$html, $caption, $value, $isHexData, $sublevel)
{
  $padding = ($sublevel > 1) ? (15 * ($sublevel - 1)) : 2;
  $class = array('changed');
  if ($isHexData === true)
    $class[] = 'hex';
  if ($sublevel == 1)
    $class[] = 'top';
  $html[] = '<tr class="' . implode(' ', $class) . '">';
  $html[] = '<tr class="changed">';
  $html[] = ('<td class="cr">' . translate('MSG_REMOVED') . '</td>');
  $html[] = ('<td style="padding-left:' . $padding . 'px">' . $caption . '</td>');
  $html[] = ('<td>' . $value . '</td>');
  $html[] = ('<td> </td>');
  $html[] = '</tr>';
}

function outputStandardData(&$html, &$child, $sublevel)
{
  $padding = ($sublevel > 1) ? (15 * ($sublevel - 1)) : 2;
  $class = array();
  if ($child['compareResult'] != 'unchanged')
  {
    $class[] = 'changed';
    $resultClass = 'cr';
    $result = translate('MSG_CHANGED');
  }
  else
  {
    $resultClass = 'cu';
    $result = translate('MSG_UNCHANGED');
  }
  if ($child['isHexData'] === true)
    $class[] = 'hex';
  if ($sublevel == 1)
    $class[] = 'top';
  $html[] = ('<tr class="' . implode(' ', $class) . '">');
  $html[] = ('<td class="' . $resultClass . '">' . $result . '</td>');
  $html[] = ('<td style="padding-left:' . $padding . 'px">' . $child['caption'] . '</td>');
  $html[] = ('<td>' . $child['left'] . '</td>');
  $html[] = ('<td>' . $child['right'] . '</td>');
  $html[] = '</tr>';
}

function shouldDisplayChild($child)
{
  $returnVal = false;
  if (CHANGES_ONLY === false || $child['compareResult'] != 'unchanged' || $child['containsNestedChanges'] === true)
  {
    if (VIEW_ADVANCED === true || $child['isAdvanced'] === false || $child['compareResult'] != 'unchanged' || $child['containsNestedChanges'] === true)
      $returnVal = true;
  }
  return $returnVal;
}

$html[] = '</body>';
$html[] = '</html>';

if (IS_ATTACHMENT)
{
  $filename = ($_GET['filename'] . ".html");
  FilePrompter::promptForSave($filename, $html, 'text/html');
}
else
{
  $filename = $_GET["filename"];
  $extension = "html";
  $devicePath = $_GET["devicePath"];
  
  $saveResult = FileSaver::saveArrayToFile($filename, $extension, $devicePath, $html);

  if ($saveResult == 'success')
    exit('0');
  else
    exit('error');
}

//*/
?>
