<?php
  header('Content-type: text/plain', true);

  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Check for variables
  if (!requiredParameters('durationType','durationValue','mode','stopOnError','type','tests'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some Required Variables were missing');
    die(Rosetta::arrayToJSON($outputArray));
  }

  $customTests = array();
  $testList = $_POST['tests'];
  $numberOfTests = count($testList);
  for ($i=0; $i<$numberOfTests; $i++)
  {
    $testInfo = array();
    $testName = explode(':::', $testList[$i]);
    $parameters = $_POST['test' . $i . 'Parameters'];
    $numberOfParameters = count($parameters);
    
    $componentName = $testName[0];
    // strip the extra escaped slashes from the component path
    $testInfo['component'] = preg_replace("/\\\\{2,}/", "\\", $componentName );
    
    $testInfo['device'] = $testName[1];
    $testInfo['test'] = $testName[2];
    $testInfo['parameters'] = array();
    for ($j=0; $j<$numberOfParameters; $j++)
    {
      $parameter = $parameters[$j];
      $parameterArray = array();
      $parameterData = explode(':', $parameter);
      $parameterArray['name'] = $parameterData[0];
      $parameterArray['value'] = join(':', array_slice($parameterData, 1)); // in case the value contained colons, this will fix recombine it
      $testInfo['parameters'][] = $parameterArray;
    }
    $customTests[] = $testInfo;
  }

  // Call AI
  $stdout = AIBridge::startCustomTests($_POST['type'], $_POST['durationType'], $_POST['durationValue'], $_POST['stopOnError'], $customTests);

  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    if ($document->tagname() == 'error') // If AI returned an error:
    {
      $outputArray = array(
        'name'  => 'AI Error',
        'value' => $document->get_content());
      die(Rosetta::arrayToJSON($outputArray));
    }
    $processID = $document->get_attribute('processID');
  }
  else
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

  exit($processID);
//*/
?>
