<?php
include_once '../includes/globals.php';

function parseTitles($path)
{
  $path .= ('/' . LANG . '/toc.xml');
  $tocFile = file_get_contents($path);
  $document = new XMLDocument($tocFile);
  $root = $document->document_element();
  $xpath = xpath_new_context($root);

  $titles = array();
  $items = @ xpath_eval($xpath, '/page | /book');
  foreach ($items->nodeset as $item)
  {
    $src = $item->get_attribute('src');
    if ($item->tagname() == 'page')
    {
      $title = $item->get_content();
    }
    else
    {
      $xpath = xpath_new_context($item);
      $titleNode = extractFirstNode($xpath, '/title');
      $title = $titleNode->get_content();
    }
    $titles[$src] = $title;
  }
  return $titles;
}
//*/
?>
