function CollapsableListItem(element)
{
  this.element = element;
  this.widget = new CollapsableListItemWidget(element.getElementsByTagName('img')[0], element.getElementsByTagName('a')[0], this);
  this.childList = element.getElementsByTagName('ul')[0];

  this.widget.toggleState('closed');
}

CollapsableListItem.prototype.hideChild = function ()
{
  this.childList.style.display = 'none';
}

CollapsableListItem.prototype.showChild = function ()
{
  this.childList.style.display = '';
}

function CollapsableListItemWidget(imgElement, linkElement, controller)
{
  this.imgElement = imgElement;
  this.linkElement = linkElement;
  this.controller = controller;
  this.expandImage = '../images/tree_expand.gif';
  this.collapseImage = '../images/tree_collapse.gif';
  this.state = 'open';

  this.imgElement.controller = this;
  this.imgElement.onclick = function ()
  {
    this.controller.toggleState();
    return false;
  }

  this.linkElement.controller = this;
  this.linkElement.onclick = function ()
  {
    this.controller.toggleState();
    return false;
  }
}

CollapsableListItemWidget.prototype.toggleState = function (state)
{
  if (state == 'closed' || (state == undefined && this.state == 'open'))
  {
    this.controller.hideChild();
    this.setClosedState();
  }
  else
  {
    this.controller.showChild();
    this.setOpenState();
  }
}

CollapsableListItemWidget.prototype.setClosedState = function ()
{
  this.imgElement.src = this.expandImage;
  this.state = 'closed';
}

CollapsableListItemWidget.prototype.setOpenState = function ()
{
  this.imgElement.src = this.collapseImage;
  this.state = 'open';
}
