<?php
  ini_set('error_reporting', E_ERROR | E_PARSE);
  ini_set('html_errors', 0);
  
  set_time_limit(0); // remove PHP timeout timer

  require_once 'xmlbridge.php';

  define('PHP_DIRECTORY', (session_save_path() . '/'));
  define('FRONTEND_DEBUG_FILE', (PHP_DIRECTORY . 'frontendDebugFile.txt'));
  define('FRONTEND_ERROR_LOG', (PHP_DIRECTORY . 'frontendErrorLog.txt'));
  define('AI_OUTPUT_FILE', (PHP_DIRECTORY . 'aiLastOutput.txt'));

  if (isset($_REQUEST['debugMode']) && $_REQUEST['debugMode'] == 'on')
    define('DEBUG_MODE', true);
  else
    define('DEBUG_MODE', false);

  if (isset($_REQUEST['advancedMode']) && $_REQUEST['advancedMode'] == 'on')
    define('ADVANCED_MODE', true);
  else
    define('ADVANCED_MODE', false);

  if (getenv('PHOENIX') != null)
    define('IS_PHOENIX', true);
  else
    define('IS_PHOENIX', false);

  if (getenv('HPDIAGS_CD') != null)
    define('IS_DIAGSCD', true);
  else
    define('IS_DIAGSCD', false);

  if (IS_PHOENIX || IS_DIAGSCD)
  {
    define('IS_OFFLINE', true);
    define('IS_ONLINE', false);
  }
  else
  {
    define('IS_OFFLINE', false);
    define('IS_ONLINE', true);
  }

  if (isset($_SERVER['SERVER_SOFTWARE']) &&
      strstr($_SERVER['SERVER_SOFTWARE'], 'System Management Homepage') !== false)
    define('IS_SMH', true);
  else
    define('IS_SMH', false);
  
  if (strstr(PHP_OS, 'Linux'))
  {
    define('IS_WINDOWS', false);
    define('IS_LINUX', true);
    define('IS_SOLARIS', false);
  }
  else if (strstr(PHP_OS, 'SunOS'))
  {
    define('IS_WINDOWS', false);
    define('IS_LINUX', false);
    define('IS_SOLARIS', true);
  }
  else
  {
    define('IS_WINDOWS', true);
    define('IS_LINUX', false);
    define('IS_SOLARIS', false);
  }

 if (IS_LINUX)
  {
    define('DIAGS_DIRECTORY', '/opt/hp/hpdiags/');
  }
  else if (IS_SOLARIS)
  {
    $hpdiags_path = shell_exec('pkgparam HPQdiags BASEDIR');
    $hpdiags_path = trim($hpdiags_path);
    define('DIAGS_DIRECTORY', $hpdiags_path.'/hpdiags/');
  }
  else
  {
    if (isset($_ENV['SystemDrive']))
      $systemDrive = $_ENV['SystemDrive'];
    else
      $systemDrive = 'c:';
    define('DIAGS_DIRECTORY', ($systemDrive . '/hp/hpdiags/'));
  }

  if (isset($_ENV['HPDIAGSWRITEDIR']))
    define('WRITE_DIRECTORY', ($_ENV['HPDIAGSWRITEDIR'] . '/'));
  else
    define('WRITE_DIRECTORY', DIAGS_DIRECTORY);

  define('DIAGCONFIG_PATH', (WRITE_DIRECTORY . 'diagconfig.xml'));

  if (checkDiagConfig('/factory'))
    define('IS_FACTORY', true);
  else
    define('IS_FACTORY', false);

  if (isset($_GET['overrideIdResult']))
    define('IDRESULT_PATH', (WRITE_DIRECTORY . $_GET['overrideIdResult']));
  else
    define('IDRESULT_PATH', (WRITE_DIRECTORY . 'idResult.xml'));

  if (IS_LINUX || IS_SOLARIS)
    define('AI_PATH', (DIAGS_DIRECTORY . 'hpdiagsai'));
  else
    define('AI_PATH', (DIAGS_DIRECTORY . 'hpdiagsai.exe'));
    
  $supportedLanguages = array('en', 'fr', 'it', 'de', 'es', 'ja');
  $lang = 'en';
  if (isset($_GET['overrideLang']))
  {
    $overrideLang = $_GET['overrideLang'];
    if (in_array($overrideLang, $supportedLanguages))
    {
      $lang = $overrideLang;
      define('OVERRIDE_LANG', $lang);
    }
  }
  else
  {
    if (IS_OFFLINE)
    {
      $languageFile = '/root/compaq/language.txt';
      if (file_exists($languageFile))
      {
        $languageString = file_get_contents($languageFile);
        // we are only interested in the 1st three charcters
        $languageString = (strlen($languageString) > 3) ? substr($languageString, 0, 3) : $languageString;
        switch ($languageString)
        {
        case 'ENG':
          $lang = 'en';
          break;
        case 'FRE':
          $lang = 'fr';
          break;
        case 'ITA':
          $lang = 'it';
          break;
        case 'GER':
          $lang = 'de';
          break;
        case 'SPA':
          $lang = 'es';
          break;
        case 'JPN':
          $lang = 'ja';
          break;
        }
      }
    }
    else
    {
      $languageString = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
      // we are only interested in the 1st two charcters
      $lang = (strlen($languageString) >= 2) ? substr($languageString, 0, 2) : 'en';
    }
    // if it's not one of our supported languages, set it to English
    if (!in_array($lang, $supportedLanguages))
      $lang = 'en';
  }
  define('LANG', $lang);

  if (isset($_SERVER['SCRIPT_URI']))
    $path = $_SERVER['SCRIPT_URI'];
  else
    $path = $_SERVER['SCRIPT_NAME'];

  $lastSlash = strrpos($path, '/');
  $baseURI = substr($path, 0, ($lastSlash + 1));
  define('FRONTEND_DIRECTORY', $baseURI);
  define('DOCUMENT_DIRECTORY', ($_SERVER['DOCUMENT_ROOT'] . '/hpdiags/frontend2/'));

  if (checkDiagConfig('/factory/configVerify') || (isset($_GET['cfg']) && $_GET['cfg'] == "1"))
    define('CONFIG_VERIFY', true);
  else
    define('CONFIG_VERIFY', false);

  if (CONFIG_VERIFY)
  {
    if (checkDiagConfig('/factory/configVerifyCloseOnFail'))
      define('CONFIG_VERIFY_CLOSE_ON_FAIL', true);
    else
      define('CONFIG_VERIFY_CLOSE_ON_FAIL', false);
  }

  function checkDiagConfig($tagname, $attributeName='', $attributeValue='')
  {
    $returnVal = false;
    $xml = new XMLDocument(file_get_contents(DIAGCONFIG_PATH));
    $xpath = xpath_new_context($xml->document_element());
    $tags = @ xpath_eval($xpath, $tagname);
    if (count($tags->nodeset)) // if we found the tag, continue
    {
      $returnVal = true;
      // if we are supposed to check for an attribute, do that now
      if ($attributeName != '')
      {
        $tag = $tags->nodeset[0]; // we will check only the first occurance of this tag
        $attribute = $tag->get_attribute($attributeName);
        // if we are comparing the attribute value, do that now
        if ($attributeValue != '')
        {
          if ($attribute == $attributeValue)
            $returnVal = true;
          else
            $returnVal = false;
        }
        else
        {
          // are aren't comparing the value, we will return the value instead
          $returnVal = $attribute; 
        }
      }
    }
    return $returnVal;
  }
?>
