<?php
require_once 'aibridge.class.php';

class FileSaver
{
  function doesFileExist($filename, $extension, $devicePath)
  {
    $filename = "$filename.$extension";
    $stdout = AIBridge::checkForFileOnSaveDevice($devicePath, $filename);
    
    $xml = new XMLDocument($stdout);
    if ($xml)
    {
      $document = $xml->document_element();
      if ($document->tagname() == 'error')
      {
        $outputArray = array(
          "name"  => "AI Error",
          "value" => $document->get_content());
        die(Rosetta::arrayToJSON($outputArray));
      }
    }
    else
    {
      $outputArray = array(
        "name"  => "XML Error",
        "value" => $stdout);
      die(Rosetta::arrayToJSON($outputArray));
    }
    
    if ($document->tagname() == "yes")
      return true;
    else
      return false;
  }
  
  function saveArrayToFile($filename, $extension, $devicePath, $array)
  {
    $filename = sprintf("%s.%s", $filename, $extension);
    $tempFileName = sprintf("%s.temp_%s", $filename, $extension, date("YmdHis"));
    $tempFilePath = FileSaver::saveArrayToTempDirectory($tempFileName, $array);
    $stdout = AIBridge::copyFileToSaveDevice($tempFilePath, $devicePath, $filename);
    
    $xml = new XMLDocument($stdout);
    if ($xml)
    {
      $document = $xml->document_element();
      if ($document->tagname() == 'error')
      {
        FileSaver::log($document->get_content());
        @ unlink($tempFilePath);
        return false;
      }
      else if ($document->tagname() != "success")
      {
        FileSaver::log($stdout);
        @ unlink($tempFilePath);
        return false;
      }
    }
    else
    {
      FileSaver::log("Invalid XML: $stdout");
      @ unlink($tempFilePath);
      return false;
    }
    @ unlink($tempFilePath);
    return true;
  }
  
  function saveArrayToTempDirectory($tempFileName, $array)
  {
    $filepath = (session_save_path() . '/' . $tempFileName);
    $file = fopen($filepath, "w");
    foreach ($array as $arrayBit)
    {
      $result = fwrite($file, $arrayBit);
    }
    fclose($file);
    return $filepath;
  }
  
  function log($msg)
  {
    $timestamp = date("H:i:s");
    $file = fopen(session_save_path() . '/' . 'FileSaver.log', 'a');
    fwrite($file, ($timestamp . ": " . $msg . "\n"));
    fclose($file);    
  }
}
    

/*
class FileSaver
{
  function doesFileExist($filename, $extension, $target, $mount, $device)
  {
    if ($target == 'winfloppy')
      $mount = 'a:/';
    else if ($mount{strlen($mount)-1} != '/')
      $mount .= '/';
    $filename .= ('.' . $extension);
    $filepath = ($mount . $filename);
    if ($target != 'winfloppy' && 
        $target != 'winhardrive' && 
        $target != 'hardrive')
    {
      $unmountDirectory = true;
      $deleteDirectory = false;
      FileSaver::mountDevice($device, $mount, $unmountDirectory, $deleteDirectory);
      if (file_exists($filepath))
        $result = true;
      else
        $result = false;
      if ($unmountDirectory == true)
        FileSaver::unmountDevice($mount, $deleteDirectory);
    }
    else
    {
      if (file_exists($filepath))
        $result = true;
      else
        $result = false;
    }
    return $result;
  }

  function saveArrayToFile($filename, $extension, $target, $mount, $device, $array)
  {
    // Add a slash to the end of the mount string
    if ($mount{strlen($mount)-1} != '/')
      $mount .= '/';
    if ($filename == '' || 
        strstr($filename, '.') || 
        strstr($filename, '/') || 
        strstr($filename, '\\') || 
        strstr($filename, '\'') || 
        strstr($filename, '"'))
    {
      return 'error:filename';
    }
    else
    {
      $filename .= ('.' . $extension);
    }
    $unmountDirectory = true;
    $deleteDirectory = false;
    switch ($target)
    {
    case ('winfloppy'):
      $mount = 'a:/'; //'a:\\\\';
    case ('winhardrive'):
      $unmountDirectory = false;
      $result = FileSaver::writeFile($filename, $array, $mount);
      if ($result != '0')
        return $result;
      else
        return 'success';
      break;
    case ('hardrive'):
      $unmountDirectory = false;
      $result = FileSaver::saveTempFile($filename, $array);
      if (stristr($result, 'error:'))
        return $result;
      else
        $tempFilename = $result;
      $result = FileSaver::copyFile($tempFilename, $filename, strlen(implode('', $array)), $mount, $device, $unmountDirectory, $deleteDirectory, false);
      if ($result != '0')
        return $result;
      else
        return 'success';
      break;
    case ('floppy'):
    case ('usbfloppy'):
    case ('diskonkey'):
      $result = FileSaver::mountDevice($device, $mount, $unmountDirectory, $deleteDirectory);
      if ($result != '0')
        return $result;
      $result = FileSaver::saveTempFile($filename, $array);
      if (stristr($result, 'error:'))
        return $result;
      else
        $tempFilename = $result;
      $result = FileSaver::copyFile($tempFilename, $filename, strlen(implode('', $array)), $mount, $device, $unmountDirectory, $deleteDirectory);
      if ($result != '0')
        return $result;
      if ($unmountDirectory == true)
        FileSaver::unmountDevice($mount, $deleteDirectory);
      return 'success';
      break;
    }
  }

  function mountDevice($device, $mount, &$unmountDirectory, &$deleteDirectory)
  {
    // If mount point doesn't exist, create it and remember to delete it later
    if (!file_exists($mount))
    {
      $stdout = AIBridge::makeDirectory($mount);
      $response = extractTags($stdout, 'stdout', 'stderr');
      if ($response['stderr'] != '')
        return 'error:mount:mkdir';
      $deleteDirectory = true;
    }
    // Make first mounting attempt, using exact device and mount arguments
    $stdout = AIBridge::mountDevice($device, $mount);
    $response = extractTags($stdout, 'stdout', 'stderr');
    // Check for errors
    if ($response['stderr'] != '')
    {
      if (!strstr($response['stderr'], 'must specify the filesystem') && !strstr($response['stderr'], 'already mounted'))
      {
        // If its not an error we can workaround, try to unmount the device and report the error
        FileSaver::unmountDevice($mount, $deleteDirectory);
        return FileSaver::getMountingError($response['stderr']);
      }
      else
      {
        $isAlreadyMounted = false;
        if (strstr($response['stderr'], 'already mounted') != false)
        {
          $matches = array();
          $pattern = '/mounted on ([^\s]+)/';
          $match = preg_match($pattern, $response['stderr'], $matches);
          if ($match > 0 && ($matches[1] == $mount || ($matches[1] . '/') == $mount))
          {
            $unmountDirectory = false;
            $isAlreadyMounted = true;
          }
        }
        if ($isAlreadyMounted == false)
        {
          // Try to mount again, specifying partition 1
          $stdout = AIBridge::mountDevice(($device . '1'), $mount);
          $response = extractTags($stdout, 'stdout', 'stderr');
          // Check for errors
          if ($response['stderr'] != '')
          {
            // If its not an error we can workaround, try to unmount the device and report the error
            if (!strstr($response['stderr'], 'must specify the filesystem') && !strstr($response['stderr'], 'already mounted'))
            {
              FileSaver::unmountDevice($mount, $deleteDirectory);
              return FileSaver::getMountingError($response['stderr']);
            }
            else if (strstr($response['stderr'], 'already mounted'))
            {
              $matches = array();
              $pattern = '/mounted on ([^\s]+)/';
              $match = preg_match($pattern, $response['stderr'], $matches);
              if ($match <= 0 || ($matches[1] != $mount && ($matches[1] . '/') != $mount))
              {
                FileSaver::unmountDevice($mount, $deleteDirectory);
                return FileSaver::getMountingError($response['stderr']);
              }
              else
              {
                $unmountDirectory = false;
              }
            }
            else
            {
              // Try to mount again with original device argument, specify 'vfat' filesystem
              $stdout = AIBridge::mountDevice($device, $mount, true); // 3rd argument specifies fat = true
              $response = extractTags($stdout, 'stdout', 'stderr');
              // Check for errors
              if ($response['stderr'] != '')
              {
                // Give up and report this error
                FileSaver::unmountDevice($mount, $deleteDirectory);
                return FileSaver::getMountingError($response['stderr']);
              }
            }
          }
        }
      }
    }
    return 0;
  }
  
  function getMountingError($error)
  {
    if (stristr($error, 'not a valid block device') || stristr($error, 'no medium found'))
      return 'error:mount:nomedia';
    else if (stristr($error, 'write-protected') || stristr($error, 'read-only'))
      return 'error:mount:readonly';
    else if (stristr($error, 'already mounted'))
      return 'error:mount:alreadymounted';
    else if (stristr($error, 'must specify the filesystem'))
      return 'error:mount:filesystem';
    else
      return 'error:mount:unknown';
  } 
  
  function unmountDevice($mount, &$deleteDirectory)
  {
    chdir('/'); // Must move out of mount directory to unmount it
    $unmountSuccessful = false;
    for($i=0; $i<5 && $unmountSuccessful == false; $i++)
    {
      $stdout = AIBridge::unmountDevice($mount);
      $response = extractTags($stdout, 'stdout', 'stderr');
      if ($response['stderr'] == '')
      {
        $unmountSuccessful = true;
      }
      else
      {
        if (!strstr($response['stderr'], 'busy'))
        {
          $unmountSuccessful = true;
        }
        else
        {
          sleep(1);
        }
      }
    }
    if ($deleteDirectory == true)
    {
      AIBridge::removeDirectory($mount);
    }
    return 0;
  }
  
  function writeFile($filename, $array, $mount)
  {
    $filestring = implode('', $array);
    $filepath = ($mount . $filename);
    $file = fopen($filepath, 'w');
    $stringLength = 0;
    $errorFree = true;
    foreach ($array as $arrayBit)
    {
      $result = fwrite($file, $arrayBit);
      if (!$result)
        $errorFree = false;
      else
        $stringLength += $result;
    }
    if (!$errorFree)
      return 'error:write:fwrite';
    if (!file_exists($filepath))
      return 'error:write:exist';
    if ($stringLength != strlen($filestring))
      return 'error:write:length';
    return 0;
  }

  function saveTempFile($filename, $array)
  {
    $tempFilename = ($filename . '.temp');
    $filepath = (session_save_path() . '/' . $tempFilename);
    $result = FileSaver::writeFile($tempFilename, $array, (session_save_path() . '/'));
    if (stristr($result, 'error:'))
      return $result;
    else
      return $filepath;
  }
  
  function copyFile($tempFilepath, $filename, $filesize, $mount, $device, &$unmountDirectory, &$deleteDirectory, $doDoubleCheck=true)
  {
    $filepath = ($mount . $filename);
    if (file_exists($filepath))
      $mtime = filemtime($filepath);
    else
      $mtime = 0;
    $stdout = AIBridge::copyFile($tempFilepath, $filepath);
    $response = extractTags($stdout, 'stdout', 'stderr');

    clearstatcache(); // clear cached info of files
    // If we have errors, unmount device, cleanup temp and report the error
    if ($response['stderr'] != '')
    {
      if ($unmountDirectory == true)
        FileSaver::unmountDevice($mount, $deleteDirectory);
      @unlink($tempFilepath);
      return 'error:copy:cp';
    }
    // If file doesn't exist after move, unmount device, cleanup temp and report the error
    chdir($mount);
    if (!file_exists($filename))
    {
      if ($unmountDirectory == true)
        FileSaver::unmountDevice($mount, $deleteDirectory);
      @unlink($tempFilepath);
      return 'error:copy:exist';
    }
    // If filesize doesn't match, unmount device, cleanup temp and report the error
    if (filesize($filepath) != $filesize)
    {
      if ($unmountDirectory == true)
        FileSaver::unmountDevice($mount, $deleteDirectory);
      @unlink($tempFilepath);
      return 'error:copy:length';
    }
    // If mtime matches, file wasn't overwritten, unmount device, cleanup temp and report the error
    if (filemtime($filepath) == $mtime)
    {
      if ($unmountDirectory == true)
        FileSaver::unmountDevice($mount, $deleteDirectory);
      @unlink($tempFilepath);
      return 'error:copy:mtime';
    }
    @unlink($tempFilepath);
    // If we didn't have any problems up to now, double check by unmounting and remounting device
    if ($doDoubleCheck)
    {
      //if ($unmountDirectory == true)
      FileSaver::unmountDevice($mount, $deleteDirectory);
      FileSaver::mountDevice($device, $mount, $unmountDirectory, $deleteDirectory);
      clearstatcache();
      chdir($mount);
      if (!file_exists($filename))
      {
        if ($unmountDirectory == true)
          FileSaver::unmountDevice($mount, $deleteDirectory);
        return 'error:copy:exist:check';
      }
      if (filesize($filepath) != $filesize)
      {
        if ($unmountDirectory == true)
          FileSaver::unmountDevice($mount, $deleteDirectory);
        return 'error:copy:length:check';
      }
      if (filemtime($filepath) == $mtime)
      {
        if ($unmountDirectory == true)
          FileSaver::unmountDevice($mount, $deleteDirectory);
        @unlink($tempFilepath);
        return 'error:copy:mtime:check';
      }
    }
    return 0;
  }
}
*/
?>
