<?php

////
// Possible return values:
// -1 : one or more of the supplied files is missing
// 0 : files are identical
// 1 : unknown error
// (string) : AI Error
// (array) : comparison data
////

function parseComparison($leftFilepath, $rightFilepath, $category='overview', $runComparison=true)
{
  if (!file_exists(WRITE_DIRECTORY . $leftFilepath) || !file_exists(WRITE_DIRECTORY . $rightFilepath))
    return -1; // file missing error

  if ($runComparison === true)
  {
    $stdout = AIBridge::compareSurveys($leftFilepath, $rightFilepath);
    $xml = new XMLDocument($stdout);
    if ($xml)
    {
      $root = $xml->document_element();
      if ($root->tagname() == 'error')
        return $root->get_content(); // AI error
      
      else if ($root->get_attribute('filesMatch') == '1')
        return 0; // files identical
    }
    else
    {
      return 1; // unknown error
    }
    AIBridge::changeComparisonPermissions();
  }

  $comparisonData = array();

  $leftCompare  = file_get_contents(WRITE_DIRECTORY . 'surveycompare.left.xml');
  $rightCompare = file_get_contents(WRITE_DIRECTORY . 'surveycompare.right.xml');

  $leftXML = new XMLDocument($leftCompare);
  $rightXML = new XMLDocument($rightCompare);

  $leftXpath = xpath_new_context($leftXML->document_element());
  $rightXpath = xpath_new_context($rightXML->document_element());

  if ($category == 'all')
    $rightCategoryNodes = @ xpath_eval($rightXpath, '/category');
  else
    $rightCategoryNodes = @ xpath_eval($rightXpath, ('/category[@name="' . $category . '"]'));

  foreach ($rightCategoryNodes->nodeset as $rightCategory)
  {
    $categoryData = array();
    $categoryData['name'] = $rightCategory->get_attribute('name');
    $categoryData['caption'] = $rightCategory->get_attribute('caption');

    $xpath = xpath_new_context($rightCategory);
    $nestedChanges = @ xpath_eval($xpath, '//*[@compareResult]');
    $categoryData['containsNestedChanges'] = (count($nestedChanges->nodeset) > 0) ? true : false;

    $leftCategory = extractFirstNode($leftXpath, ('/category[@name="' . $categoryData['name'] . '"]'));

    $rightChildren = $rightCategory->child_nodes();
    $leftChildren = $leftCategory->child_nodes();

    $childCount = count($rightChildren);
    $categoryData['children'] = array();
    for ($i=0; $i<$childCount; $i++)
    {
      $rightChild = $rightChildren[$i];
      if (isChildValid($rightChild))
      {
        $leftChild = $leftChildren[$i];
        $categoryData['children'][] = parseComparisonChild($leftChild, $rightChild);
      }
    }

    $comparisonData[] = $categoryData;
  }

  return $comparisonData;
}

function parseComparisonChild(&$leftData, &$rightData)
{
  $childData = array();
  $childData['caption'] = $rightData->get_attribute('caption');
  $childData['isHexData'] = ($rightData->get_attribute('hexData') == '1') ? true : false;
  $childData['isAdvanced'] = ($rightData->get_attribute('techDetail') == '1') ? true : false;
  $childData['compareResult'] = ($rightData->has_attribute('compareResult')) ? $rightData->get_attribute('compareResult') : 'unchanged';

  $xpath = xpath_new_context($rightData);
  $nestedChanges = @ xpath_eval($xpath, '//*[@compareResult]');
  $childData['containsNestedChanges'] = (count($nestedChanges->nodeset) > 0) ? true : false;

  if ($childData['compareResult'] == 'added')
  {
    $childData['left'] = '';
    $childData['right'] = extractValue($rightData, $childData['caption']);
  }
  else if ($childData['compareResult'] == 'removed')
  {
    $childData['left'] = extractValue($leftData, $childData['caption']);
    $childData['right'] = '';
  }
  else
  {
    $childData['left'] = extractValue($leftData, $childData['caption']);
    $childData['right'] = extractValue($rightData, $childData['caption']);
  }

  $rightChildren = $rightData->child_nodes();
  $leftChildren = $leftData->child_nodes();

  $childCount = count($rightChildren);
  $childData['children'] = array();
  for ($i=0; $i<$childCount; $i++)
  {
    $rightChild = $rightChildren[$i];
    if (isChildValid($rightChild))
    {
      $leftChild = $leftChildren[$i];
      $childData['children'][] = parseComparisonChild($leftChild, $rightChild);
    }
  }

  return $childData;
}

function extractValue($data, $nullMatch='')
{
  $returnVal = '';
  $value = $data->get_attribute('value');
  $description = $data->get_attribute('description');
  if ($value != '' && $value != $nullMatch)
    $returnVal = $value;
  else if ($description != '' && $description != $nullMatch)
    $returnVal = $description;
  return $returnVal;
}

function isChildValid($child)
{
  $returnVal = false;
  if ($child->node_type() == XML_ELEMENT_NODE)
  {
    $validTagnames = array('device', 'structure', 'property');
    $tagname = $child->tagname();
    $testOnly = $child->get_attribute('testOnly');
    if ($testOnly != '1' &&
        in_array($tagname, $validTagnames))
      $returnVal = true;
  }
  return $returnVal;
}
//*/
?>
