/********************************************************************
//        NAME- Body
// DESCRIPTION- A global, cross-browser wrapper for the document.body
//              element
//       NOTES- This wrapper allows the body element to act like
//              extended HTML Elements
********************************************************************/
var Body = {};

/********************************************************************
// Body.element : function
// Returns the actual body element, based on browser capability
********************************************************************/
Body.element = function element()
{
  if (document.body && document.body.offsetHeight)
  {
    var element = document.body;
  }
  else if (document.getElementsByTagName('body').length > 0)
  {
    var element = document.getElementsByTagName('body').item(0);
  }
  else
  {
    var element =
    {
      'offsetTop'   : 0,
      'offsetLeft'  : 0,
      'offsetWidth' : 0,
      'offsetHeight': 0
    }
  }
  return element;
}

/********************************************************************
// Body.appendChild(child) : function
//   child : Element
// Appends child to the body element
********************************************************************/
Body.appendChild = function appendChild(child)
{
  if (this.element().appendChild != undefined)
    return this.element().appendChild(child);
  return child;
}

/********************************************************************
// Body.adjustToViewport(stretcher) : function
//   stretcher : Element
// Adjusts the size of the stretcher element to match the body
//   element's size to the Viewport's size
********************************************************************/
Body.adjustToViewport = function adjustToViewport(stretcher)
{
  var returnVal = {};
  if (stretcher.extended == undefined)
    extendElement(stretcher);
  var currentBodyHeight = Body.getHeight();
  var currentViewportHeight = Viewport.getHeight();
  var currentStretcherHeight = stretcher.getHeight();
  if (currentBodyHeight > currentViewportHeight)
  {
    var heightDifference = currentBodyHeight - currentViewportHeight;
    var targetStretcherHeight = ((currentStretcherHeight - heightDifference) - 1);
    var newStretcherHeight = targetStretcherHeight;
  }
  else
  {
    var heightDifference = currentViewportHeight - currentBodyHeight;
    var targetStretcherHeight = ((currentStretcherHeight + heightDifference) - 1);
    var newStretcherHeight = targetStretcherHeight;
  }
  stretcher.setHeight(newStretcherHeight);
  currentStretcherHeight = stretcher.getHeight();
  if (currentStretcherHeight > newStretcherHeight)
  {
    var heightDifference = currentStretcherHeight - newStretcherHeight;
    newStretcherHeight -= heightDifference;
  }
  else
  {
    var heightDifference = newStretcherHeight - currentStretcherHeight;
    newStretcherHeight += heightDifference;
  }
  stretcher.setHeight(newStretcherHeight);
  currentStretcherHeight = stretcher.getHeight();
  return returnVal;
}

/********************************************************************
// Body.getTop() : function
// Returns the pixel location of the top of the body element
********************************************************************/
Body.getTop = function getTop()
{
  return this.element().offsetTop;
}

/********************************************************************
// Body.getLeft() : function
// Returns the pixel location of the left of the body element
********************************************************************/
Body.getLeft = function getLeft()
{
  return this.element().offsetLeft;
}

/********************************************************************
// Body.getRight() : function
// Returns the pixel location of the right of the body element
********************************************************************/
Body.getRight = function getRight()
{
  return this.element().offsetLeft + body.offsetWidth;
}

/********************************************************************
// Body.getBottom() : function
// Returns the pixel location of the bottom of the body element
********************************************************************/
Body.getBottom = function getBottom()
{
  return this.element().offsetTop + body.offsetHeight;
}

/********************************************************************
// Body.getHeight() : function
// Returns the height of the body element in pixels
********************************************************************/
Body.getHeight = function getHeight()
{
  return this.element().offsetHeight;
}

/********************************************************************
// Body.getWidth() : function
// Returns the width of the body element in pixels
********************************************************************/
Body.getWidth = function getWidth()
{
  return this.element().offsetWidth;
}
