function HelpTabController()
{
  // inherit all methods and members of the TabController class
  inherit(this, TabController);
  // setup Elements

  this.init();
}

HelpTabController.prototype.init = function init()
{
  // setup tabs
  this.addTab('hpdiags', 'hpInsightDiagnosticsTab', ['hpInsightDiagnosticsView'], ['diagsHelpFrame'], 'diagsHelpFrame');
  if (CONFIG.SURVEY_ONLY == false)
  {
    this.addTab('errorCodes', 'errorCodesTab', ['errorCodesView'], ['errorCodesFrame'], 'errorCodesFrame');
    this.addTab('testComponent', 'testComponentTab', ['testComponentView'], [], '');
  }

  this.tabs.hpdiags.addInitialAction(function (that)
  {
    getElement('diagsHelpFrame').src = CONFIG.HELP_SRC;
  });

  if (CONFIG.SURVEY_ONLY == false)
  {
    // setup errorCodes tab actions
    this.tabs.errorCodes.addActivationAction(function(that)
    {
      if (!that.isUpdated)
      {
        Frontend.errorCodes.refresh();
        that.isUpdated = true;
      }
    });

    this.tabs.testComponent.addActivationAction(function (that)
    {
      Frontend.testComponents.resize();
    });

    this.tabs.testComponent.addInitialAction(function (that)
    {
      Frontend.testComponents.runCatalog();
    });
  }
}
