function ImlLogController()
{
  this.saveCommand   = 'commands/saveImlLog.php';
  this.viewController = new ViewController('imlLogFrame');
  this.viewURL = 'views/imlLog.php';
  this.clearRequest = new ServerRequest('commands/clearImlLog.php');
  this.addNoteRequest = new ServerRequest('commands/addImlNote.php');
  this.repairRequest = new ServerRequest('commands/repairImlItems.php');

  this.checkAllButton = getElement('imlLogCheckAll');
  this.uncheckAllButton = getElement('imlLogUncheckAll');
  this.clearButton = getElement('clearImlLog');
  this.saveButton = getElement('saveImlLog');
  this.addNoteButton = getElement('addNoteImlLog');
  this.repairButton = getElement('imlLogSetToRepair');

  this.sortField = '';
  
  this.shadowBox = this.viewController.shadowBox;
  
  this.init();
}

ImlLogController.prototype.init = function init()
{
  this.checkAllButton.controller = this;
  this.checkAllButton.action = function ()
  {
    this.controller.viewController.getContentWindow().toggleCheckBoxes(true);
  }
  this.checkAllButton.disable();

  this.uncheckAllButton.controller = this;
  this.uncheckAllButton.action = function ()
  {
    this.controller.viewController.getContentWindow().toggleCheckBoxes(false);
  }
  this.uncheckAllButton.disable();

  this.clearButton.controller = this;
  this.clearButton.action = function ()
  {
    this.controller.promptToClearLog(translate('MSG_INTEGRATED_MANAGEMENT_LOG'), this.controller);
  }
  this.clearButton.disable();

  this.saveButton.controller = this;
  this.saveButton.action = function ()
  {
    //Frontend.saveDialog.openDialog((translate('MSG_SAVE') + ' ' + translate('MSG_INTEGRATED_MANAGEMENT_LOG')), 'iml', this.controller);
    this.controller.save();
  }
  this.saveButton.disable();

  this.addNoteButton.controller = this;
  this.addNoteButton.action = function ()
  {
    this.controller.promptToAddNote()
  }
  this.addNoteButton.disable();

  this.repairButton.controller = this;
  this.repairButton.action = function ()
  {
    this.controller.repairSelectedItems();
  }
  this.repairButton.disable();
  
  this.clearRequest.controller = this;
  this.clearRequest.callback = function ()
  {
    this.controller.refreshFrame();
  }

  this.addNoteRequest.controller = this;
  this.addNoteRequest.callback = function ()
  {
    this.controller.refreshFrame();
  }

  this.repairRequest.controller = this;
  this.repairRequest.callback = function ()
  {
    this.controller.refreshFrame();
  }
}

ImlLogController.prototype.refreshFrame = function refreshFrame()
{
  this.checkAllButton.disable();
  this.uncheckAllButton.disable();
  this.clearButton.disable();
  this.saveButton.disable();
  this.addNoteButton.disable();
  this.repairButton.disable();
  this.viewController.setParameter('sortField', this.sortField);
  this.viewController.setURL(this.viewURL);
}

ImlLogController.prototype.sortTable = function sortTable(column)
{
  this.sortField = column;
  this.refreshFrame();  
}

ImlLogController.prototype.promptToAddNote = function promptToAddNote()
{
  var controller = this;
  var dialog = Frontend.dialog;
  dialog.toggleBadge(false);
  dialog.setHeader(translate('MSG_INTEGRATED_MANAGEMENT_LOG'));
  dialog.toggleHeader(true);
  dialog.setContent(translate('MSG_ADD_MAINTENANCE_NOTE') + '<br><input type="text" id="addNoteInput" style="width: 90%" maxlength="218">');
  dialog.toggleContent(true);
  dialog.clearButtons();
  dialog.addButton(translate('MSG_POST_TO_IML'), null, function ()
  {
    dialog.hide();
    controller.addNote(getElement('addNoteInput').value);
  });
  dialog.addButton(translate('MSG_CANCEL'), null, function ()
  {
    dialog.hide();
  });
  dialog.toggleButtons(true);
  dialog.show();
  var input = getElement('addNoteInput');
  if (input)
    input.focus();
}

ImlLogController.prototype.addNote = function addNote(string)
{
  var request = this.addNoteRequest;
  request.clearVariables();
  request.addVariable('note', string);
  request.send();
}

ImlLogController.prototype.promptToClearLog = function promptToClearLog(title)
{
  var controller = this;
  var dialog = Frontend.dialog;
  dialog.toggleBadge(false);
  dialog.setHeader(title);
  dialog.toggleHeader(true);
  dialog.setContent(translate('MSG_CLEAR_LOG_CONFIRMATION'));
  dialog.toggleContent(true);
  dialog.clearButtons();
  dialog.addButton(translate('MSG_OK'), null, function ()
  {
    dialog.hide();
    controller.clearLog();
  });
  dialog.addButton(translate('MSG_CANCEL'), null, function ()
  {
    dialog.hide();
  });
  dialog.toggleButtons(true);
  dialog.show();
}

ImlLogController.prototype.clearLog = function clearLog()
{
  this.clearRequest.send();
}

ImlLogController.prototype.repairSelectedItems = function repairSelectedItems()
{
  var selected = this.viewController.getContentWindow().getSelectedCheckBoxes();
  var request = this.repairRequest;
  request.clearVariables();
  request.addVariable('items', selected.join(' '));
  request.send();
}

ImlLogController.prototype.appendSaveInfo = function appendSaveInfo(request)
{
  request.addVariable('sortField', this.sortField);
}

ImlLogController.prototype.save = function save()
{
  var header = (translate('MSG_SAVE') + ' ' + translate('MSG_INTEGRATED_MANAGEMENT_LOG'));
  if (CONFIG.IS_OFFLINE)
  {
    Frontend.saveDialog.openDialog(header, 'iml', this);
  }
  else
  {
    var query = 
    {
      attachment : 1,
      filename   : 'iml',
      sortField  : this.sortField
    }
    Frontend.clientSave(this.saveCommand, query, header);
  }
}