/********************************************************************
//        NAME- DataRetriever
// DESCRIPTION- Constructor for the DataRetriever class
//      PASSED- element (HTMLElement / string): the table element
//              that will contain the data from the datasource
//     RETURNS- 
//       NOTES- the DataRetriever encapsulates the controls for 
//              displaying and controlling data that is pulled from
//              the server
********************************************************************/
function LogTable(elementID)
{
  this.table = getElement(elementID);
  this.thead = extendElement(this.table.getElementsByTagName('thead')[0]);
  this.tbody = extendElement(this.table.getElementsByTagName('tbody')[0]);
  
  inherit(this, new DataRetriever(this.tbody));

  this.shadowBox = new ShadowBox(this, this.table.parentNode);
  
  this.init();
}

LogTable.prototype.init = function init()
{
  this.thead.hide();
  clearChildren(this.tbody);
  var tr = this.tbody.appendChild(newElement('tr'));
  tr.appendChild(newElement('td', {'class':'message','text':translate('MSG_LOADING')}));
}

LogTable.prototype.refresh = function refresh()
{
  var variables = this.variables;
  var numberOfVariables = variables.length;
  this.shadowBox.show();
  var request = new ServerRequest(this.dataSource);  
  request.controller = this;
  request.callback = function (data)
  {
    this.controller.receiveData(data);
    this.controller.shadowBox.hide();
  }
  for (var i=0; i<numberOfVariables; i++)
  {
    var variable = variables[i];
    request.addVariable(variable.name, variable.value);
  }
  request.send();
  return this;
}

LogTable.prototype.promptToClearLog = function promptToClearLog(title, controller)
{
  var dialog = Frontend.dialog;
  dialog.toggleBadge(false);
  dialog.setHeader(title);
  dialog.toggleHeader(true);
  dialog.setContent(translate('MSG_CLEAR_LOG_CONFIRMATION'));
  dialog.toggleContent(true);
  dialog.clearButtons();
  dialog.addButton(translate('MSG_OK'), null, function ()
  {
    dialog.hide();
    controller.clearLog();
  });
  dialog.addButton(translate('MSG_CANCEL'), null, function ()
  {
    dialog.hide();
  });
  dialog.toggleButtons(true);
  dialog.show();
}

LogTable.prototype.clearLog = function clearLog()
{
  if (this.clearCommand != undefined)
  {
    var request = new ServerRequest(this.clearCommand);
    request.controller = this;
    request.callback = function ()
    {
      this.controller.refresh();
    }
    request.send();
  }
}
