function MainTabController()
{
  inherit(this, TabController);

  // init all of the subtab TabControllers
  this.surveyTabs = new SurveyTabController();
  this.helpTabs   = new HelpTabController();
  this.logTabs    = new LogTabController();
  if (CONFIG.SURVEY_ONLY == false) // not survey only
    this.testTabs = new TestTabController();
  
  if (CONFIG.DIAGNOSIS_SUPPORT == true)
    this.diagnoseContent = getElement('diagnoseDeviceListScroller');

  this.init();
}

MainTabController.prototype.init = function init()
{
  // setup tabs
  this.addTab('survey', 'surveyTab', ['surveyView', 'surveyViewFooter'], [], '');
  this.addTab('status', 'statusTab', ['statusView'], ['statusFrameA', 'statusFrameB'], '');
  this.addTab('log', 'logTab', ['logView', 'logViewFooter'], [], '');
  this.addTab('help', 'helpTab', ['helpView'], [], '');
  if (CONFIG.DIAGNOSIS_SUPPORT)
  {
    this.addTab('diagnose', 'diagnoseTab', ['diagnoseView', 'diagnoseViewFooter'], [], 'diagnoseDeviceListScroller');
  }
  if (CONFIG.SURVEY_ONLY == false)
  {
    this.addTab('test', 'testTab', ['testView', 'testViewFooter'], [], '');
  }
  
  this.tabs.survey.addActivationAction(function(that)
  {
    that.controller.surveyTabs.reselectTab();
  });

  this.tabs.status.addActivationAction(function(that)
  {
    Frontend.statusController.resize();
  });

  this.tabs.log.addActivationAction(function(that)
  {
    that.controller.logTabs.reselectTab();
  });

  this.tabs.help.addActivationAction(function(that)
  {
    that.controller.helpTabs.reselectTab();
  });

  if (CONFIG.DIAGNOSIS_SUPPORT)
  {
    this.tabs.diagnose.addInitialAction(function(that)
    {
      Frontend.diagnoseController.refresh();
    });
  }
  
  if (!CONFIG.SURVEY_ONLY)
  {
    this.tabs.test.addActivationAction(function(that)
    {
      that.controller.testTabs.reselectTab();
    });
  }
  
  // initialize TabControllers
  this.surveyTabs.selectTab('currentConfig', false);
  this.helpTabs.selectTab('hpdiags', false);
  this.logTabs.selectTab('error', false);
  if (!CONFIG.SURVEY_ONLY)
  {
    this.testTabs.selectTab('quick', false);
  }

  this.selectTab('survey');
}
