if (CONFIG.IS_OFFLINE == true) // only create this save dialog if offline
{
  function SaveDialog()
  {
    inherit(this, new ModalElement(getElement('saveDialog')));
  
    this.scanCommand = 'commands/getSaveDevices.php';
  
    this.header = extendElement(getElement('saveDialogHeader'));
    this.filenameDiv = extendElement(getElement('saveDialogFilenameDiv'));
    this.filenameInput = extendElement(getElement('saveDialogFilename'));
    this.scanningMessage = extendElement(getElement('saveDialogScanningMessage'));
    this.selectMessage = extendElement(getElement('saveDialogSelectMessage'));
    this.locations = extendElement(getElement('saveDialogLocations'));
    this.saveButton = extendElement(getElement('saveDialogSaveButton'));
    this.cancelButton = extendElement(getElement('saveDialogCancelButton'));
    this.rescanButton = extendElement(getElement('saveDialogRescanButton'));
  
    this.noDevicesLabel = translate('MSG_NO_MEDIA_DEVICES_DETECTED_RESCAN');
    
    this.isVisible = false;
  
    this.init();
  }
  
  SaveDialog.prototype.init = function init()
  {
    this.saveButton.controller = this;
    this.saveButton.onclick = function ()
    {
      this.controller.save();
    }
  
    this.cancelButton.controller = this;
    this.cancelButton.onclick = function ()
    {
      this.controller.hide();
    }
  
    this.rescanButton.controller = this;
    this.rescanButton.onclick = function ()
    {
      this.controller.scanForDevices();
    }
  }
  
  SaveDialog.prototype.didShow = function didShow()
  {
    this.isVisible = true;
  }
  
  SaveDialog.prototype.didHide = function didHide()
  {
    this.isVisible = false;
  }
  
  SaveDialog.prototype.openDialog = function openDialog(title, filename, controller)
  {
    this.title = title;
    this.header.innerHTML = title;
    if (this.controller == undefined || this.controller != controller)
      this.filenameInput.value = filename;
    this.controller = controller;
    this.title = title;
    this.header.innerHTML = title;
  
    this.scanForDevices();
    this.show();
  }
  
  SaveDialog.prototype.scanForDevices = function scanForDevices()
  {
    this.filenameDiv.hide();
    this.saveButton.hide();
    this.rescanButton.hide();
    this.locations.hide();
    this.selectMessage.hide();
    this.scanningMessage.show();
    var request = new ServerRequest(this.scanCommand);
    request.controller = this;
    request.callback = function (data)
    {
      this.controller.receiveDevices(data);
    }
    request.send();
  }
  
  SaveDialog.prototype.receiveDevices = function receiveDevices(data)
  {
    if (this.isVisible)
    {
      this.rescanButton.show();
      var key = data.key;
      var devices = data.data;
      var numberOfDevices = devices.length;
      clearChildren(this.locations);
      if (numberOfDevices <= 0)
      {
        var li = this.locations.appendChild(newElement('li', {'class':'noSaveDevices', 'text':this.noDevicesLabel}));
        this.scanningMessage.hide();
        this.filenameDiv.hide();
        this.selectMessage.hide();
        this.saveButton.hide();
        this.cancelButton.show();
        this.locations.show();
      }
      else
      {
        this.key = key;
        this.data = devices;
        for (var i=0; i<numberOfDevices; i++)
        {
          var device = devices[i];
          var li = newElement('li');
          var name = device[key['name']];
          var device = device[key['devicePath']];
          var html = ('<label><input type="radio" name="saveLocation" value="' + device + '" /> ' + name + '</label>');
          li.innerHTML = html;
          this.locations.appendChild(li);
        }
        this.scanningMessage.hide();
        this.filenameDiv.show();
        this.saveButton.show();
        this.locations.show();
        this.selectMessage.show();
      }
      this.element.cloak();
      this.element.center();
      this.element.uncloak();
    }
  }
  
  SaveDialog.prototype.save = function save()
  {
    var locations = this.locations.getElementsByTagName('input');
    var numberOfLocations = locations.length;
    var selectedLocation = null;
    for (var i=0; i<numberOfLocations && selectedLocation == null; i++)
    {
      var location = locations[i];
      if (location.checked == true)
        selectedLocation = location.value;
    }
    var filename = this.filenameInput.value;
    if (selectedLocation == null)
    {
      this.inform(translate('MSG_PLEASE_SELECT_SAVE_LOCATION'));
    }
    else if (filename == '' || 
             filename == undefined ||
             filename.indexOf('/') >= 0 ||
             filename.indexOf('\\') >= 0 ||
             filename.indexOf('.') >= 0 ||
             filename.indexOf('\'') >= 0 ||
             filename.indexOf('"') >= 0)
    {
      this.inform(translate('MSG_BAD_FORMAT'));
    }
    else
    {
      var key = this.key;
      this.request = new ServerRequest(this.controller.saveCommand, 'GET');
      this.request.controller = this;
      this.request.addVariable('filename', filename);
      this.request.addVariable('devicePath', selectedLocation);
      this.controller.appendSaveInfo(this.request);
      this.request.callback = function (data)
      {
        this.controller.saveResponse(data);
      }
      this.request.send();
      this.inform(translate('MSG_SAVING'), false);
    }
  }
  
  SaveDialog.prototype.saveResponse = function saveResponse(response)
  {
    if (response == '0')
    {
      this.endInform();
      this.inform(translate('MSG_SAVE_SUCCESSFUL'), true, false);
    }
    else if (response.value != undefined)
    {
      if (response.value == "error:exists")
      {
        this.endInform()
        this.promptForOverwrite();      	
      }
      else
      {
        this.inform(translate('MSG_ERROR_WHILE_SAVING'), true, true);
      }
    }
    else
    {
      this.inform(translate('MSG_ERROR_WHILE_SAVING'), true, true);
    }
  }
  
  SaveDialog.prototype.inform = function inform(message, doIncludeButton, doShowSelfAfterDismiss)
  {
    doShowSelfAfterDismiss = (doShowSelfAfterDismiss == undefined) ? true : doShowSelfAfterDismiss;
    doIncludeButton = (doIncludeButton == undefined) ? true : doIncludeButton;
    var dialog = Frontend.dialog;
    if (this.title != undefined)
    {
      dialog.setHeader(this.title);
      dialog.toggleHeader(true);
    }
    else
    {
      dialog.toggleHeader(false);
    }
    dialog.toggleBadge(false);
    dialog.setContent(message);
    dialog.toggleContent(true);
    dialog.clearButtons();
    if (doIncludeButton)
    {
      dialog.addButton(translate('MSG_OK'), null, function ()
      {
        if (doShowSelfAfterDismiss)
          Frontend.saveDialog.show();
        Frontend.dialog.hide();
      });
      dialog.toggleButtons(true);
    }
    else
    {
      dialog.toggleButtons(false);
    }
    dialog.show();
    this.hide();
  }
  
  
  SaveDialog.prototype.promptForOverwrite = function promptForOverwrite()
  {
    var dialog = Frontend.dialog;
    if (this.title != undefined)
    {
      dialog.setHeader(this.title);
      dialog.toggleHeader(true);
    }
    else
    {
      dialog.toggleHeader(false);
    }
    dialog.toggleBadge(false);
    dialog.setContent(translate('MSG_OVERWRITE_FILE_YES_NO'));
    dialog.toggleContent(true);
    dialog.clearButtons();
    dialog.addButton(translate('MSG_OK'), null, function ()
    {
      Frontend.saveDialog.request.addVariable('overwrite', 'yes');
      Frontend.dialog.hide();
      Frontend.saveDialog.inform(translate('MSG_SAVING'), false);
      Frontend.saveDialog.request.send();
    });
    dialog.addButton(translate('MSG_CANCEL'), null, function ()
    {
      Frontend.dialog.hide();
      Frontend.saveDialog.show();
    });
    dialog.toggleButtons(true);
    dialog.show();
    this.hide();
  }
  
  SaveDialog.prototype.endInform = function endInform(doShowSelf)
  {
    if (doShowSelf)
      this.show();
    Frontend.dialog.hide();
  }
}
//*/