function ServerRequest(url, method, mode)
{
  this.blankFormURL = (CONFIG.BASE_URI + 'utils/blankForm.php');
  this.dummyPage = (CONFIG.BASE_URI + 'utils/dummy.html');
  
  this.url       = url || null;
  this.variables = [];
  this.method    = method || 'GET';
  this.callback  = null;
  this.request   = null;

  if (mode != undefined)
  {
    this.mode = mode;
  }
  else
  {
    if (CONFIG.IS_OFFLINE == true)
    {
      this.mode = 'iframe';
    }
    else
    {
      if (window.XMLHttpRequest)
      {
        this.mode = 'XMLHttpRequest';
      }
      else
      {
        this.mode = 'ActiveX'
      }
    }
  }

  this.init();
}

ServerRequest.prototype.init = function init()
{
  if (this.mode == 'iframe')
  {
    this.request = newElement('iframe', 
    {
      'controller': this,
      'src': this.dummyPage,
      'style':
      {
        'height': 0,
        'width': 0,
        'padding': 0,
        'margin': 0,
        'border': 'none'
      }
    });
    Body.element().appendChild(this.request);
  }
}

ServerRequest.prototype.addVariable = function addVariable(name, value)
{
  value = (value != null) ? value : '';
  this.variables.push(
  {
    'name': encodeQueryComponent(name),
    'value': encodeQueryComponent(value)
  });
  return this;
}

ServerRequest.prototype.removeVariable = function removeVariable(name)
{
  var foundVariable = false;
  var numberOfVariables = this.numberOfVariables;
  for (var i=0; i<numberOfVariables && foundVariable == false; i++)
  {
    if (this.variables[i].name == name)
    {
      this.variables.splice(i,1);
      foundVariable = true;
    }
  }
  return this;
}

ServerRequest.prototype.clearVariables = function clearVariables()
{
  this.variables = [];
  return this;
}

ServerRequest.prototype.getQueryString = function getQueryString()
{
  var flatArray = [];
  var numberOfVariables = this.variables.length;
  for (i=0; i<numberOfVariables; i++)
  {
    var name = this.variables[i].name;
    var value = this.variables[i].value;
    flatArray.push(name+'='+value);
  }
  //flatArray.push('r=' + Math.random());
  if (CONFIG.DEBUG_MODE == true)
    flatArray.push('debugMode=on');
  if (CONFIG.ADVANCED_MODE == true)
    flatArray.push('advancedMode=on');
  if (CONFIG.OVERRIDE_LANG != undefined)
    flatArray.push('overrideLang=' + CONFIG.OVERRIDE_LANG);
  if (CONFIG.OVERRIDE_IDRESULT != undefined)
    flatArray.push('overrideIdResult=' + CONFIG.OVERRIDE_IDRESULT);
  return flatArray.join('&');
}

ServerRequest.prototype.send = function send()
{
  switch(this.mode)
  {
  case ('iframe'):
    this.sendPseudoRequest();
    break;
  default:
    if (this.mode == 'XMLHttpRequest')
    {
      this.request = new XMLHttpRequest();
    }
    //else if (this.request.readyState == 4)
    else
    {
      try
      {
        this.request = new ActiveXObject('Msxml2.XMLHTTP');
      }
      catch (e)
      {
        this.request = new ActiveXObject('Microsoft.XMLHTTP');
      }
    }
    this.sendRequest();
  }
  return this;
}

ServerRequest.prototype.abort = function abort()
{
  if (this.mode == 'iframe')
  {
    this.request.onload = null;
    this.request.src = this.dummyPage;
  }
  else
  {
    this.request.abort();
  }
}

ServerRequest.prototype.sendRequest = function sendRequest()
{
  var query = this.getQueryString();
  var callback = this.statechange;
  var request = this.request;
  var controller = this;
  if (this.method == 'POST')
  {
    var url = (CONFIG.BASE_URI + this.url);
    request.open('POST', url, true);
    request.onreadystatechange = function()
    {
      callback(request, controller);
    }
    request.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    Frontend.heartbeat(function ()
    {
      request.send(query);
    });
  }
  else
  {
    var queryString = (query != '') ? ('?' + query) : '';
    var url = (CONFIG.BASE_URI + this.url + queryString);
    request.open('GET', url, true);
    request.onreadystatechange = function()
    {
      callback(request, controller);
    }
    request.setRequestHeader('If-Modified-Since', 'Sat, 1 Jan 2000 00:00:00 GMT'); // this avoids caching issues
    Frontend.heartbeat(function ()
    {
      request.send(null);
    });
  }
  return this;
}

ServerRequest.prototype.sendPseudoRequest = function sendPseudoRequest()
{
  this.request.onload = null;
  var callback = this.pseudoload;
  var request = this.request;
  var controller = this;
  //this.addVariable('r', Math.random()); // this avoids caching issues
  if (this.method == 'GET')
  {
    var query = this.getQueryString();
    var url = (CONFIG.BASE_URI + this.url + '?' + query);
    request.onload = function()
    {
      callback(request, controller);
    }
    request.src = url;
  }
  else
  {
    request.onload = function()
    {
      var variables = controller.variables;
      var numberOfVariables = variables.length;
      var form = request.contentWindow.document.getElementById('ui_blankForm');
      clearChildren(form);
      for (var i=0; i<numberOfVariables; i++)
      {
        var variable = variables[i];
        var input = form.appendChild(newElement('input',
        {
          'type': 'hidden',
          'name': decodeQueryComponent(variable.name),
          'value': decodeQueryComponent(variable.value)
        }));
      }
      form.method = 'POST';
      form.action = (CONFIG.BASE_URI + controller.url);
      request.onload = function()
      {
        callback(request, controller);
      }
      form.submit();
    }
    request.src = this.blankFormURL;
  }
}

ServerRequest.prototype.statechange = function statechange(request, controller)
{
  if (request.readyState == 4)
  {
    if (request.status && request.status == 200)
    {
      var response = controller.evaluateResponse(request.responseText);
      if (response !== false && 
          response != 'smh' && 
          controller.callback != undefined)
        controller.callback(response)
    }
    else
    {
      Frontend.reportError(('ServerRequest(' + controller.url + ') bad status: ' + request.status + ' ' + request.statusText), true);
    }
    request.onreadystatechange = function () {};
    request = null;
  }
  return 0;
}

ServerRequest.prototype.pseudoload = function pseudoload(request, controller)
{
  var response = controller.evaluateResponse(request.contentWindow.document.body.innerHTML);
  if (response !== false &&
      response != 'smh' &&
      controller.callback != undefined)
    controller.callback(response);
    this.request = null;
  return 0;
}

ServerRequest.prototype.evaluateResponse = function evaluateResponse(response)
{
  response = response.replace(/<pre>|<\/pre>/g, '');
  var evaluatedResponse = response;
  if (response.indexOf('System Management Homepage') >= 0)
  {
    if (window.sessionRefresher == undefined)
      window.sessionRefresher = new SMHSessionRefresher();
    sessionRefresher.pending = this;
    sessionRefresher.show();
    evaluatedResponse = 'smh';
  }
  else
  {
    if (response.indexOf('/*JSON') >= 0)
    {
      try
      {
        evaluatedResponse = eval(response);
      }
      catch(e)
      {
        evaluatedResponse = false;
      }
    }
  }
  window.lastServerRequest = this;
  window.lastServerResponse = evaluatedResponse;
  return evaluatedResponse;
}

ServerRequest.prototype.clone = function clone()
{
  var copy = new ServerRequest(this.url, this.method, this.mode);
  copy.variables = this.variables.clone();
  copy.callback = this.callback;
  return copy;
}
