/********************************************************************
//        NAME- ShadowBox2
// DESCRIPTION- Constructor of the ShadowBox2 object
//      PASSED- controller (Object): the controller of the ShadowBox2
//              parent (HTMLElement): the element that will contain
//                  the ShadowBox2. Defaults to Body
//     RETURNS- 
//       NOTES- The ShadowBox2 creates a semi-transparent veil over
//              its parent element and displays a 'Loading' box. This
//              renders the element un-clickable and signifies an
//              element-level modal operation
********************************************************************/
function ShadowBox2(controller, target, parent)
{
  this.controller = controller;
  this.parent = parent || target.parentNode || Body.element();
  this.target = target || Body.element();
  if (CONFIG.IS_LINUX)
    this.element = newElement('div', {'class':'blockingBox invisible'});
  else
    this.element = newElement('div', {'class':'shadowBox invisible'});
  this.messageBox = newElement('div', {'class':'shadowBoxMessage invisible', 'text':translate('MSG_LOADING')});
}

/********************************************************************
//        NAME- ShadowBox2.prototype.show
// DESCRIPTION- Makes the ShadowBox2 visible
//      PASSED- 
//     RETURNS- 
//       NOTES- Conforms the element to the size of its parentNode
//              and centers the messageBox to the element
********************************************************************/
ShadowBox2.prototype.show = function show()
{
  this.parent.appendChild(this.element);
  this.parent.appendChild(this.messageBox);
  this.element.conformTo(this.target);
  this.messageBox.centerTo(this.element);
  this.element.uncloak();
  this.messageBox.uncloak();
}

/********************************************************************
//        NAME- ShadowBox2.prototype.hide
// DESCRIPTION- Makes the ShadowBox2 invisible
//      PASSED- 
//     RETURNS- 
//       NOTES- Uses cloak() instead of hide() on elements in order
//              to retain their sizes between show()'s
********************************************************************/
ShadowBox2.prototype.hide = function hide()
{
  this.messageBox.cloak();
  this.element.cloak();
}
