/********************************************************************
//        NAME- StartupSplash
// DESCRIPTION- Constructor for the StartupSplash object
//      PASSED- 
//     RETURNS- 
//       NOTES- This is the splash screen presented upon startup of
//              the Frontend. A SystemIDController can be hooked into
//              it to display status of an initial System ID
********************************************************************/
function StartupSplash()
{
  this.customerSplash = 'images/startup_customer_splash.jpg';
  this.productName    = 'images/startup_productname.gif';
  this.logo           = 'images/startup_logo.gif';
  this.loading        = (translate('MSG_LOADING')+' '+translate('MSG_HP_INSIGHT_DIAGNOSTICS')+' ...');
  this.copyright      = (translate('MSG_COPYRIGHT')+' (c) 2010 Hewlett-Packard Development Company L.P.');
  //this.element        = new ContentView(newElement('div', {'class':'ui_startupSplash ui_invisible','id':'startupSplash'}));
  this.element        = newElement('div', {'class':'ui_startupSplash ui_hidden','id':'startupSplash'});

  this.showingProgressTable = false;

  this.draw();
  this.show();
}

/********************************************************************
//        NAME- StartupSplash.prototype.draw
// DESCRIPTION- Builds the HTMLElements needed to display the splash
//              screen
//      PASSED- 
//     RETURNS- 
//       NOTES- 
********************************************************************/
StartupSplash.prototype.draw = function draw()
{
  var element = this.element;
  var table = element.appendChild(newElement('table'));
  var tbody = table.appendChild(newElement('tbody'));
  var row1 = tbody.appendChild(newElement('tr'));
  var row2 = tbody.appendChild(newElement('tr'));
  var titleCell = row1.appendChild(newElement('td', {'class':'titleCell','rowSpan':2}));
  this.logoElement = titleCell.appendChild(newElement('img',  {'class':'logo', 'src':this.logo}));
  this.titleElement = titleCell.appendChild(newElement('img',  {'class':'name', 'src':this.productName, 'controller':this}));
  this.titleElement.onclick = function ()
  {
    this.controller.showProgressTable();
  }
  this.progressTable = titleCell.appendChild(newElement('table', {'id':'startupProgressTable','class':'ui_hidden linedTable'}));
  this.progressTbody = this.progressTable.appendChild(newElement('tbody'));
  this.copyrightElement = titleCell.appendChild(newElement('span', {'class':'copy', 'text':this.copyright }));
  var customerCell = row1.appendChild(newElement('td', {'class':'customer'}));
  customerCell.innerHTML = '&nbsp;';
  var progressCell = row2.appendChild(newElement('td', {'class':'progress'}));
  progressCell.appendChild(newElement('span', {'class':'loading', 'text':this.loading}));
  progressCell.appendChild(newElement('br'));
  this.progressMessage = progressCell.appendChild(newElement('span', {'class':'message'}));
  this.progressBar = new ProgressBar().draw(progressCell);
  Body.element().appendChild(this.element);
  return this;
}

/********************************************************************
//        NAME- StartupSplash.prototype.show
// DESCRIPTION- Displays the splash screen
//      PASSED- 
//     RETURNS- 
//       NOTES- Automatically stretches the splash screen to the
//              height of the Viewport
********************************************************************/
StartupSplash.prototype.show = function show()
{
  this.element.setHeight(Viewport.getHeight());
  removeClass(this.element, 'ui_hidden');
  return this;
}

/********************************************************************
//        NAME- StartupSplash.prototype.hide
// DESCRIPTION- Hides the splash screen
//      PASSED- 
//     RETURNS- 
//       NOTES- 
********************************************************************/
StartupSplash.prototype.hide = function hide()
{
  addClass(this.element, 'ui_hidden');
  return this;
}

/********************************************************************
//        NAME- StartupSplash.prototype.setMessage
// DESCRIPTION- Sets the 'status message' to value
//      PASSED- value (string): the value to set the status message
//     RETURNS- 
//       NOTES- 
********************************************************************/
StartupSplash.prototype.setMessage = function setMessage(value)
{
  clearChildren(this.progressMessage)
  this.progressMessage.appendChild(newText(value));
  return this;
}

StartupSplash.prototype.showProgressTable = function showProgressTable()
{
  this.titleElement.hide();
  this.logoElement.hide();
  this.copyrightElement.hide();
  this.progressTable.show();
  this.showingProgressTable = true;
}
