function Tab(tabName, tabElement, contentElements, viewElements, resizer, controller)
{
  this.name = tabName;
  this.controller = controller;
  this.activationActions = [];
  this.initialActions = [];

  this.isActive = false;
  this.isDisabled = false;
  this.isInitialized = false;

  this.tabElement = resolveElement(tabElement); // visual element that selects this tab
  this.contentElements = []; // the elements that should become visible when this tab is activated
  for (var i=0, count=contentElements.length; i<count; i++)
    this.contentElements.push(extendElement(resolveElement(contentElements[i])));
  this.viewElements = []; // the elements that should be hidden until all the content elements are visible
  for (var i=0, count=viewElements.length; i<count; i++)
    this.viewElements.push(extendElement(resolveElement(viewElements[i])));
  this.resizer = resizer; // the element that should be used to resize the window

  this.init();
}

Tab.prototype.init = function init()
{
  var tabName = this.name;
  var tabBar = this.controller;
  this.tabElement.controller = this;
  this.tabElement.onselectstart = function ()
  {
    return false;
  }
  this.tabElement.unselectable = 'on';
  this.tabElement.onclick = function ()
  {
    tabBar.selectTab(tabName);
  }
  this.tabElement.onmouseover = function ()
  {
    if (this.controller.isDisabled != true && this.controller.isActive != true)
      addClass(this, 'hover');
  }
  this.tabElement.onmouseout = function ()
  {
    removeClass(this, 'hover');
  }
  return this;
}

Tab.prototype.makeActive = function makeActive(doActions)
{
  if (this.shouldActivate())
  {
    this.willActivate();
    var contentElements = this.contentElements;
    var count = contentElements.length;
    for (var i=0; i<count; i++)
    {
      contentElements[i].show();
    }
    if (this.resizer != undefined && this.resizer != '')
    {
      if (this.resizer.resize != undefined)
        this.resizer.resize();
      else
        Body.adjustToViewport(resolveElement(this.resizer));
    }

    this.didActivate(doActions);
    return true;
  }
  else
  {
    return false;
  }
}

Tab.prototype.shouldActivate = function shouldActivate()
{
  return (!this.isDisabled);
}

Tab.prototype.willActivate = function willActivate()
{
  addClass(this.tabElement, 'active');
  var views = this.viewElements;
  var count = views.length;
  for (var i=0; i<count; i++)
  {
    views[i].cloak();
  }
}

Tab.prototype.didActivate = function didActivate(doActions)
{
  var views = this.viewElements;
  var count = views.length;
  for (var i=0; i<count; i++)
  {
    views[i].uncloak();
  }
  if (doActions !== false)
  {
    if (this.isInitialized === false)
    {
      var initialActions = this.initialActions;
      var count = initialActions.length;
      for (var i=0; i<count; i++)
        this.initialActions[i](this);
      this.isInitialized = true;
    }
    var actions = this.activationActions;
    var count = actions.length;
    for (var i=0; i<count; i++)
      actions[i](this);
  }
  this.isActive = true;
}

Tab.prototype.makeInactive = function makeInactive()
{
  if (this.shouldDeactivate())
  {
    this.willDeactivate();
    var contentElements = this.contentElements;
    var count = contentElements.length;
    for (var i=0; i<count; i++)
      contentElements[i].hide();
    this.didDeactivate();
    return true;
  }
  else
  {
    return false;
  }
}

Tab.prototype.shouldDeactivate = function shouldDeactivate()
{
  return true;
}

Tab.prototype.willDeactivate = function willDeactivate()
{
  removeClass(this.tabElement, 'active');
}

Tab.prototype.didDeactivate = function didDeactivate()
{
  this.isActive = false;
}

Tab.prototype.makeDisabled = function makeDisabled()
{
  if (this.shouldDisable())
  {
    this.willDisable();
    this.didDisable();
    return true;
  }
  else
  {
    return false;
  }
}

Tab.prototype.shouldDisable = function shouldDisable()
{
  return (!this.isDisabled);
}

Tab.prototype.willDisable = function willDisable()
{
  removeClass(this.tabElement, 'active');
  addClass(this.tabElement, 'disabled');
}

Tab.prototype.didDisable = function didDisable()
{
  this.isDisabled = true;
}

Tab.prototype.makeEnabled = function makeEnabled()
{
  if (this.shouldEnable())
  {
    this.willEnable();
    this.didEnable();
    return true;
  }
  else
  {
    return false;
  }
}

Tab.prototype.shouldEnable = function shouldEnable()
{
  return this.isDisabled;
}

Tab.prototype.willEnable = function willEnable()
{
  removeClass(this.tabElement, 'disabled');
}

Tab.prototype.didEnable = function didEnable()
{
  this.isDisabled = false;
}

Tab.prototype.addActivationAction = function addActivationAction(action)
{
  this.activationActions.push(action);
  return this;
}

Tab.prototype.addInitialAction = function addInitialAction(action)
{
  this.initialActions.push(action);
  return this;
}

Tab.prototype.reinitialize = function reinitialize()
{
  var actions = this.initialActions;
  var count = actions.length;
  for (var i=0; i<count; i++)
    actions[i](this);
  this.isInitialized = true;
  return this;
}
