function TestTabController()
{
  inherit(this, TabController);

  this.customTestScroller      = extendElement(getElement('customTestListScroller'        ));
  this.customParameterScroller = extendElement(getElement('customTestParameterScroller'   ));

  this.init();
}

TestTabController.prototype.init = function init()
{
  // setup tabs
  this.addTab('quick', 'quickTestTab', ['quickTestView', 'quickTestViewFooter'], [], 'quickTestDeviceListScroller');
  this.addTab('complete', 'completeTestTab', ['completeTestView', 'completeTestViewFooter'], [], 'completeTestDeviceListScroller');
  this.addTab('custom', 'customTestTab', ['customTestView', 'customTestViewFooter'], []);

  this.tabs.quick.addInitialAction(function(that)
  {
    Frontend.quickTests.refresh();
  });

  this.tabs.complete.addInitialAction(function(that)
  {
    Frontend.completeTests.refresh();
  });
  // setup custom tab actions
  this.tabs.custom.addActivationAction(function(that)
  {
    var size = Body.adjustToViewport(that.controller.customTestScroller);
    that.controller.customParameterScroller.style.height = (that.controller.customTestScroller.style.height);
  });
  this.tabs.custom.addInitialAction(function(that)
  {
    Frontend.customTests.refresh();
  });
}
