/********************************************************************
//        NAME- Timer
// DESCRIPTION- Constructor for the Timer object
//      PASSED- executionTime (number): the number of milliseconds
//                  the timer should wait between activations
//              callback (Function): the function to call when the
//                  timer activates
//              repeat (boolean): if set to true, the timer will
//                  re-start itself after every activation until 
//                  recieving a stop() command
//     RETURNS- 
//       NOTES- This is an encapsulation of the setTimeout() function
//              that allows greater control and re-usability
********************************************************************/
function Timer(executionTime, callback, repeat)
{
  this.callback      = callback || function () {};
  this.repeat        = repeat || false;
  this.executionTime = executionTime || 1000;
  this.running       = false;
}

/********************************************************************
//        NAME- Timer.prototype.start
// DESCRIPTION- Starts the timer, once it reaches its executionTime,
//              it calls its callback function
//      PASSED- 
//     RETURNS- 
//       NOTES- 
********************************************************************/
Timer.prototype.start = function start()
{
  var that = this;
  this.running = true;
  this.timeout = setTimeout(function () {that.activate();}, this.executionTime);
  return this;
}

/********************************************************************
//        NAME- Timer.prototype.stop
// DESCRIPTION- Stops the timer. Any timeout that was running is 
//              aborted with clearTimeout and does not execute
//      PASSED- 
//     RETURNS- 
//       NOTES- 
********************************************************************/
Timer.prototype.stop = function stop()
{
  if (this.timeout != undefined)
  {
    clearTimeout(this.timeout);
    this.timeout = null;
    this.running = false;
  }
  return this;
}

/********************************************************************
//        NAME- Timer.prototype.activate
// DESCRIPTION- Called by the timer's timeout, this calls the
//              callback function
//      PASSED- 
//     RETURNS- 
//       NOTES- After calling the callback function, this checks to
//              see if it needs to repeat, if so it calls start()
********************************************************************/
Timer.prototype.activate = function activate()
{
  this.callback();
  if (this.running == true && this.repeat == true)
    this.start();
  return this;
}
