<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  include_once '../includes/globals.php';
  include_once '../includes/parseSurvey.php';
  include_once '../includes/aibridge.class.php';

  if (isset($_GET['processID']))
    $processID = $_GET['processID'];
  else
    $processID = 0;

  $stdout = AIBridge::getProcessResult($processID);

  $document = new XMLDocument($stdout);
  $root = $document->document_element();
  $xpath = xpath_new_context($root);

  outputViewHeader();
  echo '<script type="text/javascript" src="../js/lib.js"></script>';
  echo '<script type="text/javascript" src="js/catalogResult.js"></script>';
  echo '</head>';
  echo ('<body onload="init(' . ((DEBUG_MODE === true) ? 'true' : 'false') . ');">');
  echo '<table class="config" id="testComponents">';
  echo '<tbody>';

  $components = @ xpath_eval($xpath, '/diagOutput/catResult');

  if ($processID == 0)
  {
    echo '<tr class="message"><td>PROCESS ID MISSING</td></tr>';
  }
  else
  {
    foreach ($components->nodeset as $component)
      drawComponent($component);
  }
  
  echo '</tbody>';
  echo '</table>';
  outputViewFooter();

  function drawComponent(&$component)
  {
    $name = $component->get_attribute('component');
    echo '<tr class="header">';
    echo "<th colspan=\"2\">$name</th>";
    echo '</tr>';
    $xpath = xpath_new_context($component);
    $devices = @ xpath_eval($xpath, '/device');
    foreach ($devices->nodeset as $device)
      drawDevice($device);
  }

  function drawDevice(&$device)
  {
    $name = $device->get_attribute('caption');
    echo '<tr>';
    echo "<th colspan=\"2\">$name</th>";
    echo '</tr>';
    $xpath = xpath_new_context($device);
    $tests = @ xpath_eval($xpath, '/test');
    foreach ($tests->nodeset as $test)
      drawTest($test);
  }

  function drawTest(&$test)
  {
    $name = $test->get_attribute('caption');
    $description = $test->get_attribute('description');
    echo '<tr>';
    echo "<th style=\"padding-left:15px;\">$name</th>";
    echo "<td>$description</td>";
    echo '</tr>';
    $xpath = xpath_new_context($test);
    $parameters = @ xpath_eval($xpath, '/parameter');
    foreach ($parameters->nodeset as $parameter)
      drawParameter($parameter);
  }

  function drawParameter(&$parameter)
  {
    $name = $parameter->get_attribute('caption');
    $description = $parameter->get_attribute('description');
    echo '<tr>';
    echo "<td style=\"padding-left:30px;\">$name</td>";
    echo "<td style=\"padding-left:15px;\">$description</td>";
    echo '</tr>';
  }
  //*/
?>
