DIAGS=/opt/hp/hpdiags
LIBS=/lib64
USRLIBS=/usr/lib

ln -sf $DIAGS/libmdacommon.so $LIBS/libmdacommon.so
ln -sf $DIAGS/libbmapi_x64.so $LIBS/libbmapi_x64.so
ln -sf $DIAGS/libbmapi_x64.so $LIBS/libbmapi_x64.so.6
ln -sf $DIAGS/libcpqipmb.so $LIBS/libcpqipmb.so
ln -sf $DIAGS/libcpqipmb.so $LIBS/libcpqipmb.so.1

# we want to load the EHCI driver so the USB tc can detect if it is 1.0 or 2.0, BUT
# first check if /dev/cdrom is really /dev/scd0 or /dev/sr0 - this means it is USB,
# and loading the ehci driver can mess things up if we are currently booted from that CDROM
CDROM="/dev/cdrom"
DEVICE="`ls -l $CDROM 2>/dev/null | grep s[cr]`" 
KERNEL_26=""
DRIVER_NAME=hpdvmkd
case $(uname -r) in 2.6.*) KERNEL_26="true" ;; esac

#echo $DEVICE

if [ -z "$DEVICE" ]; then
  # we are not booted from the USB CD-ROM
  if [ -n "$KERNEL_26" ] ; then
    # we are in a 2.6 kernel environment
    modprobe ohci-hcd 
    modprobe uhci-hcd
  fi
  modprobe ehci-hcd
fi


if [ -n "$KERNEL_26" ] ; then
  DRIVER=$DRIVER_NAME.ko
else
  DRIVER=$DRIVER_NAME.o
fi



modprobe parport_pc

# installing OpenIPMI drivers
modprobe ipmi_si
modprobe ipmi_devintf
modprobe ipmi_msghandler

