<?php
  header('Content-type: text/plain', true);

  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Call AI
  $stdout = AIBridge::getSurveyList();

  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    if ($document->tagname() == 'error') // If AI returned an error:
    {
      $outputArray = array(
        'name'  => 'AI Error',
        'value' => $document->get_content());
      die(Rosetta::arrayToJSON($outputArray));
    }
  }
  else
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

  // Create associative array of surveyFile's
  $xpath = xpath_new_context($document);
  $surveyFiles = @ xpath_eval($xpath, '/surveyFile');
  $key = array(
    'filename'  => 'f',
    'timestamp' => 't');
  $capturedConfigs = array();
  $capturedConfigs['key'] = $key;
  $capturedConfigs['data'] = array();
  foreach ($surveyFiles->nodeset as $surveyFile)
  {
    $fileArray = array();
    $fileArray[$key['filename']] = $surveyFile->get_attribute('filename');
    $fileArray[$key['timestamp']] = $surveyFile->get_attribute('timeStampCaption');
    $capturedConfigs['data'][] = $fileArray;
  }
  exit(Rosetta::arrayToJSON($capturedConfigs));
  //*/
?>
