<?php
  header('Content-type: text/plain', true);

  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  $xml = new XMLDocument(file_get_contents(IDRESULT_PATH));
  if (!$xml)
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

  $diagnosableDevices = array();
  $diagnosableDevices["diagnosable"] = array();
  $diagnosableDevices["notDiagnosable"] = array();
  $xpath = xpath_new_context($xml->document_element());
  $diagnosables = @ xpath_eval($xpath, '/diagOutput/category/device[@diagnosable="1"]');
  foreach ($diagnosables->nodeset as $device)
  {
    $deviceArray = array();
    $deviceArray['name'] = $device->get_attribute('name');
    $deviceArray['caption'] = $device->get_attribute('caption');
    $diagnosableDevices["diagnosable"][] = $deviceArray;
  }
  $notDiagnosables = @ xpath_eval($xpath, '/diagOutput/category/device[@potentiallyDiagnosable="1" and @diagnosable!="1"]');
  foreach ($notDiagnosables->nodeset as $device)
  {
    $deviceArray = array();
    $deviceArray['name'] = $device->get_attribute('name');
    $deviceArray['caption'] = $device->get_attribute('caption');
    $diagnosableDevices["notDiagnosable"][] = $deviceArray;
  }

  // Output JSON object
  exit(Rosetta::arrayToJSON($diagnosableDevices));
  //*/
?>
