<?php
  header('Content-type: text/plain', true);

  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Call AI
  $stdout = AIBridge::getDiagnosisLog();

  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    if ($document->tagname() == 'error') // If AI returned an error:
    {
      $outputArray = array(
        'name'  => 'AI Error',
        'value' => $document->get_content());
      die(Rosetta::arrayToJSON($outputArray));
    }
  }
  else
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

  // Create associative array of pertinent diagnosislog info
  $key = array(
    'caption' => 'c',
    'time'    => 't',
    'total'   => 'o',
    'failed'  => 'f');
  $diagnosisLogArray = array();
  $diagnosisLogArray['key']  = $key;
  $diagnosisLogArray['data'] = array();
  $xpath = xpath_new_context($document);
  $records = @ xpath_eval($xpath, '/diagnosisLogRecord');
  foreach ($records->nodeset as $record)
  {
    $recordArray = array();
    $recordArray[$key['caption']] = $record->get_attribute('diagnosisCaption');
    $recordArray[$key['time']] = $record->get_attribute('testTime');
    $recordArray[$key['failed']] = $record->get_attribute('failedCount') || '0';
    $recordArray[$key['total']] = ($recordArray[$key['failed']] + $record->get_attribute('passedCount'));
    $diagnosisLogArray['data'][] = $recordArray;
  }
  // Output JSON object
  exit(Rosetta::arrayToJSON($diagnosisLogArray));
  //*/
?>