<?php
//  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  header('Content-type: text/plain', true);

  // get all error xml files
  chdir(DIAGS_DIRECTORY);
  $errorFiles = glob('*.err.xml');

  $key = array(
    'device'  => 'd',
    'test'    => 't',
    'code'    => 'c',
    'message' => 'm',
    'repair'  => 'r');
  $errorCodes = array();
  $errorCodes['key'] = $key;
  $errorCodes['data'] = array();
  foreach($errorFiles as $filename)
  {
    $filepath = (DIAGS_DIRECTORY . $filename);
    // Try to make file into a XMLDocument
    $xml = @ new XMLDocument(file_get_contents($filepath));
    if ($xml)
    {
      $document = $xml->document_element();
    }
    else
    {
      $outputArray = array(
        'name'  => 'XML Error',
        'value' => $filepath);
      die(Rosetta::arrayToJSON($outputArray));
    }
    $xpath = xpath_new_context($document);
    $devices = xpath_eval($xpath, '/device');
    foreach($devices->nodeset as $device)
    {
      $deviceName = $device->get_attribute('caption');
      $xpath = xpath_new_context($device);
      $tests = xpath_eval($xpath, '/test');
      foreach($tests->nodeset as $test)
      {
        $testName = $test->get_attribute('caption');
        $xpath = xpath_new_context($test);
        $errors = xpath_eval($xpath, '/error');
        foreach($errors->nodeset as $error)
        {
          $errorArray = array();
          $errorArray[$key['device']] = $deviceName;
          $errorArray[$key['test']] = $testName;
          $code = $error->get_attribute('code');
          $errorArray[$key['code']] = $code;
          $messageName = $error->get_attribute('message');
          $repairName = $error->get_attribute('repair');
          if ($filepath == 'sdl.err.xml')
            $messageValue = translate('MSG_NOT_APPLICABLE');
          else
            $messageValue = translate('MSG_UNDEFINED');
          $xpath = xpath_new_context($document);
          $messageElements = xpath_eval($xpath, ('/message[@name="' . $messageName . '"]'));
          if (count($messageElements->nodeset) > 0)
            $messageValue = $messageElements->nodeset[0]->get_content(); // if we found message elements, we only look at the first one
          $repairElements = xpath_eval($xpath, ('/repair[@name="' . $repairName . '"]'));
          if (count($repairElements->nodeset) > 0)
            $repairValue = $repairElements->nodeset[0]->get_content();
          else
            $repairValue = translate('MSG_UNDEFINED');
          $errorArray[$key['message']] = $messageValue;
          $errorArray[$key['repair']] = $repairValue;
          $errorCodes['data'][$code] = $errorArray;
        }
      }
    }
  }
  ksort($errorCodes['data'], SORT_STRING); // sort the array by key
  $errorCodes['index'] = Rosetta::arrayToJSON(array_keys($errorCodes['data']), true); // make an index with the keys
  exit(Rosetta::arrayToJSON($errorCodes, false, true));
  //*/
?>
