<?php
  header('Content-type: text/plain', true);

  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Check for ID result
  if (!file_exists(IDRESULT_PATH))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'idResult missing');
    die(Rosetta::arrayToJSON($outputArray));
  }

  if (isset($_GET['mode']))
    $mode = $_GET['mode'];
  else
    $mode = 'quick';
  
  // Make ID result into a XMLDocument
  $xml = new XMLDocument(file_get_contents(IDRESULT_PATH));
  $xpath = xpath_new_context($xml->document_element());
  $deviceNodes = @ xpath_eval($xpath, '/diagOutput/category/device');
  // Setup tests array
  $tests = array();
  $key = array(
    'interactiveOnly'  => 2,
    'mixedInteractive' => 1,
    'unattendedOnly'   => 0,
    'name'             => 'n',
    'component'        => 'C',
    'caption'          => 'c',
    'isBusy'           => 'b',
    'description'      => 'd',
    'interactivity'    => 'i',
    'needsMedia'       => 'm');
  $tests['key']  = $key;
  $tests['data'] = array();
  // Get information on each device
  foreach($deviceNodes->nodeset as $device)
  {
    $deviceXpath   = xpath_new_context($device);
    // Get all of the interactive tests
    $interactiveTests = @ xpath_eval($deviceXpath, '/test[@' . $mode . '="1" and @fieldtest="1" and @interactive="1" and (../@component!="cdm" or @package="1")]');
    if (count($interactiveTests->nodeset) <= 0)
      $interactiveTests = @ xpath_eval($deviceXpath, '/test[@' . $mode . '="1" and @fieldtest="1" and @interactive="1"]');
    // Get all of the unattended tests
    $unattendedTests = @ xpath_eval($deviceXpath, '/test[@' . $mode . '="1" and @fieldtest="1" and @interactive="0" and (../@component!="cdm" or @package="1")]');
    if (count($unattendedTests->nodeset) <= 0)
      $unattendedTests = @ xpath_eval($deviceXpath, '/test[@' . $mode . '="1" and @fieldtest="1" and @interactive="0"]');
    // Determine how many of each type of test exist in this device
    $numberOfInteractiveTests = count($interactiveTests->nodeset);
    $numberOfUnattendedTests  = count($unattendedTests->nodeset);
    $testCount = $numberOfInteractiveTests + $numberOfUnattendedTests;
    // Only continue if the device contains appropriate tests
    if ($testCount > 0)
    {
      $deviceArray = array();
      $deviceArray[$key['name']]      = $device->get_attribute('name');
      $deviceArray[$key['component']] = $device->get_attribute('component');
      $deviceArray[$key['caption']]   = $device->get_attribute('caption');
      $deviceArray[$key['isBusy']]    = 
        ($device->get_attribute('listWithoutTests') == '1') 
        ? true 
        : false;
      // Description depends on isBusy status
      $deviceArray[$key['description']] = 
        ($deviceArray[$key['isBusy']])
        ? $device->get_attribute('listWithoutTestsCaption')
        : $device->get_attribute('description');
      // Set the interactivity level based on the numbers of interactive and unattended tests:
      //   Both Interactive and Unattended tests = mixedInteractive
      //   Only Interactive tests = interactiveOnly
      //   Only Unattended tests = unattendedOnly
      if ($numberOfInteractiveTests > 0 && $numberOfUnattendedTests > 0)
        $deviceArray[$key['interactivity']] = $key['mixedInteractive'];
      else if ($numberOfInteractiveTests > 0)
        $deviceArray[$key['interactivity']] = $key['interactiveOnly'];
      else if ($numberOfUnattendedTests > 0)
        $deviceArray[$key['interactivity']] = $key['unattendedOnly'];
      else
        $deviceArray[$key['interactivity']] = -1;
      // Check to see if the device has any tests that require media
      $testsNeedingMedia = @ xpath_eval($deviceXpath, '/test[@requiresMedia="1"]');
      if (count($testsNeedingMedia->nodeset) > 0)
        $deviceArray[$key['needsMedia']] = true;
      else
        $deviceArray[$key['needsMedia']] = false;
      $tests['data'][] = $deviceArray;
    } 
  }
  exit(Rosetta::arrayToJSON($tests));

/*
if (count($deviceInteractiveTests->nodeset) > 0 || count($deviceUnattendedTests->nodeset) > 0)
  $listItems .= "<li class=\"ui_treeListLeaf".$modeClass." ui_value_".$deviceName."\">".$deviceCaption.": ".$deviceDescription.$modeSuffix."</li>\n";
//*/
?>
