<?php
header('Content-type: text/plain', true);

define('IS_ATTACHMENT', (isset($_GET['attachment']) && $_GET['attachment'] == 1));

include_once '../includes/aibridge.class.php';
include_once '../includes/globals.php';
include_once '../includes/rosetta.class.php';
include_once '../includes/filesaver.class.php';
include_once '../includes/fileprompter.class.php';

// Check for required parameters
if (IS_ATTACHMENT)
{
  if (!requiredParameters('filename'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  FilePrompter::prepareForSaving();
}
else
{
  if (!requiredParameters('devicePath', 'filename'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  // See if file exists
  if ((!isset($_GET['overwrite']) || $_GET['overwrite'] != 'yes') &&
      FileSaver::doesFileExist($_GET['filename'], 'html', $_GET['devicePath']))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'error:exists');
    die(Rosetta::arrayToJSON($outputArray));
  }
}

// Call AI
$stdout = AIBridge::getDiagnosisLog();

// Try to make stdout into a XMLDocument
$xml = new XMLDocument($stdout);
if ($xml)
{
  $document = $xml->document_element();
  if ($document->tagname() == 'error') // If AI returned an error:
  {
    $outputArray = array(
      'name'  => 'AI Error',
      'value' => $document->get_content());
    die(Rosetta::arrayToJSON($outputArray));
  }
  $xpath = xpath_new_context($document);
  $records = @ xpath_eval($xpath, '/diagnosisLogRecord');
}
else
{
  $outputArray = array(
    'name'  => 'XML Error',
    'value' => $stdout);
  die(Rosetta::arrayToJSON($outputArray));
}

// Output HTML
$computerName = getComputerName();
$buildVersion = getBuildVersion();
$html = array();

$html[] = '<html>';
$html[] = '<head>';
$html[] = '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">';
$html[] = '<title>' . $computerName . ' - ' . translate('MSG_DIAGNOSIS_LOG') . '</title>';
$html[] = includeStyleSheet('diagnosisLogStyle.css');
$html[] = '</head>';
$html[] = '<body>';

if ($buildVersion != '')
  $html[] = ('<i>HP Insight Diagnostics ' . translate('MSG_VERSION') . ' ' . $buildVersion . '</i><br>');

if ($computerName != '')
  $html[] = (translate('MSG_COMPUTER_NAME') . ': <b>' . $computerName . '</b>');

if (count($records->nodeset) > 0)
{
  $html[] = '<table class="i">';
  $html[] = '<tr>';
  $html[] = ('<td class="p"><span>' . translate('MSG_PASSED') . '</span></td>');
  $html[] = ('<td> - ' . translate('MSG_DENOTES_PASSED_TESTS') . '</td>');
  $html[] = '</tr>';
  $html[] = '<tr>';
  $html[] = ('<td class="w"><span>' . translate('MSG_WARNING') . '</span></td>');
  $html[] = ('<td> - ' . translate('MSG_DENOTES_TESTS_WITH_WARNINGS') . '</td>');
  $html[] = '</tr>';
  $html[] = '<tr>';
  $html[] = ('<td class="f"><span>' . translate('MSG_FAILED') . '</span></td>');
  $html[] = ('<td> - ' . translate('MSG_DENOTES_FAILED_TESTS') . '</td>');
  $html[] = '</tr>';
  $html[] = '</table>';
}
  
$html[] = '<table>';

if (count($records->nodeset) <= 0)
{
  $html[] = '<tr class="m">';
  $html[] = ('<td>' . translate('MSG_DIAGNOSIS_LOG') . ' ' . translate('MSG_IS_EMPTY') . '</td>');
  $html[] = '<tr>';
}
else
{
  $html[] = '<thead>';
  $html[] = '<tr>';
  $html[] = '<td>&nbsp;</td>';
  $html[] = ('<td>' . translate('MSG_DEVICE') . ', ' . translate('MSG_TEST') . '</td>');
  $html[] = ('<td class="c">' . translate('MSG_NUMBER_OF_TIMES_DIAGNOSED') . '</td>');
  $html[] = ('<td class="c">' . translate('MSG_FAILED') . ' ' . translate('MSG_COUNT') . '</td>');
  $html[] = ('<td class="c">' . translate('MSG_PASSED_WITH_WARNINGS') . ' ' . translate('MSG_COUNT') . '</td>');
  $html[] = ('<td class="r">' . translate('MSG_DIAGNOSIS_TIME') . '</td>');
  $html[] = '</tr>';
  $html[] = '</thead>';
  $html[] = '<tbody>';

  foreach ($records->nodeset as $record)
  {
    $test = $record->get_attribute('diagnosisCaption');
    $passedCount = $record->get_attribute('passedCount');
    $warningCount = $record->get_attribute('passedWithWarningsCount');
    $failedCount = $record->get_attribute('failedCount');
    $numberOfTests = ($passedCount + $warningCount + $failedCount);
    $time = $record->get_attribute('testTime');
    if ($failedCount > 0)
    {
      $result = 'failed';
      $resultCaption = translate('MSG_FAILED');
      $resultClass = ' class="f"';
    }
    else if ($warningCount > 0)
    {
      $result = 'warned';
      $resultCaption = translate('MSG_WARNING');
      $resultClass = ' class="w"';
    }
    else
    {
      $result = 'passed';
      $resultCaption = translate('MSG_PASSED');
      $resultClass = ' class="p"';
    }

    $html[] = ('<tr>');
    $html[] = ('<td' . $resultClass . '><span>' . $resultCaption . '</span></td>');
    $html[] = ('<td>' . $test . '</td>');
    $html[] = ('<td class="c">' . $numberOfTests . '</td>');
    $html[] = ('<td class="c">' . $failedCount . '</td>');
    $html[] = ('<td class="c">' . $warningCount . '</td>');
    $html[] = ('<td class="r">' . $time . '</td>');
    $html[] = '</tr>';

    $diagnosisResults = getDiagnosisResults($record);
    foreach ($diagnosisResults as $diagnosisResult)
    {
      generateErrorTable($diagnosisResult, $html);
      $innerResults = getDiagnosisResults($diagnosisResult);
      if (count($innerResults) > 0)
      {
        foreach ($innerResults as $innerResult)
          generateErrorTable($innerResult, $html);
      }
    }
  }
  $html[] = '</tbody>';
}

$html[] = '</table>';
$html[] = '</body>';
$html[] = '</html>';

if (IS_ATTACHMENT)
{
  $filename = ($_GET['filename'] . ".html");
  FilePrompter::promptForSave($filename, $html, 'text/html');
}
else
{
  $filename = $_GET["filename"];
  $extension = "html";
  $devicePath = $_GET["devicePath"];
  
  $saveResult = FileSaver::saveArrayToFile($filename, $extension, $devicePath, $html);
  if ($saveResult == 'success')
  {
    exit('0');
  }
  else
  {
    exit("error");
  }
}

// UTILITY FUNCTIONS

  function getDiagnosisResults($element)
  {
    $results = array();
    $children = $element->child_nodes();
    foreach ($children as $child)
    {
      if ($child->node_type() == XML_ELEMENT_NODE && $child->node_name() == 'diagnosisResult')
        $results[] = $child;
    }
    return $results;
  }

  function generateErrorTable($device, &$html)
  {
    $deviceCaption = $device->get_attribute('caption');
    $xpath = xpath_new_context($device);
    $errors = @ xpath_eval($xpath, '/error');
    $warnings = @ xpath_eval($xpath, '/warning');
    $timestamp = $device->get_attribute('time');
    if (count($errors->nodeset) > 0 || count($warnings->nodeset) > 0)
    {
      $html[] = '<tr>';
      $html[] = '<td></td>'; // empty icon column
      $html[] = '<td colspan="5" class="ew">';
      $html[] = (translate('MSG_ERRORS_AND_WARNINGS_FOR') . ' ' . $deviceCaption);
      if ($timestamp != '')
        $html[] = ('<br /><label class="t">' . $timestamp . '</label>');
      $html[] = '<table class="ew">';
      foreach ($errors->nodeset as $error)
      {
        $caption = $error->get_attribute('caption');
        $code = $error->get_attribute('code');
        if ($code == '')
          $code = $error->get_attribute('errorCode');
        $html[] = '<tr class="e">';
        $html[] = ('<th>' . translate('MSG_ERROR') . ':</th>');
        if ($code != '')
          $html[] = ('<td>' . $code . ': ' . $caption . '</td>');
        else
          $html[] = ('<td>' . $caption . '</td>');
        $html[] = '</tr>';
      }
      foreach ($warnings->nodeset as $warning)
      {
        $caption = $warning->get_attribute('caption');
        $html[] = '<tr class="w">';
        $html[] = ('<th>' . translate('MSG_WARNING') . ':</th>');
        $html[] = ('<td>' . $caption . '</td>');
        $html[] = '</tr>';
      }
      $html[] = '</table>';
      $html[] = '</td>';
    }
  }
//*/
?>
