<?php
  header('Content-type: text/plain', true);

  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Check for variables
  if (!requiredParameters('processID'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'ProcessID is missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  
  // Call AI
  $stdout = AIBridge::getProcessResult($_GET['processID']);

  // Try to convert result into XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    // Save result to idResult.xml
    $file = fopen(IDRESULT_PATH, 'w');
    fwrite($file, $xml->dump_mem(TRUE));
    fclose($file);
  }
  else
  {
    // Output error object
    die(Rosetta::arrayToJSON(array('name'=>'XML Error', 'value'=>$stdout.'\n'.$stderr)));
  }

  exit('0');
?>
