<?php
include_once '../includes/globals.php';

function parseContents($path)
{
  $path .= ('/' . LANG . '/toc.xml');
  $tocFile = file_get_contents($path);
  $document = new XMLDocument($tocFile);
  $root = $document->document_element();
  $xpath = xpath_new_context($root);
  
  define('HELP_ROOT_PATH', ($root->get_attribute('path') . LANG . '/'));
  $tableOfContents = array();
  $items = @ xpath_eval($xpath, '/page | /book');
  foreach ($items->nodeset as $item)
  {
    switch ($item->tagname())
    {
      case 'page': extractPage($item, $tableOfContents); break;
      case 'book': extractBook($item, $tableOfContents); break;
    }
  }

  return $tableOfContents;
}

/******* UTILITY FUNCTIONS ********/

function extractPage(&$page, &$target)
{
  $title = $page->get_content();
  $src = (HELP_ROOT_PATH . $page->get_attribute('src'));
  $target[] = array('type'  => 'page',
                    'title' => $title,
                    'src'   => $src);
}

function extractBook(&$book, &$target)
{
  $xpath = xpath_new_context($book);
  $titleNode = extractFirstNode($xpath, '/title');
  $title = $titleNode->get_content();
  $src = (HELP_ROOT_PATH . $book->get_attribute('src'));
  $bookArray = array('type'    => 'book',
                     'title'   => $title,
                     'content' => array());
  $items = @ xpath_eval($xpath, '/bookmark | /chapter');
  foreach ($items->nodeset as $item)
  {
    switch ($item->tagname())
    {
      case 'bookmark': extractBookmark($item, $src, $bookArray['content']); break;
      case 'chapter': extractChapter($item, $src, $bookArray['content']); break;
    }
  }
  $target[] = $bookArray;
}

function extractBookmark(&$bookmark, $src, &$target)
{
  $title = $bookmark->get_content();
  $tag = $bookmark->get_attribute('tag');
  $src = ($tag != '') ? ($src . '#' . $tag) : $src;
  $target[] = array('type'  => 'bookmark',
                    'title' => $title,
                    'src'   => $src);
}

function extractChapter(&$chapter, $src, &$target)
{
  $xpath = xpath_new_context($chapter);
  $titleNode = extractFirstNode($xpath, '/title');
  $title = $titleNode->get_content();
  $chapterArray = array('type'    => 'chapter',
                        'title'   => $title,
                        'content' => array());
  $items = $chapter->child_nodes();
  foreach ($items as $item)
  {
    if ($item->node_type() == XML_ELEMENT_NODE && $item->tagname() == 'bookmark')
      extractBookmark($item, $src, $chapterArray['content']);
  }
  $target[] = $chapterArray;
}
//*/
?>
