<?php
header('Content-type: text/html; charset=utf-8', true);
header('Cache-control: no-cache', true);
header('Pragma: no-cache');

include_once '../includes/globals.php';
include_once 'includes/parseTitles.php';
    
if (IS_WINDOWS)
  $tocPath = 'windows';
else if (IS_SOLARIS)
  $tocPath = 'solaris/online';
else if (IS_OFFLINE)
  $tocPath = 'linux/offline';
else
  $tocPath = 'linux/online';

if (isset($_GET['query']) && $_GET['query'] != '')
{
  $titles = parseTitles($tocPath);
  $query = htmlentities(stripslashes($_GET['query']), ENT_NOQUOTES, 'UTF-8');
  $regexp = "/^[^+*%#@!\(\)\{\}\[\]]+$/";
  if (preg_match($regexp, $query) == 0)
  {
    // Potentially bad query string. Discard
    $query = '';
  }

  $filepaths = glob($tocPath . '/' . LANG . '/*.htm');
  $targets = array();
  foreach ($filepaths as $path)
  {
    $content = file_get_contents($path);

    $content = file_get_contents($path);
    $content = str_replace('<', "\n<", $content);
    $content = str_replace('>', ">\n", $content);
    $content = explode("\n", $content);
    $containsQuery = false;
    foreach ($content as $line)
    {
      if (stristr($line, '<') == false && stristr($line, $query))
        $containsQuery = true;
    }
    if ($containsQuery == true)
      $targets[] = $path;
  }
  $hits = array();
  foreach ($targets as $target)
  {
    $hit = array();
    $src = basename($target);
    $hit['title'] = $titles[$src];
    $hit['link'] = ('pageview.php?path=' . $target . '&word=' . $query);
    $hits[] = $hit;
  }
}
else
{
  $query = '';
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">
<html xmlns="http://www.w3.org/TR/1999/REC-html-in-xml">
<head>
  <title>search</title>
  <link type="text/css" rel="stylesheet" media="all" href="../css/toc.css"></link>
  <script type="text/javascript">
    document.oncontextmenu = function ()
    {
      return top.CONFIG.DEBUG_ACTIVE;
    }
  </script>
</head>
<body>
  <div class="controls">
    <a target="_self" href="tableOfContents.php?path=<?php echo $tocPath; ?>">&lt; <?php echo translate('MSG_TABLE_OF_CONTENTS'); ?></a>
    <form id="search" method="get">
      <input type="text" id="query" name="query" value="<?php echo $query; ?>" />
      <input type="submit" value="<?php echo translate('MSG_SEARCH'); ?>" />
    </form>
  </div>
  <div class="links">
  <?php
  if (!isset($query) || $query == '')
  {
    echo ('<p>' . translate('MSG_PLEASE_ENTER_QUERY') . '</p>');
  }
  else if (!isset($hits) || count($hits) <= 0)
  {
    echo ('<p>' . translate('MSG_NO_TOPICS_FOUND') . '</p>');
  }
  else
  {
    echo '<ul>';
    foreach ($hits as $hit)
    {
      echo('<li><a target="contentFrame" href="' . $hit['link'] . '">' . $hit['title'] . '</a></li>');
    }
    echo '</ul>';
  }
  ?>
  </div>
</body>
</html>
