<?php
require_once 'globals.php';

class FilePrompter
{
  function prepareForSaving()
  {
    touch(PHP_DIRECTORY . 'saving.flg');
  }

  function promptForSave($filename, $filecontent, $filetype=null)
  {
    if ($filetype == null)
    {
      $extension = pathinfo($filename, PATHINFO_EXTENSION);
      switch ($extension)
      {
        case 'xml':
          $filetype = 'text/xml';
        break;

        case 'html':
          $filetype = 'text/html';
        break;

        default:
          $filetype = 'text/plain';
        break;
      }
    }

    if (is_array($filecontent))
      $filecontent = implode('', $filecontent);

    $filelength = mb_strlen($filecontent, '8bit');
    $filename = str_replace(' ', '_', $filename);
    if (!headers_sent())
    {
      header("Content-type: $filetype; charset=utf-8", true);
      header("Content-length: $filelength", true);
      header("Content-disposition: attachment; filename=$filename", true);
    }
    
    echo $filecontent;
    unlink(PHP_DIRECTORY . 'saving.flg');
  }
}
?>
