<?php

function parseSurvey($category='overview')
{
  if (!file_exists(IDRESULT_PATH))
    return -1; // file missing error

  $surveyData = array();

  $idResult = file_get_contents(IDRESULT_PATH);
  $xml = new XMLDocument($idResult);
  $xpath = xpath_new_context($xml->document_element());

  if ($category == 'all')
    $categoryNodes = @ xpath_eval($xpath, '/diagOutput/category');
  else
    $categoryNodes = @ xpath_eval($xpath, ('/diagOutput/category[@name="' . $category . '"]'));

  foreach ($categoryNodes->nodeset as $category)
  {
    $categoryData = array();
    $categoryData['name'] = $category->get_attribute('name');
    $categoryData['caption'] = $category->get_attribute('caption');

    $children = $category->child_nodes();
    $categoryData['children'] = array();
    foreach ($children as $child)
    {
      if (isChildValid($child))
        $categoryData['children'][] = parseSurveyChild($child);
    }

    $surveyData[] = $categoryData;
  }
  return $surveyData;
}

function parseSurveyChild(&$data)
{
  $childData = array();
  $childData['caption'] = $data->get_attribute('caption');
  $childData['isHexData'] = ($data->get_attribute('hexData') == '1') ? true : false;
  $childData['isAdvanced'] = ($data->get_attribute('techDetail') == '1') ? true : false;
  $childData['value'] = extractValue($data, $childData['caption']);

  $children = $data->child_nodes();
  $childData['children'] = array();
  foreach ($children as $child)
  {
    if (isChildValid($child))
      $childData['children'][] = parseSurveyChild($child);
  }

  return $childData;
}

function extractValue($data, $nullMatch='')
{
  $returnVal = '';
  $value = $data->get_attribute('value');
  $description = $data->get_attribute('description');
  if ($value != '' && $value != $nullMatch)
    $returnVal = $value;
  else if ($description != '' && $description != $nullMatch)
    $returnVal = $description;
  return $returnVal;
}

function isChildValid($child)
{
  $returnVal = false;
  if ($child->node_type() == XML_ELEMENT_NODE)
  {
    $validTagnames = array('device', 'structure', 'property');
    $tagname = $child->tagname();
    $testOnly = $child->get_attribute('testOnly');
    if ($testOnly != '1' &&
        in_array($tagname, $validTagnames))
      $returnVal = true;
  }
  return $returnVal;
}
//*/
?>
